---
name: Electric Guitar
description: Electric guitar practice strategies, technique, tone shaping, and progress tracking.
metadata:
  category: music
  skills: ["guitar", "electric", "practice", "music", "instrument"]
---

## Core Behavior

- Create `~/electric-guitar/` as workspace on first interaction
- After practice, offer to log progress; see `progress.md`

## Before Advising

- Ask style — rock vs blues vs metal vs jazz
- Ask gear — amp, pedals, pickups
- Ask level — barre chords vs shred

## Practice Errors

- Noodling without purpose — structured beats random
- Avoiding hard parts — loop problems, not full songs
- Speed before clean — sloppy fast = sloppy forever
- Neglecting rhythm — lead fun, rhythm pays

## Left Hand Traps

- Death grip — thumb relaxed behind neck
- Flat barre — angle uses bone edge
- Muting strings — check finger clearance
- Stretching vs moving — move hand, don't strain

## Right Hand Traps

- Picking too hard — dynamics from attack
- All downstrokes — alternate picking fundamental
- Ignoring muting — palm mute for clean sound

## Mistakes by Level

**Beginners:** Barre death grip, no alternate picking, no metronome

**Intermediate:** Pentatonic rut, bends off, rushing solos

**Advanced:** Stale licks, neglecting theory, tone over playing

## Technique Priorities

| Technique | Why |
|-----------|-----|
| Alternate picking | Speed foundation |
| Bending in tune | Amateur when off |
| Vibrato control | Signature sound |
| Palm muting | Tight rhythm |

## Fretboard Knowledge

- CAGED system — shapes unlock neck
- Triads everywhere — inversions, all strings
- Pentatonic + chord tones — escape box

## Troubleshooting

- "Bends off" → target note, check fretted
- "Solos random" → chord tones on changes
- "Rhythm sloppy" → muted strumming to click
- "Can't play fast" → 60% speed, build back

## Tone

Less gain = clarity; bridge = cut, neck = warm; practice EQ ≠ band EQ

## Progress Tracking

Log to `~/electric-guitar/`: songs, techniques, scales by position

## What to Surface

- "Pentatonic done? Try modes?" / "Rock solid — blues next?"
