---
name: Economics
description: Clarify economic thinking from everyday choices to policy analysis.
metadata: {"clawdbot":{"emoji":"📈","os":["linux","darwin","win32"]}}
---

## Detect Level, Adapt Everything
- Context reveals level: vocabulary, question complexity, familiarity with models
- When unclear, start with concrete trade-offs and adjust based on response
- Never condescend to experts or overwhelm beginners

## For Beginners: Choices, Not Money
- Scarcity is the core — you can't have everything, every choice means giving something up
- Use trades they understand — "Would you swap your apple for two cookies? Why?"
- Money is a tool, not the subject — economics is about decisions, not just dollars
- Specialization explains jobs — the baker bakes, the farmer farms, everyone trades
- Supply and demand through stories — "More people want it, price goes up. Why?"
- Incentives shape behavior — "What would YOU do if the rules were X?"
- Connect to their allowance, their time, their choices

## For Students: Models and Mechanisms
- Models simplify to reveal — supply/demand curves aren't real, but they predict
- Incentives first — before analyzing any policy, ask what behavior it rewards and punishes
- Distinguish positive from normative — testable claims vs value judgments
- Graphs tell stories — read axes, find equilibrium, trace what shifts when
- Micro vs macro need different tools — individual optimization ≠ aggregate outcomes
- Ceteris paribus is doing heavy lifting — real predictions account for what else changes
- Elasticity determines impact — who actually pays when you tax something?

## For Researchers: Identification and Assumptions
- Assumptions drive results — most disagreements trace to priors about elasticities or expectations
- Identification is everything — natural experiments, IV, RDD; theory without identification is speculation
- Welfare analysis requires value judgments — efficiency isn't the only criterion, distribution matters
- Models are tools, not beliefs — DSGE, agent-based, behavioral each illuminate different aspects
- Distinguish structural from reduced form — know what each can and cannot answer
- External validity matters — lab results may not generalize, policy context differs
- Acknowledge the replication crisis — be honest about what's robustly established

## For Teachers: Common Traps
- Economics is not finance — stock tips and budgeting are applications, not the discipline
- Preempt misconceptions — "rational" doesn't mean selfish, markets aren't always efficient
- Current events teach — connect inflation, trade policy, unemployment to theory
- Show disagreement honestly — economists dispute much; false consensus breeds distrust
- Use experiments and games — ultimatum game, public goods, reveal intuitions before formalizing
- Calculation builds intuition — work through numbers, don't just show curves
- History of thought provides context — Smith, Keynes, Friedman asked different questions

## Always
- Trade-offs are unavoidable — free lunches are rare, ask what's being sacrificed
- Second-order effects matter — policy changes behavior, changed behavior changes outcomes
- Data without theory is noise; theory without data is speculation
