# Platforms — Costs and Decision Framework

## Platform Comparison (Spain, 2024)

### Shopify
| Tier | Monthly | Transaction Fee | Best For |
|------|---------|-----------------|----------|
| Basic | €27 | 2% (+ payment processor) | Starting out, <€10k/mo |
| Shopify | €79 | 1% | Growing, €10-50k/mo |
| Advanced | €289 | 0.5% | €50k+/mo, need reports |

**Real cost for €5,000/mo revenue:** ~€77-127/mo (plan + fees)

**Pros:** Fast setup, hosted, good apps ecosystem
**Cons:** Transaction fees stack, limited customization, vendor lock-in

### WooCommerce
| Component | Monthly Cost |
|-----------|--------------|
| Hosting (decent) | €15-30 |
| SSL | Free (Let's Encrypt) |
| Essential plugins | €10-50 |
| Maintenance time | Your hours |

**Real cost:** €25-80/mo + your time

**Pros:** No transaction fees, full control, one-time plugin purchases
**Cons:** You handle security, updates, backups, scaling

### Marketplaces (Amazon, eBay, Miravia)

| Platform | Commission | Monthly Fee |
|----------|------------|-------------|
| Amazon | 7-15% by category | €39 (Pro) |
| eBay | 10-12% | Free to €30 |
| Miravia | 5-10% | Free (2024) |

**When to use:** Existing traffic, product validation, no marketing budget

## Payment Processors (Spain)

| Provider | Fee per transaction |
|----------|---------------------|
| Stripe | 1.4% + €0.25 (EU cards) |
| PayPal | 2.9% + €0.35 |
| Redsys (bank TPV) | Negotiable, typically 0.5-1% |

**For €30 sale:**
- Stripe: €0.67 fee → €29.33 net
- PayPal: €1.22 fee → €28.78 net
- Bank TPV: ~€0.30 fee → €29.70 net

**Recommendation:** Bank TPV for lowest fees once volume justifies setup.

## Shipping Carriers (Spain)

### Rates for 1kg package, peninsula
| Carrier | Retail Rate | Volume Rate (50+ pkgs/mo) |
|---------|-------------|---------------------------|
| Correos | €7-9 | €4-5 |
| SEUR | €8-12 | €4-6 |
| MRW | €7-10 | €3.50-5 |
| GLS | €6-9 | €3-4.50 |

**Aggregators (Packlink, Sendcloud):** Good for starting, rates between retail and volume.

## Legal Requirements (Spain)

### Mandatory documents
1. **Aviso Legal** — Company data, CIF/NIF
2. **Política de Privacidad** — GDPR compliant, cookies
3. **Condiciones de Venta** — Returns (14 days mandatory), warranties
4. **Cookies banner** — Consent before non-essential cookies

**Cost:** €50-150 for decent templates, €300-800 for lawyer review

### IVA / VAT
| Situation | Requirement |
|-----------|-------------|
| Sell only in Spain | Standard IVA (21%) |
| Sell to EU consumers <€10k/year | Your country's VAT |
| Sell to EU consumers >€10k/year | Register OSS (One-Stop Shop) |
| Sell outside EU | No IVA, but customs duties for buyer |

**OSS:** Single registration in Spain, report quarterly, pay VAT to each country.

### Autónomo
- **When:** Once you have regular income, or always if significant volume
- **Cost:** €80/mo (tarifa plana first 12 months), then €300+/mo
- **Alternative:** Start with "actividad económica" declaration without autónomo for very low volume

## Decision Checklist

### "Should I use Shopify or WooCommerce?"
- [ ] Do you have technical skills or access? → WooCommerce saves fees
- [ ] Need to launch in <1 week? → Shopify faster
- [ ] Budget <€30/mo? → WooCommerce
- [ ] Want zero maintenance? → Shopify
- [ ] Need heavy customization? → WooCommerce

### "Should I sell on marketplaces?"
- [ ] No existing audience? → Yes, for visibility
- [ ] High-margin products (>40%)? → Marketplaces viable
- [ ] Low-margin products? → Own store only (fees kill margin)
- [ ] Validating product-market fit? → Marketplaces first
