---
name: Ecommerce
slug: ecommerce
version: 1.0.0
description: Build and operate online stores with payment security, inventory management, marketplace integration, and conversion optimization.
metadata: {"clawdbot":{"emoji":"🛒","requires":{"bins":[]},"os":["linux","darwin","win32"]}}
---

## Quick Reference

| Topic | File |
|-------|------|
| Code traps that break production | `code-traps.md` |
| Platform comparison (costs, features) | `platforms.md` |
| Operations (stock, shipping, returns) | `operations.md` |
| Growth (CRO, upsells, LTV, benchmarks) | `growth.md` |

## Critical Code Traps

These break production and cost real money. See `code-traps.md` for full patterns.

1. **Payment idempotency** — Store `payment_intent_id`, check before processing. Webhooks retry.
2. **Inventory race conditions** — `UPDATE ... WHERE stock > 0` with `rowsAffected` check, not read-then-write.
3. **Frontend price trust** — Backend recalculates everything. Never trust client totals.
4. **Webhook signatures** — Verify `stripe-signature` or equivalent. Reject unsigned requests.
5. **Stock validation timing** — Verify at payment moment, not just add-to-cart.

## Core Rules

### When Building Stores
- Calculate ALL prices server-side — discounts, shipping, taxes, totals
- Queue transactional emails — never inline in checkout flow
- Add structured data (Schema.org Product) and canonical URLs from day one
- Implement webhook signature verification before going live

### When Operating Stores
- Monitor stock thresholds, not just zero — alert at reorder point
- Track orders stuck in "processing" >24h — detect before customer complains
- Log payment failures with context — card decline reasons matter for recovery

### When Optimizing
- Checkout recovery: 1h, 24h, 72h sequence — discount on email 3, not 1
- Free shipping threshold: current AOV + 20-30%
- Mobile: sticky add-to-cart, Apple Pay/Google Pay, LCP <2.5s

## Platform Decision Tree

- **Budget <€500/mo, <100 SKUs**: Shopify Basic or WooCommerce self-hosted
- **Multi-marketplace**: Dedicated sync tool (not manual updates)
- **>1000 SKUs or ERP**: WooCommerce/custom with PIM integration

For Spain-specific costs (IVA, OSS, carriers), see `platforms.md`.

## Scope

This skill helps with:
- Store architecture and payment integration
- Inventory and order management logic
- Marketplace listing optimization
- Conversion rate tactics with benchmarks
- Legal/fiscal guidance for EU/Spain ecommerce

This skill does NOT:
- Connect to live store APIs (explain how, not execute)
- Store business data or credentials
- Make purchasing or pricing decisions autonomously
