---
name: ecommerce-price-watcher
description: Track product prices across ecommerce sites and alert on offers or target-price hits. Use when a user wants to monitor one or many product URLs or item queries, compare current vs previous prices, detect discounts, and generate alert-ready summaries with product name, old/new price, percent drop, and direct link.
---

# Ecommerce Price Watcher

Monitor product URLs, keep price history, detect offers, and output alert-ready JSON.

## Quick start

Use `scripts/price_watch.py`.

```bash
# URL mode
python3 skills/ecommerce-price-watcher/scripts/price_watch.py add \
  --url "https://example.com/product" \
  --target-price 399990 \
  --currency CLP

# Item mode (discover URLs from query)
python3 skills/ecommerce-price-watcher/scripts/price_watch.py add-item \
  --query "iPhone 13 128GB Chile" \
  --target-price 349990 \
  --currency CLP \
  --trusted-only \
  --max-results 5

python3 skills/ecommerce-price-watcher/scripts/price_watch.py check --all
```

## Commands

- `add`: add a single product URL
- `add-item`: discover product URLs from an item query, then add watches
- `list`: list watched products
- `check --id <id>`: check one product now
- `check --all`: check all products now
- `remove --id <id>`: delete watcher
- `history --id <id>`: print full price history

## Alert behavior

A check produces alerts when at least one condition matches:

1. `price_drop`: current price < previous price
2. `target_hit`: current price <= target price

Alert payload includes:
- product id
- title
- old/new price
- drop percent (when available)
- URL
- timestamp

## Item-query mode details

`add-item` uses a lightweight search discovery flow to find candidate product links.

- `--trusted-only` restricts discovered URLs to a curated trusted domain list.
- `--max-results` controls how many links are added.
- Duplicate URLs are skipped safely.

This gives users natural language entry ("track iPhone 13 128GB") instead of forcing direct URLs.

## Parsing strategy

Use a layered parser:
1. JSON-LD `offers.price`
2. Open Graph/meta price fields
3. Generic HTML regex fallback

When multiple prices are found, choose the lowest positive value as the current offer candidate.

## Security standards

- Accept only `http`/`https` URLs.
- Enforce request timeout.
- Enforce response body size cap.
- Do not execute remote JavaScript.
- Store no API keys/tokens in watcher data.
- Treat all page content as untrusted.
- Return structured JSON for safe downstream automation.

## Limits and operational notes

- Some stores block bot-like requests (403). This is expected on certain sites.
- Price extraction is best-effort and may need store-specific adapters over time.
- For production alerting, run `check --all` on schedule and forward only non-empty `alerts`.

## Suggested scheduled usage

Run every 30–120 minutes via cron, then send each alert to Telegram/WhatsApp/Discord.
