---
name: 电商价格比较
description: 从京东、淘宝、天猫、拼多多等中国电商平台抓取商品价格并进行比较分析。当用户需要比较不同电商平台的商品价格、寻找最佳性价比、或监控商品价格变化时使用。支持关键词搜索、商品链接分析、价格历史追踪和购买建议。
---

# 电商价格比较技能

本技能帮助用户在中国主流电商平台（京东、淘宝、天猫、拼多多）之间进行商品价格比较，找出最佳购买方案。

## 快速开始

### 基本使用方式

1. **提供商品信息**：可以给商品链接或商品名称
2. **执行价格比较**：技能会自动搜索各平台的价格
3. **查看分析结果**：获得价格对比和购买建议

### 示例命令

```
# 通过商品名称搜索
比较"iPhone 15"在各平台的价格

# 通过商品链接分析
分析这个京东链接的价格：https://item.jd.com/123456.html

# 多商品比较
比较"小米手机"和"华为手机"的价格差异
```

## 核心功能

### 1. 价格抓取
- **京东**：支持自营和第三方商家
- **淘宝**：支持普通店铺和天猫店铺
- **天猫**：支持品牌官方店
- **拼多多**：支持百亿补贴和普通商品

### 2. 数据对比维度
- **价格**：商品售价、优惠价、券后价
- **运费**：包邮条件、运费金额
- **促销**：满减、折扣、赠品
- **评价**：评分、评价数量
- **店铺**：店铺评分、信誉等级

### 3. 分析算法
- **价格排序**：从低到高排列
- **性价比计算**：结合价格、评价、店铺信誉
- **风险评估**：识别价格异常或可疑商品
- **推荐方案**：给出最佳购买建议

## 技术实现

### 抓取策略

由于电商平台的防爬机制，采用混合策略：

1. **浏览器自动化**：使用Playwright进行动态页面渲染
2. **API调用**：使用平台官方API（如可用）
3. **数据缓存**：减少重复请求，提高效率

### 脚本说明

详见 [scripts/README.md](scripts/README.md) 了解各平台抓取脚本的详细说明。

## 使用场景

### 场景1：日常购物比较
用户想购买某个商品，需要知道哪个平台最便宜。

### 场景2：价格监控
用户想监控某个商品的价格变化，等待最佳购买时机。

### 场景3：批量采购
用户需要批量采购商品，需要比较不同供应商的价格。

### 场景4：市场调研
用户需要了解某个品类在各平台的价格分布。

## 注意事项

1. **价格实时性**：电商价格变化频繁，结果仅供参考
2. **库存状态**：低价商品可能缺货或限购
3. **地区差异**：价格可能因用户地区不同而变化
4. **账号差异**：不同账号可能看到不同价格（如会员价）

## 高级功能

### 价格历史追踪
使用 `scripts/price_history.py` 可以追踪商品价格变化趋势。

### 批量比较
使用 `scripts/batch_compare.py` 可以同时比较多个商品。

### 自定义权重
在 `references/comparison_logic.md` 中可以自定义价格比较的权重设置。

## 故障排除

### 常见问题

1. **抓取失败**：平台防爬机制更新，需要更新脚本
2. **价格不一致**：不同时间、不同账号看到的价格可能不同
3. **商品匹配错误**：不同平台的商品规格可能不完全相同

### 解决方案

1. 检查网络连接和代理设置
2. 尝试使用不同的用户代理
3. 手动验证商品链接是否有效

## 相关资源

- [平台API文档](references/platform_apis.md) - 各电商平台的API信息
- [比较逻辑说明](references/comparison_logic.md) - 价格比较算法详解
- [报告模板](assets/template_report.md) - 分析报告模板