# EchoDecks Skill (v1)

Integrates with EchoDecks for flashcard management, study sessions, and AI generation.

## Configuration
This skill requires the `ECHODECKS_API_KEY` environment variable to be set.

## Tools

### `echodecks_get_decks`
List all available decks or details for a specific deck.
- `id` (optional): The ID of a specific deck to retrieve.

### `echodecks_get_due_cards`
Retrieve cards that are currently due for review.
- `deck_id` (optional): Filter due cards by a specific deck ID.

### `echodecks_submit_review`
Submit a spaced repetition review for a card.
- `card_id` (required): The ID of the card being reviewed.
- `quality` (required): Integer rating (0-3).
  - 0: Again (Failure/Forgot)
  - 1: Hard
  - 2: Good
  - 3: Easy

### `echodecks_generate_cards`
Generate new flashcards from a topic or text content using AI.
- `deck_id` (required): The target deck ID for the new cards.
- `topic` (optional): A short topic string to generate from.
- `text` (optional): Raw text content to generate from.
**Note:** One of `topic` or `text` must be provided. Cost: 10 credits.

### `echodecks_generate_podcast`
Generate an audio podcast summary or conversation from a deck.
- `deck_id` (required): The source deck ID.
- `voice` (optional): Voice preference (default: "neutral").
- `type` (optional): "summary" or "conversation" (default: "summary").
**Note:** Cost: 50 credits.

### `echodecks_get_podcasts`
Retrieve existing podcasts for a deck.
- `deck_id` (optional): Filter by deck ID.
- `id` (optional): specific podcast ID.

### `echodecks_get_user_stats`
Get current user profile and study statistics.

## Implementation Details

All tools are wrappers around `skills/echodecks-v1/echodecks_client.py`.

```bash
# Example
./skills/echodecks-v1/echodecks_client.py get-due --deck-id 123
```
