# Skeptic Review — ecap-security-auditor

**Datum:** 2025-07-24  
**Reviewer:** Skeptiker-Agent (Phase 4)  
**Methode:** Alle Dateien gelesen, 3 Live-Tests durchgeführt, Test-Reports verifiziert

---

## 1. Verifizierung der Tester

### Haben die Tester wirklich getestet?

**Adversarial-Tester (PHASE3-ADVERSARIAL.md): ✅ Echt getestet.**
- Behauptungen stimmen mit Code überein: `API_URL` ist tatsächlich hardcoded in verify.sh (Zeile 7), URL-Encoding via `jq -sRr @uri` ist da (Zeile 16), Size-Check in upload.sh ist da (512000 Bytes).
- "numeric" Warnung: Tester sagt "noch 2x vorhanden aber in Warnkontext". Stimmt — Zeilen 333, 462, 468 warnen alle GEGEN numerische IDs. Korrekt beurteilt.

**Integration-Tester (PHASE3-INTEGRATION.md): ✅ Echt getestet.**
- Report ID 65 wurde tatsächlich erstellt (mein Test-Upload bekam ID 66 — sequenziell plausibel).
- Hash Mismatches stimmen — lokale Dateien wurden geändert, Registry hat alte Hashes. Korrekte Analyse.

**Docs-Tester (PHASE3-DOCS.md): ✅ Solide Analyse.**
- Konsistenz-Claims verifiziert: result-Werte, Pattern IDs, risk_score Ranges stimmen tatsächlich überein.

### Meine eigenen Tests

| Test | Ergebnis | Bewertung |
|------|----------|-----------|
| `verify.sh ecap-security-auditor` | ✅ Funktioniert. 6 Dateien dynamisch aus API. 4 Mismatches (erwartet). | Script ist solide. |
| `upload.sh /tmp/test-report.json` | ✅ Upload erfolgreich (Report ID 66). JSON validiert, Response korrekt. | Funktioniert einwandfrei. |
| SKILL.md "numeric id" Suche | ✅ Nur in Warn-Kontext (3 Stellen). Kein falscher Gebrauch. | Sauber. |

---

## 2. Was ALLE übersehen haben

### 🔴 Echte Probleme

**P1: Race Condition in verify.sh (TOCTOU)**
- verify.sh holt Hashes von der API, dann prüft es lokale Dateien sequenziell. Zwischen API-Fetch und lokalem Hash kann eine Datei geändert werden.
- **Realistische Bedrohung?** Gering — ein Angreifer müsste wissen, dass gerade verify.sh läuft. Aber bei einem supply-chain-Angriff durchaus denkbar.
- **Bewertung:** Low-risk, aber nicht dokumentiert.

**P2: `mapfile` in verify.sh ist nicht POSIX-kompatibel**
- Zeile 25: `mapfile -t FILES < <(...)` erfordert Bash ≥4.0. Funktioniert NICHT auf:
  - macOS mit Standard-Bash (3.2)
  - Alpine Linux (ash/busybox)
  - Minimale Docker-Container
- Shebang ist `#!/usr/bin/env bash` — korrekt, aber macOS-Bash ist alt.
- **Bewertung:** Medium — macOS-Entwickler werden scheitern.

**P3: Windows komplett ausgeschlossen**
- Alle Scripts sind bash. Kein PowerShell-Äquivalent, keine Erwähnung.
- `metadata` sagt `requires: bins: ["bash", "jq", "curl"]` — ehrlich, aber ein Windows-Agent wird verwirrt sein.
- **Bewertung:** Dokumentiert, aber kein Workaround angeboten (WSL-Hinweis fehlt).

**P4: `ECAP_REGISTRY_URL` Override in upload.sh ist ein Risiko**
- Ein bösartiger Fork könnte `ECAP_REGISTRY_URL` in der Umgebung setzen und alle Uploads an einen Fake-Server leiten.
- verify.sh ignoriert es (gut!), aber upload.sh und register.sh folgen ihm.
- SKILL.md warnt dagegen (Punkt 3 in Security Considerations), aber die Warnung ist subtil.
- **Bewertung:** Medium — bewusste Design-Entscheidung für Self-Hosting, aber Angriffsvektor.

**P5: Trust Score Formel — `max(0, ...)` rettet es, ABER:**
- 5 Critical Findings → `max(0, 100 - 125) = 0`. Korrekt, wird nicht negativ.
- Problem: 1 Critical (Score 75) vs 5 Low (Score 85). Ein Package mit einem Remote-Code-Exec ist "besser" als eins mit 5 fehlenden Input-Validierungen? Technisch korrekt laut Formel, aber die Gewichtung belohnt "wenige schwere" Fehler relativ.
- **Bewertung:** Die Formel ist FUNKTIONAL korrekt (max(0) verhindert Negativ-Scores). Die Gewichtung ist diskutabel aber vertretbar.

**P6: Kein Integrity-Update-Workflow dokumentiert**
- Integration-Tester hat es bemerkt (einziger Abzugspunkt). Bestätige: Es gibt keinen `integrity-update.sh` oder Anleitung wie man nach SKILL.md-Änderungen die Registry-Hashes aktualisiert.
- **Bewertung:** Wichtig für Maintainer, nicht für Konsumenten.

### 🟡 Kleinere Findings

**P7: `stat -c '%a'` vs `stat -f '%Lp'` in verify.sh**
- Zeilen 69-70 versuchen Linux und macOS Syntax. Gut! Aber: auf busybox/Alpine gibt stat manchmal andere Flags.

**P8: Keine Timeout-Absicherung für curl in Scripts**
- verify.sh und upload.sh nutzen `curl -s` ohne `--max-time`. Bei API-Hängern blockiert das Script ewig.
- **Bewertung:** Low — `set -euo pipefail` hilft nicht gegen Hänger.

**P9: upload.sh stdin-Modus (`-`) hat keinen Size-Check**
- Size-Check greift nur bei Dateien (`wc -c < "$INPUT"`). Bei `cat report.json | bash scripts/upload.sh -` wird `REPORT_JSON=$(cat)` ohne Limit gelesen.
- **Bewertung:** Medium — ein riesiger Pipe-Input könnte Memory füllen.

---

## 3. Konsistenz-Check

### JSON Format: SKILL.md vs audit-prompt.md
| Feld | SKILL.md | audit-prompt.md | Match? |
|------|----------|-----------------|--------|
| `skill_slug` | ✅ | ✅ | ✅ |
| `risk_score` | ✅ | ✅ | ✅ |
| `result` | ✅ | ✅ | ✅ |
| `findings_count` | ✅ | ✅ | ✅ |
| `findings[]` | ✅ | ✅ | ✅ |
| Finding fields | severity, pattern_id, title, description, file, line, content, confidence, remediation | Identisch | ✅ |

**Ergebnis: 100% identisch.** ✅

### Pattern ID Listen
- SKILL.md: 15 Prefixes
- audit-prompt.md: 15 Prefixes
- **Identisch.** ✅ (DESER, DESTRUCT, MANUAL, OBFUSC sind in beiden)

### curl-Befehle in SKILL.md
| Zeile | Befehl | Syntaktisch korrekt? | Copy-pasteable? |
|-------|--------|---------------------|-----------------|
| 99 | `curl -s "https://...?package=PACKAGE_NAME"` | ✅ | ✅ (nach Ersetzung) |
| 102 | `curl -s "https://...?package=PACKAGE_NAME"` | ✅ | ✅ |
| 288 | `curl -s "..." -H "Authorization: Bearer $ECAP_API_KEY"` | ✅ | ✅ |
| 292-295 | POST mit -d JSON | ✅ | ✅ |
| 334-337 | POST /fix | ✅ | ✅ |

**Alle curl-Befehle syntaktisch korrekt und copy-pasteable.** ✅

---

## 4. Production-Readiness

### Würde ich diesen Skill einem fremden Agent empfehlen?

**Ja, mit Einschränkungen.**

**Was gut ist:**
- Saubere Architektur (Gate Flow, Prompts, Scripts getrennt)
- Input-Sanitierung in Scripts (URL-Encoding, JSON-Validierung, Size-Limits)
- Hardcoded API URL für verify.sh (kein Override möglich)
- Konsistente Dokumentation zwischen allen Dateien
- Error Handling dokumentiert
- Security Considerations vorhanden und sinnvoll
- API funktioniert tatsächlich (verifiziert)

**Was fehlt:**
- macOS-Kompatibilität (mapfile)
- curl Timeouts
- stdin Size-Check in upload.sh
- Integrity-Update Workflow
- Windows/WSL Hinweis

### Größtes verbleibendes Risiko

**`ECAP_REGISTRY_URL` Override in upload.sh + register.sh.** Ein bösartiges Environment kann Credentials und Reports an einen Fake-Server umleiten. Die Warnung in SKILL.md ist da, aber ein Agent der nur die Scripts ausführt liest die vielleicht nicht.

### Gesamtnote

**7.5/10**

| Aspekt | Note | Kommentar |
|--------|------|-----------|
| Sicherheit | 8/10 | Solide, aber ECAP_REGISTRY_URL bleibt Angriffsfläche |
| Code-Qualität | 7/10 | Funktional, aber mapfile + fehlende Timeouts |
| Dokumentation | 8.5/10 | Sehr gut, konsistent, vollständig |
| Portabilität | 5/10 | Linux only, macOS fraglich, Windows ausgeschlossen |
| Testbarkeit | 8/10 | Scripts funktionieren, API antwortet korrekt |
| Production-Readiness | 7/10 | Solide MVP, nicht enterprise-ready |

**Fazit:** Gutes Skill für Linux-basierte AI-Agents. Die vorherigen Tester haben ehrlich und gründlich gearbeitet — ihre Ergebnisse stimmen mit dem Code überein. Die verbleibenden Probleme (mapfile-Portabilität, stdin-Size-Check, curl-Timeouts) sind real aber nicht kritisch. Ship it, aber fix mapfile für macOS.

---

*Skeptiker-Agent — "Vertrauen ist gut, Verifizierung ist Pflicht."*
