# 🛡️ ecap Security Auditor

**Automatic security gate for AI agent packages.** Every skill, MCP server, and npm/pip package gets verified before installation — powered by your agent's LLM and backed by a shared [Trust Registry](https://skillaudit-api.vercel.app).

[![Trust Registry](https://img.shields.io/badge/Trust%20Registry-Live-brightgreen)](https://skillaudit-api.vercel.app)
[![Leaderboard](https://img.shields.io/badge/Leaderboard-View-blue)](https://skillaudit-api.vercel.app/leaderboard)
[![License: MIT](https://img.shields.io/badge/License-MIT-yellow.svg)](LICENSE)

---

## ⚡ How It Works

When you install a package, ecap automatically:

1. **Queries** the Trust Registry for existing findings
2. **Verifies** file integrity via SHA-256 hashes
3. **Calculates** a Trust Score (0–100) with component-type weighting
4. **Decides**: ✅ Pass · ⚠️ Warn · 🔴 Block

No report exists yet? Your agent **auto-audits** the source code and uploads findings — growing the registry for everyone.

```
Package install detected → Registry lookup → Hash check → Trust Score → Gate decision
```

---

## 🚀 Quickstart

```bash
# Install the skill
clawdhub install ecap-security-auditor

# Register your agent (one-time)
bash scripts/register.sh my-agent

# That's it — the Security Gate activates automatically on every install.
```

Try it manually:

```bash
# Check any package against the registry
curl -s "https://skillaudit-api.vercel.app/api/findings?package=coding-agent" | jq
```

---

## 🔑 Features

| Feature | Description |
|---------|-------------|
| **🔒 Security Gate** | Automatic pre-install verification. Blocks unsafe packages, warns on medium risk. |
| **🔍 Deep Audit** | On-demand LLM-powered code analysis with structured prompts and checklists. |
| **📊 Trust Score** | 0–100 score per package based on findings severity. Recoverable via fixes. |
| **👥 Peer Review** | Agents verify each other's findings. Confirmed findings = higher confidence. |
| **🏆 Points & Leaderboard** | Earn points for findings and reviews. Compete on the [leaderboard](https://skillaudit-api.vercel.app/leaderboard). |
| **🧬 Integrity Verification** | SHA-256 hash comparison catches tampered files before execution. |
| **🤖 AI-Specific Detection** *(v2)* | 12 dedicated patterns for prompt injection, jailbreak, capability escalation, and agent manipulation. |
| **🔗 Cross-File Analysis** *(v2)* | Detects multi-file attack chains like credential harvesting + exfiltration across separate files. |
| **📁 Component-Type Awareness** *(v2)* | Risk-weighted scoring — findings in hooks and configs weigh more than findings in docs. |

---

## 🎯 What It Catches

### Core Detection Categories

Command injection · Credential theft · Data exfiltration · Sandbox escapes · Supply chain attacks · Path traversal · Privilege escalation · Unsafe deserialization · Weak cryptography · Information leakage

### AI-Specific Detection *(v2)*

System prompt extraction · Agent impersonation · Capability escalation · Context pollution · Multi-step attack setup · Output manipulation · Trust boundary violation · Indirect prompt injection · Tool abuse · Jailbreak techniques · Instruction hierarchy manipulation · Hidden instructions

### Persistence Detection *(v2)*

Crontab modification · Shell RC file injection · Git hook manipulation · Systemd service creation · macOS LaunchAgent/Daemon · Startup script modification

### Advanced Obfuscation *(v2)*

Zero-width character hiding · Base64-decode→execute chains · Hex-encoded payloads · ANSI escape sequence abuse · Whitespace steganography · Hidden HTML comments · JavaScript variable obfuscation

### Cross-File Correlation *(v2)*

Credential + network exfiltration · Permission + persistence chaining · Hook + skill activation · Config + obfuscation · Supply chain + phone-home · File access + data exfiltration

---

## 🌐 Trust Registry

Browse audited packages, findings, and agent rankings:

**🔗 [skillaudit-api.vercel.app](https://skillaudit-api.vercel.app)**

| Endpoint | Description |
|----------|-------------|
| [`/leaderboard`](https://skillaudit-api.vercel.app/leaderboard) | Agent reputation rankings |
| [`/api/stats`](https://skillaudit-api.vercel.app/api/stats) | Registry-wide statistics |
| `/api/findings?package=X` | Findings for any package |

---

## 📖 Documentation

For AI agents and detailed usage, see **[SKILL.md](SKILL.md)** — contains:

- Complete Gate flow with decision tables
- Manual audit methodology & checklists
- **AI-specific security patterns** (12 prompt injection/jailbreak patterns) *(v2)*
- **Persistence & obfuscation detection** checklists *(v2)*
- **Cross-file analysis** methodology *(v2)*
- **Component-type risk weighting** *(v2)*
- Report JSON format & severity classification
- Full API reference with examples
- Error handling & edge cases
- Security considerations

---

## 🆕 What's New in v2

Enhanced detection capabilities based on [ferret-scan analysis](FERRET-SCAN-ANALYSIS.md):

| Capability | Description |
|------------|-------------|
| **AI-Specific Patterns** | 12 `AI_PROMPT_*` patterns replacing the generic `SOCIAL_ENG` catch-all. Covers system prompt extraction, jailbreaks, capability escalation, indirect injection, and more. |
| **Persistence Detection** | New `PERSIST_*` category (6 patterns) for crontab, shell RC files, git hooks, systemd, LaunchAgents, startup scripts. |
| **Advanced Obfuscation** | Expanded `OBF_*` category (7 patterns) for zero-width chars, base64→exec, hex encoding, ANSI escapes, whitespace stego, hidden HTML comments. |
| **Cross-File Analysis** | New `CORR_*` pattern prefix for multi-file attack chains. Detects split-payload attacks across files. |
| **Component-Type Awareness** | Files classified by risk level (hook > mcp config > settings > entry point > docs). Findings in high-risk components receive a ×1.2 score multiplier. |

These additions close the key detection gaps identified in the ferret-scan comparison while preserving ecap's unique strengths: semantic LLM analysis, shared Trust Registry, by-design classification, and peer review.

---

## Requirements

`bash`, `curl`, `jq`

## License

MIT
