# Prompt Fix Results

**Date:** 2025-07-17  
**Scope:** audit-prompt.md, review-prompt.md  
**Principle:** Minimal changes — only fix identified inconsistencies

---

## audit-prompt.md — 3 Changes

### 1. Risk Score Guide simplified (FIX-A2)
**Before:** 5 ranges (0-10, 11-25, 26-50, 51-75, 76-100) with inconsistent `result` mapping  
**After:** 3 ranges as table (0-25→safe, 26-50→caution, 51-100→unsafe) — matches SKILL.md  
**Added:** Explicit note that ONLY `safe|caution|unsafe` are accepted values (FIX-A4)

### 2. Step 5: `recommendation` → `result` (bug fix)
**Before:** `recommendation: "safe"` — field doesn't exist in API  
**After:** `result: "safe"` — correct field name

### 3. Pattern IDs — NO CHANGE NEEDED ✅
All 4 "missing" IDs (`CRYPTO_WEAK`, `DESER`, `PATH_TRAV`, `SEC_BYPASS`) were already present in audit-prompt.md. The gap was only in SKILL.md (separate fix).

---

## review-prompt.md — 1 Change

### 1. Finding ID clarification (FIX-R1, Critical)
**Before:** Generic `FINDING_ID` placeholder — ambiguous whether to use numeric `id` or `ecap_id`  
**After:** Explicit example using `ECAP-2026-0777`, with note that numeric IDs return 404  
**Why critical:** API only accepts `ecap_id` strings for `/review` and `/fix` endpoints. Numeric IDs always fail.

---

## What was NOT changed (by design)

- All checklists, false-positive guidance, severity definitions → untouched
- JSON output template → already correct (top-level fields, no nested summary)
- `result` values in JSON template → already showed `safe|caution|unsafe`
- Pattern ID list → already complete in audit-prompt.md
- All analysis categories (Critical/High/Medium/Low/Social Engineering) → untouched
