# Prompt Engineering Report

**Date:** 2025-07-14
**Task:** Overhaul audit-prompt.md with by-design awareness + general improvements

---

## Changes Made

### audit-prompt.md — Structural Changes

1. **Reordered steps for logical flow:** Package purpose identification moved to Step 2 (before vulnerability analysis), so the agent has context before classifying findings.

2. **New Step 2: Identify Package Purpose** — Agent determines the package category and expected patterns before analysis. This prevents blind flagging of patterns that are core to the package's function.

3. **New Step 4: Classify Real vs. By-Design** — Dedicated step with four mandatory criteria (core purpose, documented, input safety, category norm). All four must be true — prevents "everything is by-design" gaming.

4. **Anti-gaming rules** — Hard cap of 5 by-design findings per audit. Mandatory justification in description field. Explicit "NEVER by-design" list for obfuscation, undocumented features, unvalidated external input.

5. **Step 5 (formerly Step 3)** — Added by-design examples to the false-positive guidance section for completeness.

6. **Step 6 (formerly Step 4)** — Updated JSON format with `by_design` (default: false) and `score_impact` fields. Updated risk_score calculation to exclude by-design findings. Added realistic example showing both by-design and real findings in same report.

7. **Step numbering shifted:** 5 → 6 (output), old 5 → 7 (upload) to accommodate new steps.

### audit-prompt.md — Language Improvements

- Removed "Follow these instructions precisely" → "Follow every step in order. Do not skip steps." (more actionable)
- Tightened wording throughout — removed filler phrases
- Added horizontal rules between steps for visual separation
- Made risk_score calculation formula explicit with example
- Consolidated redundant "accepted result values" note

### SKILL.md Changes

1. **Trust Score calculation:** Added `by_design = true → 0 penalty` rule with example
2. **Report JSON format:** Added `by_design` and `score_impact` fields to example, with field documentation
3. **Decision table:** Added note that by-design findings don't affect gate decisions

---

## Quality Check

### Simulation: Auditing llama-index-core
- Step 2 → Category: "Code execution framework" → exec(), eval(), dynamic imports are expected
- Step 3 → Finds exec(), eval(), pickle, HTTP calls, dynamic imports
- Step 4 → exec() in code runner: all 4 criteria met → by_design: true. exec() on raw HTTP input: criterion 3 fails → real vulnerability
- Step 6 → Score only counts real findings. By-design patterns visible but score-neutral
- ✅ Agent produces fair score without ignoring real risks

### Simulation: Auditing a MALICIOUS npm package
- Step 2 → Category: "Utility/Parser" → no expected dangerous patterns
- Step 3 → Finds obfuscated eval(), env var exfiltration, suspicious domain calls
- Step 4 → Obfuscation: explicitly listed as "NEVER by-design". Exfiltration: criterion 3 fails. None qualify as by-design.
- Step 6 → Full penalties applied. Score reflects true danger.
- ✅ Malicious packages are not protected by by-design classification

### Contradiction Check
- No contradictions found. Step 3 HIGH category ("eval/exec on variables even if not user-controlled") coexists with Step 4 by-design classification — the finding is still reported, just flagged and score-neutral.
- Anti-gaming rules (max 5, 4 criteria) are unambiguous.

---

## Files Modified
- `prompts/audit-prompt.md` — Full rewrite
- `SKILL.md` — Trust Score, JSON format, Decision Table sections
