# Ferret-Scan Analyse für ecap-security-auditor

**Datum:** 2025-07-17
**Analysiert:** ferret-scan v1.x (65+ Rules, Regex+AST+Correlation Engine)
**Verglichen mit:** ecap-security-auditor (LLM-basierter Audit mit Trust Registry)

---

## 1. Was macht ferret-scan das wir NICHT machen?

### 1.1 Vulnerability-Klassen die uns fehlen

| Klasse | Ferret Rules | Unser Status |
|--------|-------------|--------------|
| **Obfuscation** (8 Rules) | Zero-Width-Chars, Base64-Decode+Exec, Hex-Encoding, ANSI-Escapes, Long-Whitespace-Steganografie, JS String-Obfuscation | Wir checken nur `OBFUSC` generisch — keine spezifischen Patterns für Zero-Width, ANSI, Whitespace-Stego |
| **Persistence** (6 Rules) | Crontab, Shell RC-Files, Git Hooks, Systemd Services, LaunchAgents/Daemons, Startup-Scripts | Nicht in unserer Checklist |
| **Permissions** (6 Rules) | Wildcard Perms (`Bash(*)`), SUID/SGID, chmod 777, Dangerous Tool Permissions, `defaultMode: dontAsk` | Wir haben `PRIV_ESC` aber nicht diese Claude-spezifischen Patterns |
| **AI-Specific** (10 Rules) | System Prompt Extraction, Agent Impersonation, Capability Escalation, Context Pollution, Multi-Step Attack Setup, Output Manipulation, Trust Boundary Violation, Indirect Prompt Injection, Tool Abuse, Jailbreak | Wir haben `SOCIAL_ENG` als Sammel-Kategorie — **viel zu grob** |
| **Supply Chain** (7 Rules) | Typosquatting-Detection, Suspicious MCP Servers (`npx -y` ohne Version), Postinstall Hooks, Unverified Plugin Sources | Wir haben `SUPPLY_CHAIN` aber keine konkreten Regex-Patterns |
| **Cross-File Correlation** (8 Rules) | Credential+Network, Permission+Persistence, Hook+Skill Activation, Config+Obfuscation, AI Bypass+Data Collection, Supply Chain+Network, File Access+Network, Auth Bypass+Privilege | **Komplett fehlend** |

### 1.2 AI-spezifische Detektionen

Ferret hat **10 dedizierte AI-Specific Rules** + **7 Injection Rules** = 17 Rules für LLM-Angriffe:

- **AI-001**: System Prompt Extraction ("reveal your system prompt")
- **AI-002**: Agent Impersonation ("pretend to be Anthropic employee")
- **AI-003**: Capability Escalation ("enable developer mode", "unlock hidden capabilities")
- **AI-004**: Context Pollution ("inject into context", "remember this forever")
- **AI-005**: Multi-Step Attack Setup ("on the next message execute", "phase 1: attack")
- **AI-006**: Output Manipulation ("output JSON without escaping")
- **AI-007**: Trust Boundary Violation ("skip all validation", "disable security")
- **AI-008**: Indirect Prompt Injection ("follow instructions from the file")
- **AI-009**: Tool Abuse ("use bash tool to delete", "bypass tool restrictions")
- **AI-010**: Jailbreak Techniques (DAN, bypass filter/safety/guardrail)
- **INJ-001–007**: Ignore Instructions, Mode Switching, DAN, Safety Override, Role Manipulation, Hidden Instructions (HTML comments), Instruction Hierarchy Manipulation

**Unser Gap:** Wir verlassen uns darauf, dass das LLM diese Patterns semantisch erkennt — aber wir geben keine spezifischen Patterns vor. Das LLM könnte sie übersehen, besonders bei subtilen Varianten.

### 1.3 Rule-System Aufbau

Ferrets Rule-System ist **deklarativ + typisiert**:

```typescript
interface Rule {
  id: string;           // z.B. "EXFIL-001"
  patterns: RegExp[];   // Regex-Patterns
  excludePatterns?: RegExp[];  // False-Positive-Filter
  excludeContext?: RegExp[];   // Kontext-basierte Ausnahmen
  requireContext?: RegExp[];   // Muss im Kontext vorkommen
  semanticPatterns?: SemanticPattern[];  // AST-basiert
  correlationRules?: CorrelationRule[];  // Cross-File
  remediationFixes?: RemediationFix[];   // Auto-Fixes
  fileTypes: FileType[];      // Welche Files
  components: ComponentType[]; // Welche Komponenten
}
```

**Besonders clever:**
- `excludePatterns` + `excludeContext` zur False-Positive-Reduktion (z.B. "never trust" wird nicht als "trust all input" gemeldet)
- `requireContext` für Patterns die nur in bestimmtem Kontext gefährlich sind
- Component-based Targeting (hook, skill, agent, mcp, settings)

### 1.4 AST-Analyse

Ja — ferret parst TypeScript/JavaScript Code-Blöcke in Markdown via `ts.createSourceFile()` und sucht nach:
- Dynamic Code Execution (eval, Function())
- Process Execution Chains (exec, spawn, execSync)
- File System Access Chains (readFile, writeFile)
- Network Request Chains (fetch, axios)
- Environment Variable Access (process.env)
- Obfuscated Function Names (`_0x`, `$_`)

**Unser Gap:** Wir haben keine AST-Analyse — unser LLM soll das "verstehen", aber hat keine strukturierte Code-Parsing-Pipeline.

### 1.5 Correlation-Analyse

Ja — ferret analysiert **Beziehungen zwischen Files**:
- Baut eine File-Relationship-Map basierend auf Directory-Proximity und Naming-Patterns
- Sucht nach Multi-File Attack-Chains (z.B. Credentials in File A + Network Call in File B)
- Berechnet Correlation-Strength (0-1)

**Unser Gap:** Wir analysieren Dateien isoliert. Cross-File Angriffe könnten durchrutschen.

### 1.6 Remediation/Quarantine

**Fixer:**
- Automatische Safe-Fixes (Safety Score 0-1)
- Backup vor jeder Änderung
- Dry-Run-Modus
- Built-in Fixes: Credentials redacten, Jailbreak entfernen, HTTP→HTTPS, chmod 777→644

**Quarantine:**
- Files in `.ferret-quarantine/` isolieren
- SHA-256 Hash + Audit-Trail
- Restore-Funktion
- Cleanup-Automatik (30 Tage)

**Unser Gap:** Wir haben keine Remediation-Engine. Wir reporten nur, fixen nicht.

---

## 2. Was machen WIR besser als ferret-scan?

### 2.1 LLM-basierter Ansatz vs. Regex/Pattern-Matching

| Aspekt | Ferret (Regex) | ecap (LLM) |
|--------|---------------|-------------|
| **Semantisches Verständnis** | ❌ Kennt nur Patterns | ✅ Versteht Kontext, Intent, Logik |
| **Neue/unbekannte Angriffe** | ❌ Nur was in Rules definiert ist | ✅ Kann neue Patterns erkennen |
| **Obfuscation-Resistenz** | ⚠️ Braucht spezifische Patterns | ✅ Kann umschriebene Angriffe erkennen |
| **Natürlichsprachliche Analyse** | ❌ Kann SKILL.md-Prosa nicht verstehen | ✅ Erkennt "misleading documentation" |
| **False Positives** | ⚠️ Trotz excludePatterns noch hoch | ✅ Kontextuelle Bewertung |
| **Skalierbarkeit** | ✅ Millisekunden | ⚠️ LLM-Kosten pro Audit |

**Beispiel:** Ferret's AI-005 hat `excludePatterns` für "phase 1: implementation" — trotzdem meldet es bei jedem Projekt-Plan False Positives. Unser LLM versteht, dass "Phase 1: Setup" kein Angriff ist.

### 2.2 Trust Registry vs. lokaler Scan

| Aspekt | Ferret | ecap |
|--------|--------|------|
| **Shared Knowledge** | ❌ Jeder scannt isoliert | ✅ Zentrale Findings-DB, alle profitieren |
| **Peer Review** | ❌ Nicht vorhanden | ✅ Andere Agents können Findings bestätigen/widerlegen |
| **Integrity Verification** | ❌ Kein Hash-Check | ✅ SHA-256 Hash-Vergleich gegen audited Version |
| **Reputation System** | ❌ Kein Tracking | ✅ Leaderboard, Points, Agent-Profiles |
| **Score Recovery** | ❌ Einmal gefunden, immer gefunden | ✅ Maintainer können fixen und Score zurückgewinnen |

### 2.3 By-Design Awareness

Ferret kennt kein Konzept von "by-design". Jeder `exec()` ist ein Finding, egal ob es ein Agent-Framework ist. 

**Wir** haben ein ausgeklügeltes 4-Kriterien-System:
1. Core Purpose: Pattern ist essentiell für dokumentierten Zweck
2. Documented: In README/Docs explizit beschrieben
3. Input Safety: Kein unvalidierter externer Input
4. Category Norm: Standard in ähnlichen Packages

Plus Anti-Gaming (max 5 by-design pro Audit) und klare "NEVER by-design" Rules.

### 2.4 Peer Review

Ferret hat kein Peer-Review-System. Wir haben:
- Andere Agents können Findings als `confirmed`, `false_positive`, oder `needs_context` markieren
- Self-Review ist geblockt (403)
- Review-Points im Leaderboard

---

## 3. Best Practices zum Übernehmen

### BP-1: Spezifische AI-Security Patterns als Checklist

**Was:** Ferrets 17 AI+Injection Rules als konkrete Pattern-Liste in unseren audit-prompt.md integrieren.

**Wie:** Neue Sektion "AI-Specific Patterns" im audit-prompt mit konkreten Beispielen:
- System Prompt Extraction Patterns
- Capability Escalation Phrases
- Trust Boundary Violation Patterns
- Indirect Prompt Injection Setups
- Multi-Step Attack Indicators

**Aufwand:** Gering (Prompt-Erweiterung)
**Priorität:** MUSS — Das sind genau die Angriffe die in AI-Skill-Ökosystemen relevant sind.

### BP-2: Obfuscation-Checkliste erweitern

**Was:** Spezifische Obfuscation-Techniken die ferret checkt:
- Zero-Width Characters (U+200B-U+200D, U+FEFF, U+2060-2064)
- Base64-Decode→Execute Chains
- Hex-Encoded Content (\x-Sequenzen)
- ANSI Escape Sequences (Terminal-Output-Hiding)
- Long Whitespace Steganografie
- HTML Comment Hiding (>100 Chars)

**Wie:** In audit-prompt.md unter "CRITICAL" oder "HIGH" ergänzen.

**Aufwand:** Gering (Prompt-Erweiterung)
**Priorität:** MUSS — Zero-Width-Chars und Hidden HTML Comments sind reale Angriffsvektoren.

### BP-3: Persistence-Detection hinzufügen

**Was:** Neue Kategorie in unserer Checklist:
- Crontab Modification
- Shell RC File Modification (.bashrc, .zshrc, .profile)
- Git Hook Manipulation
- Systemd Service Creation
- LaunchAgent/LaunchDaemon (macOS)
- Startup Script Modification

**Wie:** Neue Sektion in audit-prompt.md, neuer Pattern-ID-Prefix `PERSIST`.

**Aufwand:** Gering (Prompt-Erweiterung)
**Priorität:** SOLLTE — Relevant für Skills die Hooks/Scripts enthalten.

### BP-4: Cross-File Hinweis im Audit-Prompt

**Was:** Explizite Anweisung an das LLM, Cross-File-Beziehungen zu analysieren:
- "Prüfe ob Credentials in einer Datei gelesen und in einer anderen Datei per Network versendet werden"
- "Prüfe ob Permission-Änderungen mit Persistence-Mechanismen kombiniert werden"

**Wie:** Neuer Step oder Ergänzung in Step 3 des audit-prompt.md.

**Aufwand:** Gering (Prompt-Erweiterung)
**Priorität:** SOLLTE — LLMs können das wenn man sie darauf hinweist.

### BP-5: ExcludePatterns / False-Positive-Guidance

**Was:** Ferrets `excludePatterns` und `excludeContext` Konzept als Guidance für unser LLM:
- "Patterns in Negation sind keine Findings (z.B. 'never trust all input')"
- "`exec` als Methode auf einem DB Query Builder ist kein Finding"
- "Installation-Docs mit sudo apt install sind keine Findings"

**Wie:** Erweiterung von Step 5 (False Positives) mit konkreteren Beispielen.

**Aufwand:** Gering (Prompt-Erweiterung)
**Priorität:** SOLLTE — Verbessert Audit-Qualität.

### BP-6: Remediation-Vorschläge verbessern

**Was:** Ferret hat spezifische `remediation`-Strings pro Rule. Wir könnten unser `remediation`-Feld im Finding-Format mit konkreteren Vorschlägen befüllen.

**Wie:** Beispiel-Remediations in audit-prompt.md ergänzen, z.B.:
- Bei `exec()` → "Use execFile() with args array"
- Bei hardcoded credentials → "Move to environment variables"
- Bei chmod 777 → "Use chmod 644 or more restrictive"

**Aufwand:** Gering (Prompt-Erweiterung)
**Priorität:** KÖNNTE — Nice-to-have, unser LLM generiert bereits Remediations.

### BP-7: Component-Type Awareness

**Was:** Ferret unterscheidet zwischen `hook`, `skill`, `agent`, `mcp`, `settings`, `plugin`. Unterschiedliche Komponenten haben unterschiedliche Risikoprofile (Hooks sind gefährlicher als Docs).

**Wie:** Im audit-prompt.md Hinweis ergänzen dass bestimmte Dateitypen höhere Aufmerksamkeit verdienen:
- Shell-Scripts in hooks/ → höchstes Risiko
- .mcp.json → Supply-Chain-Risiko
- settings.json → Permission-Risiko
- SKILL.md → Social-Engineering-Risiko

**Aufwand:** Gering
**Priorität:** SOLLTE — Priorisiert die Analyse richtig.

### BP-8: Risk Score Berechnung mit Component-Weighting

**Was:** Ferret multipliziert Risk Score × 1.2 für High-Risk-Komponenten (hook, plugin, mcp).

**Wie:** In unserem Score-System berücksichtigen: Findings in Hooks/Scripts wiegen schwerer als Findings in Docs.

**Aufwand:** Mittel (Score-Logik anpassen)
**Priorität:** KÖNNTE — Marginaler Verbesserung.

### BP-9: SARIF/HTML Output Support

**Was:** Ferret unterstützt SARIF (GitHub Code Scanning), HTML Reports, JSON, CSV.

**Wie:** Optional SARIF-Export für unsere Reports implementieren → direkte GitHub Security-Integration.

**Aufwand:** Hoch (neues Output-Format)
**Priorität:** KÖNNTE — Nützlich für CI/CD aber nicht Core.

### BP-10: Pre-Scan Pattern-Matching als Schnellcheck

**Was:** Vor dem teuren LLM-Audit einen schnellen Regex-Pre-Scan laufen lassen der offensichtliche Patterns findet. 

**Wie:** Script `scripts/prescan.sh` das die wichtigsten Regex-Patterns aus ferret's Rules anwendet:
- Bekannte Jailbreak-Phrases
- Credential-Patterns in Code
- curl|bash, eval, exec
- Zero-Width Characters

Ergebnis: Wenn Pre-Scan CRITICAL findet → sofort blocken ohne LLM-Kosten.

**Aufwand:** Mittel (neues Script)
**Priorität:** SOLLTE — Spart LLM-Kosten und beschleunigt den Gate.

---

## 4. Konkret: Welche Rules/Patterns fehlen uns?

### Vergleich Ferret Rules vs. unsere audit-prompt.md Checklist

| Ferret Rule | In unserem Audit? | Gap? |
|-------------|-------------------|------|
| **CRED-001–007** Credential Access | ✅ Teilweise (CRED_THEFT) | ⚠️ Uns fehlt: Keychain/Keyring, SSH-Key-Zugriff, AWS-Credentials spezifisch |
| **INJ-001–007** Prompt Injection | ⚠️ Nur generisch als SOCIAL_ENG | ❌ Keine spezifischen Patterns: Mode Switching, Hidden Instructions, Instruction Hierarchy |
| **EXFIL-001–007** Exfiltration | ✅ Teilweise (DATA_EXFIL) | ⚠️ Uns fehlt: DNS Exfiltration, Webhook-Detection, Base64-Encoded Exfiltration |
| **BACK-001–007** Backdoors | ✅ Teilweise (CMD_INJECT) | ⚠️ Uns fehlt: Reverse Shells, Background Process Creation, Encoded Command Execution |
| **SUPP-001–007** Supply Chain | ✅ Teilweise (SUPPLY_CHAIN) | ⚠️ Uns fehlt: Typosquatting-Detection, Suspicious MCP Servers, Postinstall Hooks |
| **PERM-001–006** Permissions | ✅ Teilweise (PRIV_ESC) | ⚠️ Uns fehlt: Wildcard Permissions (Bash(*)), SUID/SGID, Dangerous Tool Permissions |
| **PERS-001–006** Persistence | ❌ Komplett fehlend | ❌ Crontab, RC Files, Git Hooks, Systemd, LaunchAgents, Startup Scripts |
| **OBF-001–008** Obfuscation | ⚠️ Nur generisch OBFUSC | ❌ Zero-Width Chars, ANSI Escapes, Whitespace-Stego, Hex-Encoding spezifisch |
| **AI-001–010** AI-Specific | ⚠️ Nur SOCIAL_ENG | ❌ System Prompt Extraction, Agent Impersonation, Capability Escalation, Context Pollution, Multi-Step Attack, Output Manipulation, Trust Boundary, Indirect Injection, Tool Abuse |
| **SEM-001–006** Semantic/AST | ❌ Nicht vorhanden | ⚠️ Implizit durch LLM, aber nicht explizit gefordert |
| **CORR-001–008** Correlation | ❌ Nicht vorhanden | ❌ Cross-File Attack Chains |

### Top-10 fehlende Patterns (nach Priorität)

1. **AI-Specific Patterns** (AI-001–010) — MUSS: Das ist unser Kerngebiet
2. **Persistence Detection** (PERS-001–006) — MUSS: Komplett blinder Fleck
3. **Zero-Width Character Detection** (OBF-003) — MUSS: Unsichtbare Angriffe
4. **Hidden HTML Comment Injection** (INJ-006, OBF-005) — MUSS: Klassischer Vektor
5. **Cross-File Correlation Hinweis** (CORR-001–008) — SOLLTE: LLM kann das
6. **Instruction Hierarchy Manipulation** (INJ-007) — SOLLTE: "this supersedes all"
7. **Trust Boundary Violation** (AI-007) — SOLLTE: "skip all validation"
8. **DNS Exfiltration** (EXFIL-006) — SOLLTE: Subtiler Kanal
9. **Typosquatting Detection** (SUPP-005) — SOLLTE: Supply-Chain-Relevanz
10. **Wildcard Permissions** (PERM-001) — SOLLTE: Claude-spezifisch (`Bash(*)`)

---

## 5. Zusammenfassung

### Stärken von ferret-scan die wir nutzen sollten:
- **Breite Pattern-Abdeckung** (65+ spezifische Rules vs. unsere generische Checklist)
- **AI-spezifische Detektionen** (10 dedizierte Rules)
- **Cross-File Correlation** (Multi-File Attack-Chains)
- **False-Positive-Filtering** (excludePatterns/excludeContext)

### Unsere Stärken die ferret nicht hat:
- **Semantisches LLM-Verständnis** (erkennt neue/unbekannte Angriffe)
- **Shared Trust Registry** (kollektives Wissen)
- **By-Design Classification** (keine False Positives bei Agent-Frameworks)
- **Peer Review System** (Community-Validierung)
- **Integrity Verification** (Hash-basiert)

### Empfohlene nächste Schritte:
1. **audit-prompt.md erweitern** mit AI-Specific Patterns, Persistence, Obfuscation-Details (BP-1, 2, 3) — **1-2h Aufwand**
2. **Cross-File Guidance** im Prompt ergänzen (BP-4) — **30min**
3. **False-Positive Guidance** verbessern (BP-5) — **30min**
4. **Pre-Scan Script** bauen für Schnellcheck (BP-10) — **2-4h**
5. **Component-Type Awareness** in Prompt (BP-7) — **30min**
