# Documentation Review — ecap-security-auditor

**Reviewer:** Documentation & UX Subagent  
**Datum:** 2025-07-17  

---

## 1. Klarheit — **7/10**

**Stärken:**
- Das Flowchart und die Decision Table machen den Gate-Flow sofort verständlich
- Severity-Klassifikation mit konkreten Beispielen ist exzellent
- "It IS a finding / It is NOT a finding" in audit-prompt.md ist Gold wert

**Probleme:**
- **`risk_score` vs `Trust Score`** — verwirrend. `risk_score` ist 0-100 (hoch=schlecht), Trust Score ist 0-100 (hoch=gut). Die Beziehung (`Trust Score = 100 - risk_score`) wird erst spät erwähnt und ist leicht zu übersehen
- **"Auto-Audit" vs "Manual Audit"** — der Unterschied ist nicht sofort klar. Auto-Audit ist eigentlich dasselbe, nur automatisch getriggert
- **`result`-Feld**: SKILL.md sagt `"safe|caution|unsafe|clean|pass|fail"`, audit-prompt.md sagt `"safe|caution|unsafe"`. Welche Werte akzeptiert die API wirklich?

**Vorschläge:**
- Glossar-Box am Anfang: `risk_score` (API-Feld, 0=sicher, 100=gefährlich) vs `Trust Score` (angezeigte Metrik, 100=sicher)
- `result`-Werte vereinheitlichen oder klar dokumentieren welche Aliase die API akzeptiert

---

## 2. Vollständigkeit — **5/10**

**Fehlend:**
- ❌ **Keine Error-Handling-Dokumentation.** Was tun wenn:
  - API down ist? (Timeout, 5xx) → Soll der Agent trotzdem installieren? Blockieren? Warnen?
  - Upload fehlschlägt? (Rate limit, invalid JSON, auth expired)
  - `verify.sh` Hash-Mismatches findet bei einem Finding das trotzdem gefixt wurde?
  - Registrierung fehlschlägt weil Name schon vergeben?
- ❌ **Keine API-Response-Beispiele.** Was kommt bei `GET /api/findings?package=X` zurück? Wie sieht die JSON-Struktur aus? Agent muss raten oder ausprobieren
- ❌ **Keine Beispiel-Response für `/api/reports` POST.** upload.sh parst `report_id` und `findings_created`, aber das Format ist nirgends dokumentiert
- ❌ **Keine Doku für `/api/integrity` Response-Format.** verify.sh erwartet `.files["filename"].sha256` und `.repo`, `.commit`, `.verified_at` — nirgends dokumentiert
- ❌ **`/api/stats` und `/api/agents/:name`** sind in der API-Tabelle gelistet aber null dokumentiert
- ❌ **Keine Offline-Strategie.** Was wenn kein Internet? Lokaler Cache?
- ❌ **`README.md`** wird in verify.sh als tracked file gelistet, aber es gibt keine README.md im Skill

**Vorschläge:**
- Abschnitt "Error Handling" mit klaren Entscheidungen für jeden Fehlerfall
- API Response-Beispiele für jeden Endpoint (mindestens die genutzten)
- Klarstellen ob README.md existieren soll

---

## 3. Konsistenz — **6/10**

**Probleme:**
- **`skill_slug` vs `package_name`**: SKILL.md erwähnt `package_name` als "Alias", audit-prompt.md nutzt nur `skill_slug`. Scripts nutzen `package` als URL-Parameter. Drei verschiedene Begriffe
- **`result`-Werte**: SKILL.md = `"safe|caution|unsafe|clean|pass|fail"`, audit-prompt.md = `"safe|caution|unsafe"`. Inkonsistent
- **Risk Score Ranges**: SKILL.md sagt `0–25 safe, 26–50 caution, 51–100 unsafe`. audit-prompt.md sagt `0-10 clean, 11-25 safe, 26-50 caution, 51-75 unsafe, 76-100 unsafe`. Unterschiedliche Granularität
- **verify.sh Usage-Kommentar** sagt `Usage: ./scripts/verify.sh [API_URL]` (fehlt `<package-name>`), aber der tatsächliche Code erwartet `<package-name>` als erstes Argument. Der Kommentar ist falsch!
- **Clean scan**: SKILL.md Trust Score Tabelle sagt "Clean scan +5", aber audit-prompt.md sagt `recommendation: "safe"` als Feld — das Feld existiert im JSON-Format gar nicht
- **Pattern IDs**: audit-prompt.md hat zusätzliche Prefixe (`CRYPTO_WEAK`, `DESER`, `PATH_TRAV`, `SEC_BYPASS`) die in SKILL.md fehlen

**Vorschläge:**
- Ein kanonischer Begriffe: `package_name` überall ODER `skill_slug` überall
- verify.sh Kommentar fixen
- Risk Score Ranges synchronisieren
- Pattern ID Listen vereinheitlichen

---

## 4. Reihenfolge & Struktur — **8/10**

**Stärken:**
- Automatic Gate zuerst — das ist das Wichtigste und steht richtig
- Logischer Flow: Gate → Manual Audit → Trust Score → Report Format → API
- Flowchart ganz oben macht den Einstieg leicht

**Probleme:**
- Report JSON Format kommt erst NACH der API-Referenz wäre es logischer direkt nach dem Audit-Abschnitt
- "Finding IDs in API URLs" ist ein wichtiger Hinweis der leicht übersehen wird — versteckt am Ende des Gate-Abschnitts
- Configuration Section ist zu weit unten, sollte näher an Registration/Setup sein

**Vorschläge:**
- "Package Slug" und "Finding IDs" Hints in eine eigene "⚠️ Common Pitfalls" Box
- Config direkt nach Registration

---

## 5. Actionability — **6/10**

**Stärken:**
- Scripts sind gut gebaut mit klaren Error Messages
- curl-Befehle sind copy-pasteable
- Trust Score Berechnung hat ein konkretes Rechenbeispiel

**Probleme:**
- ❌ **Keine API Response Beispiele.** Ein Agent weiß nicht was `GET /api/findings?package=X` zurückgibt. Ist es `{findings: [...]}` oder `{data: {findings: [...]}}`? Wie sieht ein einzelnes Finding aus?
- ❌ **Trust Score Berechnung**: "from findings (see below)" — der Agent muss die Findings selbst parsen, aber das Response-Format ist undokumentiert
- ❌ **Kein End-to-End Beispiel.** "Agent installiert package X → was passiert Schritt für Schritt" fehlt
- ❌ **`/api/findings/:id/review`**: Das Beispiel nutzt `FINDING_ID` als Placeholder, aber der Hinweis dass es die numerische `id` sein muss (nicht `ecap_id`) steht woanders
- ❌ **verify.sh Output-Beispiel fehlt.** Was sieht der Agent wenn alles OK ist? Was wenn nicht?

**Vorschläge:**
- API Response Beispiele für jeden genutzten Endpoint
- Ein vollständiges End-to-End Walkthrough
- verify.sh Beispiel-Output in die Doku

---

## 6. Edge Cases — **3/10**

**Komplett fehlend:**
- ❌ Was tun bei API-Timeout/Downtime? (Default-allow? Default-deny?)
- ❌ Was tun bei Rate Limiting (30 reports/hour)? Retry-Strategie?
- ❌ Was wenn verify.sh einen Mismatch findet aber das Package eine neuere Version ist als die auditierte? (Legitimate Update vs. Tampering)
- ❌ Was wenn ein Finding umstritten ist? (Ein Reviewer sagt confirmed, einer sagt false_positive)
- ❌ Was wenn der Agent KEIN Internet hat?
- ❌ Was wenn `jq` oder `curl` nicht installiert sind? (Scripts handlen das, aber SKILL.md erwähnt die Voraussetzung nur im Metadata-Block)
- ❌ Was bei Packages die zu groß sind zum komplett Lesen? (z.B. 500+ Dateien)
- ❌ Was wenn config/credentials.json korrupt ist?

**Vorschläge:**
- "Edge Cases & Error Handling" Sektion mit klaren Entscheidungsregeln
- Default-Verhalten definieren: "Bei API-Fehler → WARN und user fragen, nicht still durchlassen"
- Version-Mismatch-Strategie dokumentieren

---

## Gesamtnote: **5.8 / 10**

| Kategorie | Note |
|-----------|------|
| Klarheit | 7 |
| Vollständigkeit | 5 |
| Konsistenz | 6 |
| Reihenfolge & Struktur | 8 |
| Actionability | 6 |
| Edge Cases | 3 |
| **Durchschnitt** | **5.8** |

### Zusammenfassung

Die SKILL.md hat eine **sehr gute Grundstruktur** — das Flowchart, die Decision Table und die klare Trennung von Gate/Manual Audit sind stark. Ein Agent versteht das Konzept schnell.

Die **kritischen Lücken** sind:
1. **Keine API Response Beispiele** — ein Agent muss blind raten was die API zurückgibt
2. **Kein Error Handling** — was bei Fehlern passieren soll ist komplett undokumentiert
3. **Inkonsistenzen** — `result`-Werte, Risk Score Ranges, Terminologie divergieren zwischen SKILL.md und audit-prompt.md
4. **verify.sh Kommentar ist falsch** — sagt Usage ohne package-name, braucht aber package-name

### Top 5 Fixes (Impact-Reihenfolge)

1. **API Response Beispiele** für `/api/findings`, `/api/integrity`, `/api/reports` POST
2. **Error Handling Sektion** — klare Regeln für API-down, Upload-Fehler, Hash-Mismatch-bei-Update
3. **`result`-Werte und Risk Score Ranges synchronisieren** zwischen SKILL.md und audit-prompt.md
4. **verify.sh Usage-Kommentar fixen** (`<package-name>` fehlt)
5. **Terminologie vereinheitlichen** — ein Wort für Package-Name, überall gleich
