# By-Design Findings: Research Report

> **Date:** 2026-02-02  
> **Context:** ECAP Trust Registry scores packages 0–100. Currently all findings penalize equally, causing ML/agent frameworks (llama-index, crewai, autogen) to score "caution"/"unsafe" because their core features (exec(), pickle, dynamic imports) trigger findings.

---

## 1. How Others Handle "By-Design" Findings

### CVE/NVD: DISPUTED & REJECTED Status

The CVE system has two mechanisms:
- **DISPUTED**: A CVE is tagged `** DISPUTED **` in the description when the vendor disagrees it's a vulnerability. The CVE still exists and is visible, but consumers can filter it. Daniel Stenberg (curl maintainer) has extensively documented how difficult it is to get bogus CVEs rejected — MITRE prefers DISPUTED over REJECTED.
- **REJECTED**: CNA can reject a CVE if it doesn't meet criteria. But this is rare and hard to achieve.

**Key insight:** CVE has no "by design" label. DISPUTED is the closest, but it's adversarial (reporter vs. vendor), not collaborative.

### Snyk: Won't Fix & Not Vulnerable

Snyk has the most mature model for this:
- **Ignore types:** `Won't fix`, `Not vulnerable`, `Temporarily ignore`
- **Security Policies:** Org-wide rules that auto-ignore findings matching conditions (e.g., "ignore all low-severity issues in non-production projects")
- Ignored issues are still visible but don't affect the overall score
- Reasons are documented and visible to the team

**Key insight:** Snyk separates the *existence* of a finding from its *impact on score*. This is exactly our problem.

### GitHub Advisory Database: Reviewed / Unreviewed / Withdrawn

Three categories:
- **GitHub-reviewed**: Curated, confirmed advisories
- **Unreviewed**: Auto-imported, not yet validated
- **Withdrawn**: Removed after review (has `withdrawn` timestamp)

No explicit "by design" category. Disputed advisories are either withdrawn or left with a note.

**Key insight:** The reviewed/unreviewed split is a quality gate. We could use something similar.

### npm audit: Severity Levels Only

npm audit uses only `low/moderate/high/critical`. No informational level. The `audit-level` config flag lets users skip low-severity issues, but there's no concept of "this is expected behavior."

**Key insight:** npm audit is widely criticized for false positives in dev dependencies. No good model to follow here.

### OWASP Risk Rating: Context-Aware by Design

OWASP methodology considers:
- **Threat Agent Factors**: Skill level, motive, opportunity
- **Vulnerability Factors**: Ease of exploit, awareness
- **Business Impact**: Financial, reputation, compliance

The methodology *inherently* accounts for context — a finding in a code-execution framework has different threat agent factors than in a web server.

**Key insight:** OWASP's approach supports contextual scoring, but it's designed for manual assessment, not automated registries.

### CWE: Pillar/Class/Variant Hierarchy

CWE doesn't have a "by design" category, but:
- CWE-94 (Code Injection) and CWE-78 (OS Command Injection) apply regardless of intent
- The distinction between "weakness" and "feature" is left to the assessor
- Some CWEs like CWE-489 ("Active Debug Code") acknowledge that functionality can be intentional in dev but dangerous in prod

**Key insight:** CWE treats everything as a potential weakness. Context is the assessor's job.

---

## 2. Options Analysis

### Option A: `by_design` Flag on Findings

**How it works:**
- Each finding gets an optional `by_design: true` flag
- Score penalty reduced to 25% (e.g., medium finding: -8 → -2)
- Flag is set during audit or via review endpoint

**Pros:**
- Simple to implement (one boolean field)
- Preserves the finding for transparency
- Score still reflects *some* risk (exec() IS risky, just expected)
- Works with existing penalty model

**Cons:**
- Who decides what's "by design"? Needs clear criteria
- 25% multiplier is arbitrary — why not 0% or 50%?
- Could be gamed: malicious package claims everything is "by design"

### Option B: "Informational" Severity

**How it works:**
- New severity level: `informational` (alongside critical/high/medium/low)
- Zero score impact
- Displayed in reports as documentation only

**Pros:**
- Clean separation — informational findings don't affect trust
- Common pattern in security tools (many SAST tools have this)
- Easy to understand for users

**Cons:**
- Losing signal: exec() in an ML framework IS a risk users should know about
- Binary: either it affects score or it doesn't
- Auditors must decide severity at audit time (irreversible without re-audit)

### Option C: Contextual Score Adjustment (Package Type)

**How it works:**
- Packages get a `category` (e.g., `code-execution-framework`, `web-server`, `utility`)
- Finding penalties are adjusted based on category (exec() in code-runner → low penalty; exec() in a JSON parser → full penalty)
- Requires a mapping: `{category, pattern} → multiplier`

**Pros:**
- Most accurate: reflects reality
- Same finding, different context, different score — makes sense

**Cons:**
- Complex to implement: need category taxonomy + pattern-category matrix
- Who assigns categories? Auto-detection is unreliable
- Maintenance burden: new packages, new categories
- **Overkill for our scale**

### Option D: Separate "Known Patterns" Section

**How it works:**
- Findings split into `vulnerabilities[]` and `known_patterns[]`
- Only vulnerabilities affect the score
- Known patterns displayed separately in UI ("⚠️ Known Patterns: This package uses exec() for code execution — this is expected for its purpose")

**Pros:**
- Cleanest UX: users immediately understand the distinction
- Score is honest — only real vulns count
- Patterns are documented, not hidden
- Like Snyk's approach but built into the data model

**Cons:**
- Needs curated list of known patterns (who maintains it?)
- API change: response structure changes
- Moving findings between categories requires review process

### Option E: Popularity/Trust Modifier

**How it works:**
- Packages with >X downloads or in official repos get a trust bonus
- Findings penalize less on high-trust packages

**Pros:**
- Easy to implement (pull download counts from npm/PyPI)
- Reflects real-world trust

**Cons:**
- **Dangerous:** Popular packages DO get compromised (event-stream, ua-parser-js, colors)
- Popularity ≠ security
- Creates perverse incentive: don't audit popular packages
- **Do not recommend as primary strategy**

---

## 3. Recommendation: Combine Options A + D

### Primary: Option D (Known Patterns separation) with Option A mechanics

**Why this combo works:**

1. **Option D** gives us the clean UX separation — findings vs. known patterns
2. **Option A's flag** (`by_design: true`) is the mechanism to move findings into the known patterns bucket
3. Known patterns have **zero score impact** (like Option B) but are prominently displayed (unlike Option B which hides them)

### Concrete Design

```
Score = 100 - Σ(penalties for findings WHERE by_design = false)

Known Patterns (by_design = true) → displayed but 0 penalty
Vulnerabilities (by_design = false) → full penalty per severity
```

### Who decides `by_design`?

Three sources:
1. **Pattern allowlist** (maintained in repo): Known patterns like `{pattern: "exec()", categories: ["code-execution", "agent-framework"]}` — auto-tagged during audit
2. **Reviewer override**: Via `/api/review` endpoint, a reviewer can flag a finding as by_design with a reason
3. **Community dispute**: Package maintainers can request by_design status (like CVE DISPUTED, but collaborative)

### Implementation Effort: **Low-Medium** (1-2 days)

This is mostly an API-side change + scoring logic update. No new infrastructure needed.

---

## 4. Implementation Plan

### 4.1 Database Changes

Add to findings table:
```sql
ALTER TABLE findings ADD COLUMN by_design BOOLEAN DEFAULT false;
ALTER TABLE findings ADD COLUMN by_design_reason TEXT;
```

### 4.2 API Changes

**GET /api/findings?package=X** — Response now includes `by_design` field:
```json
{
  "findings": [...],
  "known_patterns": [...],  // findings where by_design=true
  "total": 6,
  "vulnerabilities_count": 2,
  "known_patterns_count": 4
}
```

Alternative (simpler, backward-compatible): Just add `by_design` and `by_design_reason` to each finding object. Let the client separate them. **Recommend this approach** for minimum API breakage.

```json
{
  "findings": [
    {
      "id": 11,
      "ecap_id": "ECAP-2026-0782",
      "title": "Uses exec() for code execution",
      "severity": "high",
      "by_design": true,
      "by_design_reason": "Code execution framework — exec() is a core feature",
      ...
    }
  ]
}
```

**POST /api/review** — Add `by_design` field:
```json
{
  "ecap_id": "ECAP-2026-0782",
  "action": "mark_by_design",
  "reason": "exec() is the core feature of this code-execution framework"
}
```

Or simpler: extend existing review with a `by_design: true` flag alongside the status update.

### 4.3 Score Calculation Change

Current (in SKILL.md):
```
Trust Score = max(0, 100 - penalties)
Penalties: critical=-25, high=-15, medium=-8, low=-3
```

New:
```
Trust Score = max(0, 100 - penalties)
Penalties (only for findings where by_design = false):
  critical=-25, high=-15, medium=-8, low=-3
Findings where by_design = true: penalty = 0
```

### 4.4 Known Pattern Allowlist

Create `config/known-patterns.json`:
```json
[
  {
    "pattern": "exec_usage",
    "description": "Uses exec()/eval() for code execution",
    "applies_to": ["agent-framework", "code-runner", "repl", "notebook"],
    "example_packages": ["autogen-core", "crewai", "llama-index-core"]
  },
  {
    "pattern": "pickle_usage",
    "description": "Uses pickle for model serialization",
    "applies_to": ["ml-framework", "model-serving"],
    "example_packages": ["torch", "scikit-learn", "joblib"]
  },
  {
    "pattern": "dynamic_import",
    "description": "Dynamically imports modules at runtime",
    "applies_to": ["plugin-system", "agent-framework"],
    "example_packages": ["llama-index-core", "langchain"]
  },
  {
    "pattern": "telemetry",
    "description": "Sends telemetry/usage data",
    "applies_to": ["*"],
    "example_packages": ["next", "angular-cli"]
  },
  {
    "pattern": "network_access",
    "description": "Makes outbound network requests",
    "applies_to": ["api-client", "agent-framework", "mcp-server"],
    "example_packages": ["openai", "anthropic"]
  }
]
```

### 4.5 UI Display

**Trust Score display (agent output):**

```
✅ llama-index-core — Trust Score: 85/100

  Vulnerabilities: 1 medium (outdated dependency)
  Known Patterns (by design):
    ℹ️ exec() usage — expected for agent framework
    ℹ️ Dynamic imports — plugin system
    ℹ️ Network access — API calls to LLM providers
```

vs. current (broken):
```
⚠️ llama-index-core — Trust Score: 45/100
  Findings: 1 high, 3 medium, 2 low
```

### 4.6 SKILL.md Documentation Update

Add to the scoring section:

```markdown
### By-Design Findings

Some findings are **expected behavior** for certain package types. These are tagged
`by_design: true` and do NOT affect the Trust Score.

Examples:
- `exec()` in agent/code-execution frameworks
- `pickle` in ML model frameworks
- Dynamic imports in plugin systems
- Network access in API client libraries

By-design findings are still **displayed** for transparency but separated from
actual vulnerabilities. When calculating Trust Score, skip findings where
`by_design` is `true`.

**Updated Score Calculation:**
```
Trust Score = max(0, 100 - Σ penalties)
Only count findings where by_design ≠ true
```
```

### 4.7 Migration for Existing Findings

One-time script to mark existing by-design findings:

```bash
# For known agent frameworks, mark exec/eval/dynamic-import findings as by_design
curl -X POST "https://skillaudit-api.vercel.app/api/review" \
  -H "Content-Type: application/json" \
  -d '{"ecap_id": "ECAP-2026-XXXX", "by_design": true, "reason": "..."}'
```

Run for all existing findings in llama-index-core, autogen-core, crewai, etc.

---

## 5. Minimum Viable Implementation

If we want the fastest possible fix:

1. **Add `by_design` boolean to findings table** (5 min)
2. **Return it in API responses** (10 min)
3. **Update SKILL.md scoring docs** to tell agents: skip `by_design=true` findings (15 min)
4. **Manually flag existing by-design findings** via API (30 min)

Total: ~1 hour for the backend. The agents will automatically calculate correct scores because the scoring is client-side (documented in SKILL.md).

**No UI changes needed** — the agents ARE the UI. Just update the SKILL.md instructions and every agent using the skill will handle it correctly.

---

## 6. Summary Table

| Approach | Accuracy | Effort | Risk | Recommended? |
|----------|----------|--------|------|-------------|
| A: by_design flag | Good | Low | Low (could be gamed) | ✅ Yes (mechanism) |
| B: Informational severity | OK | Low | Medium (loses signal) | Partial |
| C: Contextual by category | Best | High | Low | Future enhancement |
| D: Known Patterns section | Great | Medium | Low | ✅ Yes (UX layer) |
| E: Popularity modifier | Poor | Medium | **High** (hides real vulns) | ❌ No |

**Final recommendation: A+D combined, with minimum viable path being just A (the flag) since agents handle the display logic themselves.**
