# Shipping Guide — eBay

## Carrier Selection

| Carrier | Best For | Notes |
|---------|----------|-------|
| USPS Priority | <5 lbs, fast | Free boxes, good tracking |
| USPS First Class | <1 lb, cheap | Budget option |
| USPS Media Mail | Books/DVDs | Cheapest but slow, strict rules |
| UPS Ground | >5 lbs, bulky | Better for heavy items |
| FedEx Home | Fragile, valuable | Good insurance options |

## Packaging Rules

### Materials
- Double-wall boxes for heavy items
- Bubble wrap: 2" minimum around item
- Packing paper: fill ALL voids
- Tape: quality shipping tape, not masking

### Weight Calculation
```
Actual weight vs Dimensional weight = use higher

Dimensional = (L × W × H) ÷ 139 (USPS)
Dimensional = (L × W × H) ÷ 166 (UPS/FedEx)
```

## Insurance

| Value | Recommendation |
|-------|---------------|
| <$100 | Skip (carrier usually covers) |
| $100-500 | Consider for fragile items |
| >$500 | Always insure + signature required |
| >$750 | Signature MANDATORY for seller protection |

## International Shipping

### Global Shipping Program (GSP)
- Ship to Kentucky hub only
- eBay handles customs/duties
- Higher buyer cost but zero seller hassle
- Recommended for occasional international

### Direct International
- Lower buyer cost = more sales
- YOU handle customs forms
- Risk of returns, lost packages
- Exclude high-risk countries if needed

### Countries to Watch
High fraud/loss risk: Russia, Nigeria, Indonesia, Brazil
Consider excluding or requiring additional verification.

## Handling Time

| Setting | Meaning |
|---------|---------|
| Same day | Ship within 24h, high pressure |
| 1 day | Standard, gives buffer |
| 2-3 days | Safe for side sellers |
| 3+ days | Hurts search ranking |

**Tip:** Set 1 day handling, ship faster for positive feedback boost.

## Tracking and Proof

- Always upload tracking
- Screenshot delivery confirmation
- For valuable: require signature
- Keep shipping receipts 90+ days
