# Listing Strategies — eBay

## Photo Requirements

### Minimum Standards
- 12 photos per listing (eBay allows 24)
- First photo = hero shot on white/neutral background
- Natural lighting or lightbox
- No watermarks, no text overlays
- 1600px minimum on longest edge

### Photo Sequence
1. Front full item
2. Back full item
3. All sides
4. Close-ups of features/specs
5. Defects/wear (CRITICAL for used)
6. Accessories included
7. Serial number/authenticity markers
8. Size reference if applicable

## Description Structure

```
WHAT'S INCLUDED:
- [Item]
- [Accessories]
- [Manuals/documentation]

CONDITION:
[Honest description with specific defects noted]

SPECIFICATIONS:
[Key specs in bullet points]

SHIPPING:
[Method, handling time, international policy]
```

- Plain text or minimal HTML
- Mobile-first (most buyers browse on phone)
- No walls of text
- Specifics matter more than marketing language

## Item Specifics

FILL ALL OF THEM. eBay search heavily weights item specifics.

Critical fields:
- Brand
- Model
- MPN (Manufacturer Part Number)
- UPC/EAN if available
- Condition
- Color
- Size/Capacity

Missing specifics = invisible in filtered searches.

## Category Selection

- Use the most specific category available
- Check what successful similar listings use
- Wrong category = listing removed or demoted

## Timing

| Day | Auction End Quality |
|-----|-------------------|
| Sunday 6-9 PM | Best for most items |
| Monday-Thursday | Good for business items |
| Friday/Saturday | Worst (people out) |

List end time = when people browse, not when convenient for you.
