# Music Models Reference

Complete parameter reference for all music models. All models use version `0.0.1`.

## Mureka | Create Speech

**Slug:** `mureka-create-speech`

| Parameter | Type | Required | Default | Options / Constraints | Description |
|-----------|------|----------|---------|----------------------|-------------|
| `voice_id` | string | No | — | — | Control audio generation by referencing voice, generated through the files/upload API (for voice purpose). When this ... |
| `voice` | string | No | — | Ethan,Victoria,Jake,Luna,Emma,Null | The voice to use when generating the audio. When this option is selected, other control options (voice_id) cannot be ... |
| `text` | string | Yes | — | — | — |

---

## Mureka | Recognize Song

**Slug:** `mureka-recognize-song`

| Parameter | Type | Required | Default | Options / Constraints | Description |
|-----------|------|----------|---------|----------------------|-------------|
| `upload_audio_id` | string | Yes | — | — | Upload ID of the song to be recognized, generated by the files/upload API (purpose: audio). |

---

## Mureka | Generate Instrumental

**Slug:** `mureka-generate-instrumental`

| Parameter | Type | Required | Default | Options / Constraints | Description |
|-----------|------|----------|---------|----------------------|-------------|
| `model` | string | Yes | — | auto,mureka-7.5 | — |
| `n` | integer | No | `"2"` | — | Defaults to 2, maximum 3. How many instrumentals to generate for each request. |
| `prompt` | string | Yes | — | — | — |
| `instrumental_id` | boolean | No | — | — | — |
| `stream` | boolean | No | — | — | — |

---

## Mureka | Generate Song

**Slug:** `mureka-generate-song`

| Parameter | Type | Required | Default | Options / Constraints | Description |
|-----------|------|----------|---------|----------------------|-------------|
| `lyrics` | string | Yes | — | — | — |
| `model` | string | No | `"auto"` | auto,mureka-7.5,mureka-7.6,mureka-o2,mureka-8 | — |
| `n` | integer | No | `"2"` | — | n integer Defaults to 2, maximum 3. How many songs to generate for each request. Note that you will be charged based ... |
| `prompt` | string | No | — | — | — |
| `reference_id` | string | No | — | — | Control music generation by referencing music, generated through the files/upload API (for reference purpose). Beside... |
| `vocal_id` | string | No | — | — | Control music generation by any voice you like, generated through the files/upload API (for vocal purpose). Besides i... |
| `melody_id` | string | No | — | — | Control music generation by melody idea, generated through the files/upload API (for melody purpose). Besides individ... |

---

## Mureka | Describe Song

**Slug:** `mureka-describe-song`

| Parameter | Type | Required | Default | Options / Constraints | Description |
|-----------|------|----------|---------|----------------------|-------------|
| `url` | string | Yes | — | — | — |

---

## Mureka | Extend Lyrics

**Slug:** `mureka-extend-lyrics`

| Parameter | Type | Required | Default | Options / Constraints | Description |
|-----------|------|----------|---------|----------------------|-------------|
| `lyrics` | string | Yes | — | — | Lyrics to be continued. |

---

## Mureka | Generate Lyrics

**Slug:** `mureka-generate-lyrics`

| Parameter | Type | Required | Default | Options / Constraints | Description |
|-----------|------|----------|---------|----------------------|-------------|
| `prompt` | string | Yes | — | — | The prompt to generate lyrics for. |

---

## Mureka | Create Podcast

**Slug:** `mureka-create-podcast`

| Parameter | Type | Required | Default | Options / Constraints | Description |
|-----------|------|----------|---------|----------------------|-------------|
| `conversations` | array | No | — | — | Speaker limit: This model supports exactly 2 speakers (two Voice IDs). Requests with more than two speakers are not s... |

---

## Mureka | Stem Song

**Slug:** `mureka-stem-song`

| Parameter | Type | Required | Default | Options / Constraints | Description |
|-----------|------|----------|---------|----------------------|-------------|
| `url` | string | Yes | — | — | — |

---

## Mureka | Upload File

**Slug:** `mureka-upload-file`

| Parameter | Type | Required | Default | Options / Constraints | Description |
|-----------|------|----------|---------|----------------------|-------------|
| `purpose` | string | Yes | — | reference,vocal,melody,instrumental,voice,audio | The intended purpose of the uploaded file. |
| `file` | string | Yes | — | — | — |

---

## Mureka | Extend Song

**Slug:** `mureka-extend-song`

| Parameter | Type | Required | Default | Options / Constraints | Description |
|-----------|------|----------|---------|----------------------|-------------|
| `lyrics` | string | Yes | — | — | The lyrics to be extended. |
| `extend_at` | integer | Yes | — | — | Extending start time (milliseconds). If greater than song duration, defaults to song duration. Valid range: [8000,420... |
| `upload_audio_id` | string | No | — | — | Upload ID of the song to be extended, generated by the files/upload API (purpose: audio). Only supports songs generat... |
| `song_id` | string | No | — | — | Song ID for extending, generated by the song/generate API. Mutually exclusive with the upload_audio_id parameter. |

---

## Minimax Music v2

**Slug:** `minimax-music-v2`

| Parameter | Type | Required | Default | Options / Constraints | Description |
|-----------|------|----------|---------|----------------------|-------------|
| `audio_setting` | object | No | — | — | — |
| `prompt` | string | Yes | — | — | A description of the music, specifying style, mood, and scenario. 10-300 characters. |
| `lyrics_prompt` | string | Yes | — | — | Lyrics of the song. Use n to separate lines. You may add structure tags like [Intro], [Verse], [Chorus], [Bridge], [O... |

---

## Minimax Music | V1.5

**Slug:** `minimax-music-v1-5`

| Parameter | Type | Required | Default | Options / Constraints | Description |
|-----------|------|----------|---------|----------------------|-------------|
| `prompt` | string | Yes | — | — | Lyrics, supports [intro][verse][chorus][bridge][outro] sections. 10-600 characters. |
| `lyrics_prompt` | string | Yes | — | — | Control music generation. 10-3000 characters. |

---
