---
name: Dutch
description: Write Dutch that sounds human. Not formal, not robotic, not AI-generated.
---

## The Real Problem

AI Dutch is technically correct but sounds off. Too formal. Too stiff. Natives write more directly, with particles and casual flow. Match that.

## Formality Default

Default register is too high. Dutch is notably direct. Unless explicitly formal: lean casual. "Hoi" not "Goedendag". "Ja" not "Jazeker". "Oké" not "Akkoord".

## Je vs U

Critical distinction:
- U: elderly, very formal, customer service
- Je/Jij: everyone else, default for most contexts
- Dutch internet is almost entirely je/jij
- U in casual contexts = stiff, old-fashioned

## Modal Particles

These make Dutch natural:
- Maar: softening ("Doe maar")
- Even/Effe: "just" ("Ik kijk even")
- Toch: "right?", emphasis ("Je komt toch?")
- Wel: affirmation, contrast ("Ik ga wel")
- Hoor: reassurance ("Is goed hoor")
- Nou: "well" ("Nou, dat weet ik niet")
- Missing these = textbook Dutch

## Fillers & Flow

Real Dutch has fillers:
- Nou, ja, nee (as filler, not just "no")
- Zeg maar, eigenlijk, gewoon
- Echt, enzo, ofzo
- Weet je, snap je

## Diminutives

Dutch loves diminutives (-je, -tje, -pje):
- Momentje, biertje, drankje
- Beetje, leuk dingetje
- Adds warmth and casualness
- Overuse is more natural than underuse

## Expressiveness

Don't pick the safe word:
- Goed → Leuk, Top, Gaaf, Vet
- Slecht → Kut, Klote, Bagger
- Veel → Mega, Super, Heel erg
- Mooi → Prachtig, Geweldig, Te gek

## Common Expressions

Natural expressions:
- Gezellig! (untranslatable, cozy/fun)
- Lekker (not just food - lekker weertje, lekker bezig)
- Geen probleem, Prima, Top
- Maakt niet uit, Komt goed

## Reactions

React naturally:
- Echt?, Serieus?, Meen je niet!
- Wauw!, Gaaf!, Vet!
- Jammer, Balen, Kut
- Haha, lol in text

## Belgian Dutch

If Belgian, adapt:
- Allez, Voilà, Tof
- Different expressions, softer tone
- Ge/Gij instead of Je/Jij in some regions
- Don't mix Dutch and Belgian

## English Mixing

Dutch often mixes English:
- "Dat is zo awkward"
- "Super nice!"
- "Ik ben aan het chillen"
- Natural in casual contexts

## Punctuation

Dutch punctuation:
- „Aanhalingstekens" or "quotes"
- Numbers: 1.000,50 (period thousands, comma decimals)

## The "Native Test"

Before sending: would a Dutch person screenshot this as "AI-generated"? If yes—too formal, missing particles, not gezellig. Loosen up.
