## # OpenClaw Duplicati Skill

A professional OpenClaw (Moltbot) skill for managing and monitoring Duplicati backup jobs. This skill is built for the modern Duplicati REST API (v2.1+) and uses secure JWT Bearer tokens for authentication.

## 🚀 Features

- **Modern Security**: Uses 10-year "Forever Tokens" instead of passing raw passwords.
- **Natural Language Support**: Ask for backups by name (e.g., "Start the SSD backup") and the skill handles the ID mapping.
- **Live Status Monitoring**: Get real-time updates on backup phases (Scanning, Processing, Uploading).
- **Storage Insights**: Automatically reports destination free space during status checks.
- **Log Parsing**: Quickly retrieves and explains recent backup failures or warnings.

## 🛠 Installation

Clone this repository into your OpenClaw skills directory:

```
cd ~/.openclaw/skills
git clone [https://github.com/robnew/duplicati-skill
```

 Add the configuration to your `openclaw.json` (replacing with your specific values):

```
"duplicati": {
  "enabled": true,
  "env": {
    "DUPLICATI_URL": "[http://YOUR_SERVER_IP:8200]",
    "DUPLICATI_TOKEN": "YOUR_GENERATED_FOREVER_TOKEN"
  }
}
```



## 🔑 How to Get Your API Token

Since Duplicati uses secure JWT tokens, you must generate a "Forever Token" to allow the OpenClaw agent to talk to the server.

**1.Enable Token Issuance**: On your Duplicati server, stop the service and restart it briefly with the enable flag:

###### If using systemd

```
sudo systemctl stop duplicati
duplicati-server --webservice-enable-forever-token=true
```

**2.Generate the Token**: In a second terminal on the same server, run the utility to issue your 10-year token:

```
duplicati-server-util issue-forever-token
```

Copy the long string it spits out. This is your `DUPLICATI_TOKEN`.

**3.Cleanup**: Stop the manual process (Ctrl+C) and restart your normal service:

```
sudo systemctl start duplicati
```

**4.Configure OpenClaw**: Add the token to your `openclaw.json` environment variables.
