# Dubai Transportation Guide 2025-2026

> Last updated: February 2026 | Currency: 1 AED ≈ $0.27 USD

## Overview

Dubai has a modern, efficient transport system managed by the Roads & Transport Authority (RTA). The city offers metro, buses, trams, taxis, and ride-hailing services.

---

## 🚇 Dubai Metro

### Network Overview
- **Red Line:** 52 stations, 52 km (Rashidiya ↔ UAE Exchange/Expo 2020)
- **Green Line:** 20 stations, 23 km (Etisalat ↔ Creek)
- **Operating Hours:**
  - Saturday–Wednesday: 5:00 AM – 12:00 AM (midnight)
  - Thursday: 5:00 AM – 1:00 AM
  - Friday: 9:00 AM – 1:00 AM

### Zone-Based Fare System

Dubai is divided into **7 zones**. Fares depend on zones crossed, not distance.

| Journey | Regular Class (AED) | Regular (USD) | Gold Class (AED) | Gold (USD) |
|---------|---------------------|---------------|------------------|------------|
| 1 Zone | 3.00 | $0.82 | 6.00 | $1.63 |
| 2 Zones | 5.00 | $1.36 | 10.00 | $2.72 |
| 3+ Zones | 7.50 | $2.04 | 15.00 | $4.08 |

**Note:** Nol Red Tickets (disposable) cost slightly more: AED 4/6/8.50 for 1/2/3+ zones.

### Nol Card Types

| Card | Cost (AED) | Best For | Validity |
|------|------------|----------|----------|
| **Red (Disposable)** | 2 + fare | Tourists, up to 10 trips | Single use |
| **Silver** | 25 (incl. 19 credit) | Residents, daily commuters | 5 years |
| **Gold** | 25 | Gold Class access | 5 years |
| **Blue** | Free | Students, seniors 60+, people of determination | 5 years |

### Monthly Passes (Save ~40%)

| Zones | Silver Monthly (AED) | Gold Monthly (AED) |
|-------|---------------------|-------------------|
| 1 Zone | 140 ($38) | 280 ($76) |
| 2 Zones | 230 ($63) | 460 ($125) |
| All Zones | 350 ($95) | 700 ($191) |

### Metro Tips & Rules
- ✅ Children under 5: **FREE**
- ✅ Ages 5-10: **50% discount**
- ❌ **Fines:**
  - No valid ticket: AED 200
  - Eating/drinking: AED 100
  - Sleeping on seats: AED 300
  - Gold Class without ticket: AED 100
- ⚠️ Women-only cabin in each train (first car)
- 📱 **Contactless payments** coming late 2025

### Apps
- **RTA Dubai** (official) – route planning, Nol top-up
- **S'hail** – multi-modal journey planner

---

## 🚌 Buses

Integrated with metro via Nol card. Same zone-based system.

| Journey | Fare (AED) |
|---------|------------|
| 1 Zone | 4.00 |
| 2 Zones | 6.00 |
| 3+ Zones | 8.50 |

**Monthly bus pass:** AED 200-380 depending on zones

---

## 🚕 Taxis & Ride-Hailing

### RTA Taxis (Metered)

| Component | Rate |
|-----------|------|
| **Starting fare** | AED 12 ($3.27) |
| **Per km** | AED 2.50 ($0.68) |
| **Waiting (per hour)** | AED 30 ($8.17) |
| **Airport pickup** | AED 25 starting fare |
| **Night surcharge (10pm-6am)** | +20% |

**Pink Taxis:** Women-only taxis (pink roof), request via 8009090

### Ride-Hailing Apps

| App | Type | Notes |
|-----|------|-------|
| **Careem** | Most popular in UAE | Owned by Uber, better local coverage |
| **Uber** | Available | Less common than Careem |
| **RTA Taxi** | Official app | Metered taxis |

**Typical costs:**
- Downtown to Marina: AED 35-50
- Airport to Downtown: AED 80-120
- Short trip (5km): AED 20-35

---

## 🚗 Driving in Dubai

### Driving License Exchange (2025)

**52 countries qualify for NO-TEST exchange:**

#### Automatic Exchange Countries Include:
- All GCC countries (Saudi, Oman, Qatar, Kuwait, Bahrain)
- EU/EEA countries
- USA (with caveats for some states like Texas)
- UK, Australia, New Zealand, Canada
- Japan, South Korea, Singapore, Hong Kong
- South Africa, Turkey, Ukraine

**If your country is NOT on the list:** Must take full driving course + tests (AED 5,000-10,000)

### Exchange Process (Eligible Countries)

| Step | Details | Cost (AED) |
|------|---------|------------|
| 1. Eye test | Al Jaber Optical, Yateem, etc. | 140-180 |
| 2. Apply via RTA app/website | Upload documents | — |
| 3. Submit documents | Emirates ID, passport, original license | — |
| 4. Translation (if needed) | MOJ approved | 200-300 |
| 5. License fee | Issued same day in Dubai | 600-1,100 |
| **Total** | | **950-1,500** |

**Required Documents:**
- Emirates ID
- Passport + visa page
- Original foreign driving license
- Legal translation (if not in English/Arabic)
- 3 photos

**Timeline:** Same day (Dubai), 1-2 days (Abu Dhabi, Sharjah)

### Car Ownership Costs

| Expense | Cost (AED/year) | USD |
|---------|-----------------|-----|
| Registration/licensing | 800-1,200 | $218-327 |
| Insurance (basic) | 1,500-3,500 | $408-953 |
| Gasoline (per liter) | 2.63-2.85 | $0.72-0.78 |
| Salik tolls (avg commuter) | 3,000-5,000 | $817-1,362 |
| Maintenance | 2,000-5,000 | $544-1,362 |

**Popular Car Prices (New):**
- Toyota Corolla: AED 75,000-90,000 ($20,400-24,500)
- VW Golf: AED 90,000-130,000 ($24,500-35,400)

---

## 💳 Salik (Toll System) – 2025 Variable Pricing

As of **January 31, 2025**, Dubai introduced variable toll pricing.

### Toll Rates

| Time Period | Rate (AED) | Notes |
|-------------|------------|-------|
| **Peak hours** (6-10am, 4-8pm) | 6.00 | Weekdays |
| **Off-peak** (10am-4pm, 8pm-1am) | 4.00 | — |
| **Free** (1am-6am) | 0.00 | Daily |
| **Sundays** (all day) | 4.00 | Flat rate |
| **Ramadan special hours** | Varies | Adjusted |

### 10 Salik Gates
1. Al Barsha
2. Al Safa North
3. Al Safa South (new)
4. Jebel Ali
5. Al Garhoud Bridge
6. Al Maktoum Bridge
7. Al Mamzar North
8. Al Mamzar South
9. Airport Tunnel
10. Business Bay Crossing (new)

### Getting a Salik Tag

| Purchase Method | Cost (AED) | Credit Included |
|-----------------|------------|-----------------|
| Petrol station | 100 | 50 |
| Online (delivery) | 120 | 50 |

**⚠️ Penalty:** Driving without Salik tag = **AED 100+ fine**

**Dual-gate rule:** Al Safa North/South and Al Mamzar North/South = charged only once if passed within 1 hour.

### Toll-Free Alternatives
- Al Khail Road (parallel to Sheikh Zayed Road)
- Sheikh Mohammed bin Zayed Road (E311)
- Floating Bridge (specific hours)

---

## 🚢 Water Transport

### Abra (Traditional Boat)
- **Route:** Cross Dubai Creek
- **Fare:** AED 1 (cash)
- **Frequency:** Every few minutes

### Water Bus/Taxi
- Nol card accepted
- Fares: AED 4-25 depending on route

---

## 📱 Essential Transport Apps

| App | Purpose |
|-----|---------|
| **RTA Dubai** | Official metro/bus/tram planning, Nol card |
| **S'hail** | Multi-modal journey planner |
| **Careem** | Ride-hailing (most popular) |
| **Uber** | Ride-hailing |
| **Salik** | Toll account management |
| **Google Maps** | Navigation, public transport |

---

## 💡 Pro Tips

1. **For tourists:** Get a Nol Red Day Pass (AED 20) for unlimited metro/bus travel
2. **For residents:** Silver Nol + monthly pass saves 40% vs per-trip
3. **Avoid driving during peak:** 7-9am, 5-8pm have heavy traffic
4. **Salik strategy:** Use off-peak hours or toll-free alternatives
5. **Airport transfers:** Metro to Terminal 1 & 3 for AED 3-7.50 (much cheaper than taxi)
6. **Download Careem first:** More drivers and better local coverage than Uber

---

## Comparison: Dubai vs Other Cities

| Expense | Dubai (AED/USD) | London | NYC | Singapore |
|---------|-----------------|--------|-----|-----------|
| Metro ticket | 3-7.50 / $0.82-2.04 | $3.20 | $2.90 | $0.80-2.30 |
| Monthly pass | 350 / $95 | $190 | $132 | $120 |
| Taxi per km | 2.50 / $0.68 | $2.20 | $3.00 | $0.74 |
| Gasoline (L) | 2.85 / $0.78 | $1.95 | $1.00 | $2.14 |

**Verdict:** Dubai has **cheap gas** and **affordable metro**, but **taxis are mid-range**.

---

*Sources: RTA Dubai (rta.ae), Salik (salik.ae), Numbeo, TollGuru, MOI UAE*
