# Dubai Safety Guide 2025-2026

> Last updated: February 2026

## Overview

Dubai is one of the **safest cities in the world**. It ranked **#5 out of 431 cities** in Numbeo's 2025 safety index. Violent crime against tourists is **extremely rare**. However, UAE laws differ significantly from Western countries—understanding them is crucial.

### Safety Scores (GeoSure 2025)

| Category | Score (out of 100) | Notes |
|----------|-------------------|-------|
| Physical Safety | 75 | Very safe |
| Theft | 80 | Low risk |
| Nighttime Safety | 52 | Moderate |
| Health & Medical | 68 | Good |
| Basic Freedoms | 28 | Restrictive laws |
| LGBTQ+ Safety | 43 | Caution advised |
| Women's Safety | 45 | Generally safe, be aware |

---

## 📞 Emergency Numbers

| Service | Number | Notes |
|---------|--------|-------|
| **Police** | 999 | Emergency |
| **Ambulance** | 998 | ~8 min response time |
| **Fire/Civil Defence** | 997 | — |
| **Coast Guard** | 996 | Marine emergencies |
| **Search & Rescue** | 995 | — |
| **Police (non-emergency)** | 901 | Lost, complaints |
| **Tourism Police Dubai** | 04 609 6239 | Tourist assistance |
| **Tourism Police Abu Dhabi** | 02 800 2626 | — |

### Additional Helplines

| Service | Number |
|---------|--------|
| Aman (Abu Dhabi tips) | 800 2626 |
| Al Ameen (Dubai tips) | 800 4888 |
| Domestic abuse | 800 7283 |
| Women/children (Dubai) | 04 606 0300 |
| Poison control | 800 424 |
| Labor complaints | 04 665 9999 |
| RTA customer service | 800 9090 |

---

## ⚖️ Laws You MUST Know

Dubai follows **UAE federal law** with strong Islamic (Sharia) influences. Ignorance is **NOT** an excuse.

### 🚨 Serious Offenses

| Offense | Penalty |
|---------|---------|
| **Drug possession** (any amount) | 4 years minimum, possible death penalty |
| **Drug trafficking** | Death penalty |
| **Homosexual acts** | Imprisonment, deportation |
| **Public drunkenness** | Arrest, fines, deportation |
| **Drink driving** | Zero tolerance, jail, deportation |
| **Cohabitation (unmarried)** | Legal since 2020 (was illegal) |
| **Public indecency** | Fines, imprisonment |
| **Insulting Islam/UAE** | Imprisonment |

### Alcohol Laws

| Rule | Details |
|------|---------|
| **Legal drinking age** | 21+ |
| **Where to drink** | Licensed hotels, bars, restaurants only |
| **Public intoxication** | Illegal, fines + possible jail |
| **Carrying alcohol in public** | Only in sealed bags from liquor store |
| **Drink driving** | **Zero tolerance** – any amount = jail |
| **Buying alcohol** | Need a license (easy to get) or drink at venues |

**Alcohol import limit:** 4L liquor OR 2 cartons beer per adult non-Muslim

### Dress Code

| Location | Expectation |
|----------|-------------|
| Beaches/pools | Swimwear OK at beach/pool only |
| Malls/public | Cover shoulders and knees |
| Mosques | Full coverage, headscarf for women |
| Business settings | Smart casual minimum |

**Violations:** You can be denied entry or asked to leave. Rarely fined.

### Public Behavior

| Action | Status |
|--------|--------|
| **PDA (kissing, hugging)** | Frowned upon, can be fined |
| **Holding hands** | Generally OK for married couples |
| **Swearing/rude gestures** | Illegal, can lead to fines or jail |
| **Cross-dressing** | Illegal |
| **Loud music/dancing in public** | Can be fined |
| **Arguing loudly** | Can lead to arrest |

### Social Media & Photography

| Rule | Details |
|------|---------|
| **Photographing people** | Ask permission always |
| **Photographing government/military** | Strictly prohibited |
| **Posting negative reviews** | Can lead to defamation charges |
| **Sharing rumors online** | Cybercrime offense |
| **Drones** | Require permit from DCAA |

**⚠️ Real cases:** People have been jailed for posting negative Facebook reviews of businesses.

### Medication Rules

| Status | Examples |
|--------|----------|
| **Banned** | Codeine, tramadol, some ADHD meds |
| **Restricted** | Many painkillers, anxiety meds |
| **CBD/Cannabis products** | Strictly banned (including oils) |
| **E-cigarettes** | Legal to use, regulated |

**Always:**
- Carry medications in original packaging
- Bring doctor's prescription
- Check UAE-approved list before travel
- Declare at customs if unsure

---

## 🚗 Traffic & Road Safety

Dubai has high traffic accident rates due to:
- Speeding (common)
- Aggressive driving
- Sand/dust reducing visibility

### Driver Tips

| Rule | Details |
|------|---------|
| **Speed cameras** | Everywhere, strict enforcement |
| **Mobile phone use** | AED 800 fine + 4 black points |
| **Seatbelts** | Mandatory, front and back |
| **Child seats** | Required under age 4 |
| **Tailgating** | AED 400 fine |
| **Drink driving** | Zero tolerance |

### Pedestrian Safety

- Vehicles often don't stop at crossings
- **Look both ways twice**
- Use pedestrian bridges and underpasses
- Don't jaywalk (fines apply)

### Fines

| Offense | Fine (AED) |
|---------|------------|
| Speeding 20-30 km/h over | 600 |
| Speeding 30-40 km/h over | 700 |
| Speeding 50+ km/h over | 2,000 + impound |
| Mobile phone while driving | 800 |
| No seatbelt | 400 |
| Reckless driving | 2,000 + 23 black points |

---

## 🕵️ Common Scams & Crimes

### Tourist Scams

| Scam | How It Works | Prevention |
|------|--------------|------------|
| **Fake tour operators** | Book tours, disappear | Use licensed agencies |
| **Taxi overcharging** | "Broken meter" | Insist on meter or use app |
| **Gold shop scams** | Fake gold, weight tricks | Only buy from established souks |
| **Property rental fraud** | Fake listings | Verify through DLD |
| **Romance scams** | Online dating money requests | Don't send money |
| **Lottery/inheritance** | "You've won!" emails | Ignore completely |
| **Work permit scams** | Fake job offers | Verify with MOHRE |

### Theft

| Risk Level | Context |
|------------|---------|
| Low | Streets, hotels |
| Medium | Public transport, crowded souks |
| Low | Car break-ins (rare) |

**Prevention:**
- Keep valuables in hotel safe
- Watch bags in crowded areas
- Don't leave bags unattended
- Use cut-resistant bag straps

### ATM Safety

- Use hotel or mall ATMs
- Check for skimming devices
- Cover PIN entry
- Avoid standalone street ATMs at night

---

## 👩 Women's Safety

Dubai is generally safe for women, including solo travelers.

### Tips

| Do | Don't |
|----|-------|
| Dress modestly in public | Wear revealing clothing in malls |
| Use licensed taxis | Accept rides from strangers |
| Stay in groups at night | Walk alone in isolated areas |
| Take photos of taxi details | Leave drinks unattended |
| Use pink (women-only) taxis | Make prolonged eye contact with men |

### Pink Taxis
- Driven by women, for women
- Book via RTA or call 8009090
- Available at airports

### Reporting

- Sexual harassment: Call 999
- Women's helpline: 04 606 0300
- Dubai Foundation for Women and Children

---

## 🏳️‍🌈 LGBTQ+ Travelers

**Important:** Same-sex relations are **illegal** in UAE.

| Risk | Details |
|------|---------|
| Legal status | Homosexual acts criminalized |
| Penalties | Fines, imprisonment, deportation |
| Passport "X" gender | Entry denied |

### Practical Advice

- Keep relationships private
- No PDA whatsoever
- 5-star hotels are more discreet
- Don't use dating apps openly (monitored)
- Consider different destination if safety is a concern

---

## 🏖️ Beach & Water Safety

| Hazard | Prevention |
|--------|------------|
| **Rip currents** | Swim at lifeguarded beaches |
| **Jellyfish** | Check conditions before swimming |
| **Heat stroke** | Avoid midday swimming, hydrate |
| **Sunburn** | SPF 50+, reapply frequently |

### Beach Rules
- Swimwear only at beach/pool
- Cover up when leaving beach
- No alcohol on public beaches
- No nudity (even for children)
- Topless sunbathing: Illegal

---

## 🌡️ Health & Environmental Safety

### Heat-Related Illness (Summer)

| Symptom | Action |
|---------|--------|
| Headache, dizziness | Move to A/C, hydrate |
| Nausea, rapid heartbeat | Seek shade, cool down |
| Confusion, no sweating | **Emergency** – call 998 |

### Sandstorms

| Preparation | During |
|-------------|--------|
| Check weather forecast | Stay indoors |
| Keep car fuel topped up | Close windows/vents |
| Have water supplies | Wear mask if outside |
| Keep phone charged | Drive slowly, use fog lights |

---

## 🛡️ Areas & Safety by Location

### Very Safe

- Dubai Marina
- Downtown Dubai
- Palm Jumeirah
- Dubai Mall area
- JBR (Jumeirah Beach Residence)
- DIFC

### Safe (Standard Precautions)

- Deira (old town)
- Bur Dubai
- Al Karama
- International City

### Exercise Caution

- **Labor camps** (avoid at night)
- **Industrial areas** (Al Quoz industrial parts)
- **Remote desert** (inform someone of plans)

---

## 🔒 Cybersecurity

| Rule | Details |
|------|---------|
| **VPNs** | Legal for legitimate use |
| **VoIP** | WhatsApp/FaceTime calls blocked |
| **Pornography** | Strictly illegal |
| **Gambling sites** | Blocked |
| **Crypto** | Legal but unregulated |

### Approved Calling Apps
- Botim (paid, AED 50/month)
- C'me (telecom apps)
- Microsoft Teams (business)

---

## 📋 Safety Checklist

### Before You Go
- [ ] Check medication legality
- [ ] Register with your embassy
- [ ] Get travel insurance
- [ ] Download emergency numbers
- [ ] Save embassy contact

### While There
- [ ] Carry passport copy
- [ ] Keep hotel business card (for taxi)
- [ ] Don't photograph strangers
- [ ] Respect local customs
- [ ] Drink only at licensed venues
- [ ] Never drink and drive
- [ ] Use licensed taxis/apps

### If Something Goes Wrong
- [ ] Contact police: 999
- [ ] Contact embassy
- [ ] Keep calm and cooperate
- [ ] Don't sign documents you don't understand
- [ ] Request translator if needed

---

## 🆘 Embassy Contacts

| Country | Phone | Emergency |
|---------|-------|-----------|
| USA | 04 309 4000 | Same |
| UK | 04 309 4444 | 04 309 4385 |
| Australia | 02 401 7500 | Same |
| Canada | 04 404 8444 | +1 613 996 8885 |
| India | 04 397 1222 | 04 397 1555 |

---

## ⚠️ Key Takeaways

1. **Dubai is very safe** for tourists who follow the rules
2. **Laws are strict** – don't assume Western norms apply
3. **Zero tolerance** for drugs and drink driving
4. **Respect local customs** – dress modestly, no PDA
5. **Don't post negative content** online about Dubai/UAE
6. **LGBTQ+ travelers** should exercise extreme caution
7. **Most crime is petty** (pickpocketing, scams)
8. **Traffic is the biggest danger** – drive carefully

---

*Sources: UAE Government (u.ae), Expatica, GeoSure, Numbeo, UK FCO, US State Department*
