# Moving to Dubai Guide 2025-2026

> Last updated: February 2026

## Overview

This guide covers everything you need to know about relocating to Dubai: visas, shipping, pet relocation, and settling in.

---

## 📋 Pre-Move Checklist

### 6 Months Before

| Task | Notes |
|------|-------|
| Research visa options | Employment, investor, freelance, etc. |
| Research areas to live | Based on work location, budget, lifestyle |
| Start decluttering | Shipping is expensive – less is more |
| Get quotes for shipping | If bringing furniture/belongings |
| Research schools (if kids) | Admissions can take months |
| Check pet import requirements | Microchip, vaccinations, timing |
| Medical checkups | Some medications banned in UAE |

### 3 Months Before

| Task | Notes |
|------|-------|
| Accept job offer / start visa process | Employer handles most paperwork |
| Book shipping company | If sending container |
| Apply for school admissions | Submit applications |
| Start pet export process | Vet appointments, paperwork |
| Gather documents | Apostilled, attested |
| Notify current landlord | Check notice period |
| Sell/store belongings | What you're not bringing |

### 1 Month Before

| Task | Notes |
|------|-------|
| Confirm accommodation | Temporary or permanent |
| Book flights | One-way often cheaper |
| Arrange airport pickup | Employer or taxi |
| Pack essentials carry-on | Important documents, medications |
| Cancel/transfer subscriptions | Utilities, memberships |
| Set up mail forwarding | Important correspondence |
| Exchange some currency | AED 1,000-2,000 cash |

### 1 Week Before

| Task | Notes |
|------|-------|
| Confirm shipping pickup | Final date |
| Final packing | Label boxes clearly |
| Pet preparation | Crate training, vet visit |
| Download Dubai apps | Careem, UAE Pass, etc. |
| Print important documents | Even if you have digital |
| Inform bank of travel | Avoid card blocks |

---

## 🛂 Visa Types

### Employment Visa (Most Common)

**Sponsor:** Employer

**Process:**
1. Job offer signed
2. Employer applies for entry permit
3. You enter UAE on permit (30-60 days validity)
4. Medical test (tuberculosis, HIV, hepatitis)
5. Emirates ID biometrics
6. Residence visa stamped

**Timeline:** 2-4 weeks typically
**Cost:** Usually covered by employer

**Requirements:**
- Passport (6+ months validity)
- Passport photos
- Educational certificates (attested)
- Job offer letter
- Medical test

### Golden Visa (10 years)

**Categories:**
- Investors (AED 2M+ property)
- Entrepreneurs
- Specialized talents
- Outstanding students
- Scientists/researchers

**Benefits:**
- 10-year validity
- Can sponsor family
- No employer needed
- 6+ months out of UAE allowed

### Freelance/Self-Sponsor Visa

**Options:**
- **Free Zone:** Register company (DMCC, IFZA, etc.)
- **Virtual Working Program:** Remote workers
- **Green Visa:** 5-year, self-sponsored

**Cost:** AED 15,000-30,000 for setup + annual renewal

### Tourist Visa

**Visa-on-arrival countries:** 90+ countries get 30-90 days
**Pre-approved e-visa:** Required for some nationalities
**Cost:** Free for many countries, AED 300-500 for others

---

## 📦 Shipping Belongings

### Options

| Method | Best For | Timeline | Cost |
|--------|----------|----------|------|
| **Air freight** | Urgent items | 3-7 days | $$$$ |
| **Sea freight (LCL)** | Small shipments | 4-8 weeks | $$ |
| **Sea freight (FCL)** | Full container | 4-8 weeks | $$$ |
| **Excess baggage** | Small items | Immediate | $$ |

### Container Sizes (Sea Freight)

| Size | Volume | Best For |
|------|--------|----------|
| 20ft | 33 m³ | 1-2 bedroom home |
| 40ft | 67 m³ | 3+ bedroom home |

### Cost Estimates

| Origin | 20ft Container | 40ft Container |
|--------|---------------|----------------|
| UK | $2,500-4,000 | $4,000-6,500 |
| USA (East Coast) | $3,500-5,500 | $5,500-8,000 |
| USA (West Coast) | $4,000-6,000 | $6,000-9,000 |
| Australia | $3,000-5,000 | $5,000-8,000 |
| India | $1,500-2,500 | $2,500-4,000 |

**Additional costs:**
- Insurance: 2-3% of declared value
- Customs clearance: AED 500-1,500
- Delivery to residence: AED 500-2,000
- Storage (if needed): AED 50-200/day

### Prohibited/Restricted Items

| Prohibited | Restricted |
|------------|------------|
| Alcohol | Medications (need prescription) |
| Pork products | Personal effects (duty-free) |
| Narcotics | Electronics (may have duty) |
| Weapons | Drones (need registration) |
| Pornography | Religious items (no restrictions, but sensible) |
| Israeli-origin goods | — |

### Customs Duty

| Category | Duty Rate |
|----------|-----------|
| Personal effects (used) | 0% (with residence visa) |
| New items | 5% |
| Electronics | 0-5% |
| Furniture (new) | 5% |
| Cars | 5% + registration fees |

### Recommended Shipping Companies

| Company | Type | Notes |
|---------|------|-------|
| Crown Relocations | Full-service | Premium, expensive |
| AGS Movers | Full-service | Good reputation |
| Allied Pickfords | Full-service | International network |
| Writers Relocations | Full-service | Local specialist |
| Maersk | Container shipping | Self-pack option |
| Pickford's | International | DIY-friendly |

### What to Ship vs. Buy in Dubai

| Ship | Buy in Dubai |
|------|--------------|
| Sentimental items | Furniture (good selection, reasonable prices) |
| Quality electronics (if cheaper at home) | Bedding, linens |
| Specialized equipment | Kitchen items |
| Books, photos | Basic appliances |
| Children's favorites | Clothing (malls everywhere) |
| Specific medications | Toiletries |

**Dubai tip:** IKEA, Home Centre, Pan Emirates offer good furniture at reasonable prices. Consider shipping less.

---

## 🐕 Pet Relocation

### Requirements

| Item | Requirement |
|------|-------------|
| **Microchip** | ISO 11784/11785 (15-digit) |
| **Rabies vaccination** | At least 30 days before travel, max 12 months |
| **Titer test** | Required from some countries (blood test for rabies antibodies) |
| **Health certificate** | Within 10 days of travel |
| **Import permit** | From UAE Ministry of Climate Change |

### Process Timeline

| When | Action |
|------|--------|
| **6 months before** | Ensure microchip is implanted |
| **4 months before** | Rabies vaccination (if not current) |
| **3 months before** | Rabies titer test (if required) |
| **1 month before** | Apply for UAE import permit |
| **10 days before** | Vet health certificate |
| **48 hours before** | Final vet check |

### Import Permit Requirements

**Documents needed:**
- Microchip certificate
- Rabies vaccination certificate
- Titer test results (some countries)
- Recent photos of pet
- Passport copy (owner)
- Emirates ID or visa (if resident)

**Cost:** AED 200-500 for permit
**Processing:** 3-5 working days

### Flight Options

| Type | Carrier | Notes |
|------|---------|-------|
| **Cabin** | Limited airlines | Small pets under 8kg |
| **Cargo (IPATA)** | Emirates SkyCargo, etc. | Safest for most pets |
| **Checked baggage** | Some airlines | Not recommended |

**Recommended pet relocation companies:**
- Ferndale Kennels
- Petraveller
- WorldCare Pet Transport
- British Pet Relocation

### Costs

| Service | Cost (AED) |
|---------|------------|
| Import permit | 200-500 |
| Airline cargo (small dog) | 2,500-5,000 |
| Airline cargo (large dog) | 5,000-12,000 |
| Full-service relocation | 8,000-25,000 |
| Quarantine (if required) | 1,000-2,000 |

### Banned Dog Breeds

The following breeds are **banned** in UAE:
- Pit Bull Terrier
- American Staffordshire Terrier
- Brazilian Mastiff
- Argentine Mastiff
- Japanese Tosa
- Wolf hybrids
- Perro de Presa Canario

### Pet-Friendly Housing

- Many landlords accept pets (with deposit)
- Villas generally more pet-friendly than apartments
- Some buildings have no-pet policies
- Marina, JLT, Arabian Ranches are pet-friendly areas

### UAE Pet Laws

- Dogs must be on leash in public
- Clean up after pets (fines for not doing so)
- License required from municipality
- Regular vaccinations required

---

## 🏠 Finding Accommodation

### Rental Process

1. **Search:** Bayut, Property Finder, Dubizzle
2. **View properties:** Agent accompanies
3. **Negotiate:** Rent and number of cheques
4. **Pay:** Deposit (5%) + agency fee (5%) + first cheque
5. **Ejari:** Register contract (AED 220)
6. **DEWA:** Connect utilities

### Required for Renting

| Document | Notes |
|----------|-------|
| Passport copy | All tenants |
| Visa copy | Or entry permit |
| Emirates ID | Or application receipt |
| Salary certificate | Proof of income |
| Post-dated cheques | 1-4 depending on agreement |
| Security deposit | Usually 5% annual rent |

### Upfront Costs (Example: AED 120,000/year rent)

| Cost | Amount (AED) |
|------|--------------|
| Security deposit (5%) | 6,000 |
| Agency fee (5%) | 6,000 |
| First rent cheque | 30,000-120,000 |
| Ejari registration | 220 |
| DEWA deposit | 2,000 |
| DEWA connection | 110 |
| **Minimum upfront** | **~44,330** |

### Short-Term Options

| Option | Duration | Cost/month (AED) |
|--------|----------|------------------|
| Hotel apartment | 1+ weeks | 5,000-15,000 |
| Serviced apartment | 1+ month | 8,000-20,000 |
| Airbnb | Any | Variable |
| Month-to-month rental | 3-6 months | Premium rates |

---

## 🏫 Schools (For Families)

### Application Timeline

| When | Action |
|------|--------|
| **12 months before** | Research schools |
| **9 months before** | School visits |
| **6 months before** | Submit applications |
| **3 months before** | Confirm admission |
| **1 month before** | Pay fees, get uniform |

### Application Requirements

- Birth certificate (attested)
- Previous school records
- Passport copies (child + parents)
- Vaccination records
- Emirates ID (when available)
- Assessment test (many schools)

### Top School Areas

| Area | School Quality | Notes |
|------|---------------|-------|
| Arabian Ranches | Excellent | Family suburb |
| Dubai Hills | Excellent | New, premium |
| Mirdif | Good | Affordable |
| JBR/Marina | Good | Central |
| Springs/Meadows | Good | Family communities |

---

## 📝 First Week Checklist

### Day 1-3

| Task | Priority |
|------|----------|
| Get SIM card | Immediate |
| Temporary accommodation settled | Essential |
| Medical test booked (for visa) | Required |
| Start apartment search | Important |
| Open UAE Pass account | Important |

### Day 4-7

| Task | Priority |
|------|----------|
| Emirates ID biometrics | When scheduled |
| Bank account application | After Emirates ID |
| Sign apartment lease | When found |
| Ejari registration | After lease signed |
| DEWA application | After Ejari |

### Week 2-4

| Task | Priority |
|------|----------|
| Receive Emirates ID | Usually 7-14 days |
| Finalize bank account | After Emirates ID |
| Set up internet | After moving in |
| Driver's license exchange | After Emirates ID |
| Salik registration | If driving |
| Receive shipped goods | 4-8 weeks from origin |

---

## 🛒 What to Bring

### Essential Documents (Carry-On)

| Document | Copies Needed |
|----------|---------------|
| Passport | Original + 5 copies |
| Entry permit / visa | Original + 2 copies |
| Educational certificates | Originals (attested) |
| Marriage certificate | If married (attested) |
| Birth certificates (children) | Attested |
| Medical records | Copies |
| Employment contract | Original |
| Previous bank statements | 6 months (for UAE bank) |
| Driving license | Original |
| Pet documents | If applicable |

### Personal Items (Luggage)

| Bring | Skip |
|-------|------|
| 2 weeks of clothes | Heavy winter clothes |
| Medications (with prescriptions) | Duplicate electronics |
| Important electronics | Books (heavy, buy local) |
| Toiletries (first week) | Excess kitchenware |
| Adapters (UK plugs) | Furniture |
| Photos, keepsakes | Large items |
| Children's comfort items | — |

### First Week Survival Kit

| Item | Notes |
|------|-------|
| Cash (AED 1,000+) | Some places are cash-only |
| Credit/debit card | International accepted |
| Adapter plugs | UK 3-pin (Type G) |
| Unlocked phone | For local SIM |
| Lightweight clothing | Hot even in winter |
| Sunglasses | Year-round need |
| Sandals/comfortable shoes | Lots of walking |
| Basic toiletries | First few days |

---

## 💰 Budget for First Month

### Single Professional

| Category | Amount (AED) |
|----------|--------------|
| Accommodation deposit + fees | 15,000-30,000 |
| First month rent | 5,000-10,000 |
| DEWA deposit + connection | 2,110 |
| SIM card + phone plan | 150-400 |
| Transport | 500-1,500 |
| Groceries | 1,500-2,500 |
| Dining/entertainment | 1,000-3,000 |
| Miscellaneous | 1,000-2,000 |
| **Total first month** | **26,000-52,000** |

### Family of 4

| Category | Amount (AED) |
|----------|--------------|
| Accommodation deposit + fees | 35,000-70,000 |
| First month rent | 12,000-25,000 |
| DEWA deposit + connection | 2,110-4,300 |
| School fees (deposit) | 10,000-50,000 |
| Transport | 2,000-5,000 |
| Groceries | 3,000-5,000 |
| Dining/entertainment | 2,000-5,000 |
| Miscellaneous | 3,000-5,000 |
| **Total first month** | **70,000-170,000** |

---

## 🆘 Settling In Tips

### Making Friends

| Resource | Notes |
|----------|-------|
| **InterNations** | Expat networking events |
| **Meetup.com** | Interest-based groups |
| **Facebook groups** | Dubai expat communities |
| **Sports clubs** | Tennis, running, swimming |
| **School parents** | Natural connections |
| **Work colleagues** | Social events |

### Things to Know

| Topic | Reality |
|-------|---------|
| **Friday** | Weekend day (like Sunday in West) |
| **Working week** | Mon-Fri for most private sector |
| **Ramadan** | Business hours change, no public eating/drinking |
| **Summer exodus** | Many leave Jun-Aug, city quieter |
| **Brunch culture** | Big social event, Fridays |
| **Malls** | Social centers, not just shopping |
| **Beach clubs** | Popular social/relaxation spots |

### Cultural Adjustment

| Challenge | Solution |
|-----------|----------|
| Heat | Plan around A/C, early mornings |
| Missing home | Join expat groups, video calls |
| Language | English widely spoken |
| Bureaucracy | Patience, UAE Pass helps |
| Different laws | Learn and respect them |
| Expensive lifestyle | Set budget early |

### Resources

| Resource | Purpose |
|----------|---------|
| **Expat Woman** | Women's community, advice |
| **Dubai Forums** | Q&A, recommendations |
| **Time Out Dubai** | Events, restaurants |
| **Lovin Dubai** | News, lifestyle |
| **Dubizzle** | Buy/sell, services |

---

## ✅ 90-Day Milestone Checklist

By 3 months, you should have:

- [ ] Emirates ID received
- [ ] Bank account fully functional
- [ ] Permanent accommodation secured
- [ ] Utilities running (DEWA, internet)
- [ ] Driver's license exchanged (if applicable)
- [ ] Salik set up (if driving)
- [ ] Health insurance active
- [ ] Kids enrolled in school (if applicable)
- [ ] Shipped belongings received
- [ ] Pet settled (if applicable)
- [ ] Found local services (doctor, gym, etc.)
- [ ] Made initial social connections

---

## 💡 Final Tips

1. **Join expat groups early** – invaluable for advice and friendship
2. **Budget conservatively** – first months are expensive
3. **Be patient with bureaucracy** – things take time
4. **Embrace the heat** – it's manageable with planning
5. **Explore beyond malls** – Dubai has culture, nature, history
6. **Respect local customs** – you'll be rewarded with warmth
7. **Keep documents organized** – you'll need them often
8. **Save emergency fund** – 3 months expenses recommended
9. **Don't overcommit on rent** – affects everything else
10. **Give it time** – adjustment takes 6-12 months typically

---

*Sources: UAE Government (u.ae), GDRFA, ICA UAE, various expat resources*
