# Dubai Local Services Guide 2025-2026

> Last updated: February 2026 | Currency: 1 AED ≈ $0.27 USD

## Overview

This guide covers essential local services for residents and long-term visitors: SIM cards, banking, utilities, internet, and mail.

---

## 📱 SIM Cards & Mobile

### Telecom Providers

| Provider | Network | Best For |
|----------|---------|----------|
| **Etisalat (e&)** | Largest coverage | Residents, most popular |
| **du** | Second largest | Competitive prices |
| **Virgin Mobile** | MVNO (on du) | Flexible plans |

### Tourist SIM Cards

**Available at:** Airport, malls, phone shops, supermarkets

| Provider | Plan | Data | Minutes | Validity | Price (AED) |
|----------|------|------|---------|----------|-------------|
| **Etisalat** | Visitor Basic | 2GB | 30 | 28 days | 49 ($13) |
| **Etisalat** | Visitor Plus | 6GB | 60 | 28 days | 99 ($27) |
| **Etisalat** | Visitor Premium | Unlimited | 90 | 30 days | 179 ($49) |
| **du** | Tourist SIM | 1GB | 30 | 7 days | 49 ($13) |
| **du** | Tourist Plus | 5GB | 60 | 28 days | 99 ($27) |
| **du** | Tourist Premium | 12GB | Unlimited local | 28 days | 169 ($46) |

### eSIM Options

| Provider | Data | Price (USD) |
|----------|------|-------------|
| Airalo | 1GB / 7 days | $8.50 |
| Airalo | 5GB / 30 days | $23 |
| Holafly | Unlimited / 7 days | $27 |
| Etisalat eSIM | Various | From AED 49 |

**eSIM tip:** Purchase before arrival and activate instantly.

### Resident Postpaid Plans

| Provider | Plan | Data | Price/month (AED) |
|----------|------|------|-------------------|
| **Etisalat** | Wasel Basic | 4GB | 75 |
| **Etisalat** | Wasel | 10GB | 150 |
| **Etisalat** | Premium | 25GB | 275 |
| **du** | Power | 6GB | 100 |
| **du** | Power+ | 15GB | 200 |
| **du** | Unlimited | Unlimited | 399 |

**Requirements for postpaid:**
- Emirates ID
- Passport copy
- Visa copy
- Proof of address

### VoIP & Calling

| Status | Apps |
|--------|------|
| **Blocked** | WhatsApp calls, FaceTime, Skype |
| **Allowed** | Botim (AED 50/month), C'me |
| **Business** | Microsoft Teams, Zoom (mostly works) |

**Workaround:** Many use VPN (technically legal for legitimate use).

### Top-Up Methods
- Etisalat/du apps
- Website
- Supermarket scratch cards
- Exchange shops
- SMS codes

### Mobile Apps

| App | Purpose |
|-----|---------|
| **My Etisalat** | Account, top-up, bills |
| **du app** | Account, top-up, bills |
| **Botim** | Legal VoIP calling |

---

## 🏦 Banking

### Major Banks

| Bank | Type | Best For |
|------|------|----------|
| **Emirates NBD (ENBD)** | Local | Most popular, extensive ATMs |
| **FAB (First Abu Dhabi)** | Local | Premium banking |
| **ADCB** | Local | Good digital experience |
| **Mashreq** | Local | Strong digital banking |
| **HSBC** | International | Expats from HSBC countries |
| **Standard Chartered** | International | Premium services |
| **RAKBank** | Local | Easy account opening |
| **Liv.** | Digital (ENBD) | No minimum balance |
| **Neo** | Digital (Mashreq) | App-based |

### Opening a Bank Account

**Requirements:**
- Valid passport
- Emirates ID (or application receipt)
- UAE residence visa
- Proof of address (Ejari, utility bill)
- Salary certificate or employment contract
- 6 months bank statements (sometimes)

**Timeline:** 1-7 working days

### Account Types

| Type | Min Balance | Monthly Fee | Best For |
|------|-------------|-------------|----------|
| **Basic Current** | AED 3,000-5,000 | AED 0-50 | Most expats |
| **Zero Balance** | AED 0 | AED 50-100 | New arrivals |
| **Premium** | AED 50,000+ | AED 0 | High earners |
| **Salary Transfer** | Salary account | AED 0 | Employed expats |

### Digital Banks (Easy Opening)

| Bank | Min Balance | Features |
|------|-------------|----------|
| **Liv. (ENBD)** | AED 0 | Cashback, goals, no fees |
| **Neo (Mashreq)** | AED 0 | Full digital, no branch needed |
| **CBD Now** | AED 0 | Quick sign-up |

### Key Banking Features

| Feature | Notes |
|---------|-------|
| **Debit cards** | Visa/Mastercard, contactless |
| **Credit cards** | Easy to get (sometimes too easy) |
| **Online banking** | All banks offer apps |
| **ATM fees** | Free at own bank, AED 2-5 others |
| **International transfers** | SWIFT available, consider Wise |
| **Cheques** | Still used for rent, salary |

### Banking Apps

| App | Bank | Rating |
|-----|------|--------|
| ENBD X | Emirates NBD | ⭐⭐⭐⭐⭐ |
| FAB Mobile | First Abu Dhabi | ⭐⭐⭐⭐ |
| Liv. | ENBD Digital | ⭐⭐⭐⭐⭐ |
| Neo | Mashreq Digital | ⭐⭐⭐⭐ |

### Money Transfer Services

| Service | Best For | Notes |
|---------|----------|-------|
| **Wise** | International transfers | Best rates |
| **Western Union** | Cash pickup abroad | Many locations |
| **UAE Exchange** | Remittances | Popular for South Asia |
| **Al Ansari Exchange** | Currency exchange | Competitive rates |

---

## ⚡ Utilities (DEWA)

### DEWA = Dubai Electricity & Water Authority

**Coverage:** Dubai emirate only (other emirates have own utilities)

### New Connection

**Process:**
1. Apply online via DEWA app/website
2. Submit tenancy contract (Ejari)
3. Pay deposit
4. Connection within 24-48 hours

**Required Documents:**
- Ejari (registered tenancy contract)
- Passport copy
- Emirates ID
- Visa copy

### Deposits

| Property Type | Deposit (AED) | Refundable |
|---------------|---------------|------------|
| Apartment | 2,000 | Yes |
| Villa | 4,000 | Yes |

**Connection fee:** AED 110 (apartment) / AED 310 (villa)

### Tariffs (2025)

**Electricity:**

| Consumer Type | Rate (Fils/kWh) |
|---------------|-----------------|
| Residential (0-2000 kWh) | 23 |
| Residential (2001-4000 kWh) | 28 |
| Residential (4001-6000 kWh) | 32 |
| Residential (6000+ kWh) | 38 |
| Commercial | 38 |

**Water:**

| Consumer Type | Rate (Fils/gallon) |
|---------------|--------------------|
| Residential (0-6000 gallons) | 0.6 |
| Residential (6001-12000) | 0.9 |
| Residential (12000+) | 1.02 |
| Commercial | 1.18 |

**Additional charges:**
- Housing fee: 5% of annual rent (via DEWA bill)
- Knowledge fee: AED 10/month
- Innovation fee: AED 10/month
- Fuel surcharge: Variable

### Average Monthly Bills

| Property | Summer (AED) | Winter (AED) |
|----------|--------------|--------------|
| Studio/1BR | 400-700 | 200-400 |
| 2BR | 600-1,000 | 300-600 |
| 3BR | 800-1,500 | 500-900 |
| Villa | 1,500-3,000 | 800-1,500 |

### District Cooling

Many new buildings use district cooling (chilled water for A/C).

**Providers:** Empower, Emicool

**Billing:** Separate from DEWA, charged per consumption or fixed rate

| Property | Monthly (AED) |
|----------|---------------|
| 1BR apartment | 200-400 |
| 2BR apartment | 350-600 |
| Villa | 500-1,200 |

### DEWA App Features
- Bill payment
- Usage monitoring
- Report issues
- New connections
- Moving services
- Green Charger (EV)

---

## 🌐 Internet & Home Services

### Home Internet Providers

| Provider | Plans Available |
|----------|-----------------|
| **Etisalat (eLife)** | Internet + TV bundles |
| **du** | Internet + TV bundles |

### Speed & Pricing

| Speed | Etisalat (AED/month) | du (AED/month) |
|-------|---------------------|-----------------|
| 250 Mbps | 349 | 349 |
| 500 Mbps | 449 | 429 |
| 1 Gbps | 699 | 599 |

**Note:** Standalone internet is available but bundles offer better value.

### Installation

**Timeline:** 3-7 days
**Installation fee:** AED 100-200 (often waived with 12-month contract)

**Requirements:**
- Emirates ID
- Tenancy contract
- No outstanding bills with provider

### Bundles

| Provider | Bundle | Internet | TV | Price (AED/month) |
|----------|--------|----------|----|--------------------|
| Etisalat | eLife Basic | 250 Mbps | Basic | 449 |
| Etisalat | eLife Select | 500 Mbps | Premium | 749 |
| du | Home Basic | 250 Mbps | Basic | 399 |
| du | Home Plus | 500 Mbps | Sports | 699 |

---

## 📮 Mail & Packages

### Emirates Post

- No home delivery for regular mail
- **P.O. Box required** for official correspondence
- Cost: AED 350-500/year depending on box size

### P.O. Box Options

| Provider | Cost/year | Notes |
|----------|-----------|-------|
| Emirates Post | 350-500 | Official government mail |
| Private mailboxes | 400-800 | Some offer street address |

### Package Delivery

| Service | Type | Notes |
|---------|------|-------|
| **Emirates Post** | Standard | Cheapest for small packages |
| **Aramex** | Express | Shop & Ship service popular |
| **DHL** | Express | Fast international |
| **FedEx** | Express | Fast international |
| **Fetchr** | Local | App-based delivery |
| **Quiqup** | Local | Same-day delivery |

### Shop & Ship Services

Many expats use "shop and ship" to buy from US/UK:

| Service | Provider | Notes |
|---------|----------|-------|
| Shop & Ship | Aramex | Most popular |
| MyUS | MyUS.com | US address |
| Borderlinx | Various | Multiple countries |

### Customs & Duties

| Value (AED) | Duty |
|-------------|------|
| Under 1,000 | Usually exempt |
| 1,000+ | 5% customs duty |
| Electronics | Often exempt |
| Alcohol/tobacco | High duties or prohibited |

---

## 📱 Essential Apps for Daily Life

### Delivery & Food

| App | Purpose | Notes |
|-----|---------|-------|
| **Talabat** | Food delivery | Most popular |
| **Deliveroo** | Food delivery | Premium restaurants |
| **Careem** | Ride + food + groceries | Super app |
| **Noon** | E-commerce | Amazon of UAE |
| **Amazon.ae** | E-commerce | Fast delivery |
| **InstaShop** | Grocery delivery | Delivers from local stores |
| **Kibsons** | Fresh produce | Farm-to-door |

### Transport

| App | Purpose |
|-----|---------|
| **Careem** | Ride-hailing |
| **RTA Dubai** | Metro, bus, parking |
| **S'hail** | Journey planning |
| **Salik** | Toll management |

### Government

| App | Purpose |
|-----|---------|
| **UAE Pass** | Digital ID, government services |
| **Dubai Now** | Government services |
| **ICA UAE** | Immigration services |
| **MOHRE** | Labor services |

### Utilities & Bills

| App | Purpose |
|-----|---------|
| **DEWA** | Electricity & water |
| **Etisalat** | Mobile & internet |
| **du** | Mobile & internet |

### Banking

| App | Purpose |
|-----|---------|
| **ENBD X** | Banking |
| **Liv.** | Digital banking |
| **FAB Mobile** | Banking |

### Lifestyle

| App | Purpose |
|-----|---------|
| **The Entertainer** | 2-for-1 deals |
| **Groupon** | Deals & discounts |
| **Zomato** | Restaurant reviews |
| **Time Out Dubai** | Events & activities |
| **DubaiNow** | Everything Dubai |

---

## 🔌 Electricity & Plugs

| Standard | Details |
|----------|---------|
| **Voltage** | 220-240V |
| **Frequency** | 50 Hz |
| **Plug type** | Type G (UK 3-pin) |

**Tip:** Bring universal adapter. Most electronics (phones, laptops) work with 110-240V.

---

## 📋 Service Setup Checklist

### Week 1 Priorities

- [ ] Get SIM card (airport or mall)
- [ ] Open UAE Pass account (digital ID)
- [ ] Register tenancy (Ejari)
- [ ] Apply for DEWA connection
- [ ] Start bank account application

### Week 2-4

- [ ] Get Emirates ID (after visa)
- [ ] Finalize bank account
- [ ] Set up home internet
- [ ] Get P.O. Box if needed
- [ ] Download essential apps

### Ongoing

- [ ] Set up bill auto-pay
- [ ] Register with DEWA for consumption alerts
- [ ] Get driver's license exchanged
- [ ] Register for Salik (if driving)

---

## 💡 Pro Tips

1. **Banking:** Start with Liv. (no minimum balance) while waiting for Emirates ID
2. **Mobile:** Tourist SIM is fine for first month, switch to postpaid later
3. **DEWA:** Summer bills can be 2-3x winter bills – budget accordingly
4. **Internet:** 250 Mbps is enough for most households
5. **P.O. Box:** Get one early – needed for many official registrations
6. **Apps:** Download Careem first – it does everything (rides, food, delivery)
7. **UAE Pass:** Essential for all government services – set up immediately

---

## ⚠️ Common Mistakes

1. **No DEWA deposit budget:** AED 2,000-4,000 upfront
2. **Ignoring chiller costs:** Can double your utility bill
3. **Bank minimum balance:** Fees if you drop below
4. **Missing Ejari:** Required for everything
5. **Postpaid contracts:** 12-24 month commitments, cancellation fees
6. **VoIP blocking:** WhatsApp calls don't work by default

---

*Sources: Etisalat (e&), du, DEWA, Emirates NBD, UAE Government (u.ae)*
