# Dubai Healthcare System Guide for Expats

> **Last Updated:** February 2026  
> **Key Point:** Health insurance is MANDATORY for all Dubai residents

## Overview

Dubai has developed one of the most modern healthcare systems in the Middle East, with world-class hospitals, English-speaking doctors, and international standards of care. However, the system differs significantly from public healthcare in many Western countries.

---

## 🏥 Healthcare System Structure

### Key Organizations
| Entity | Role |
|--------|------|
| **DHA (Dubai Health Authority)** | Regulates healthcare, runs public hospitals |
| **DoH (Department of Health)** | Abu Dhabi regulation |
| **Ministry of Health** | Federal oversight |

### Public vs Private Healthcare

| Aspect | Public (DHA) | Private |
|--------|--------------|---------|
| **For whom** | Mainly Emiratis; expats can access with health card | Everyone with insurance |
| **Cost** | Subsidized for citizens; 20% co-pay for expats | Depends on insurance |
| **Wait times** | Longer | Usually shorter |
| **Quality** | Good to excellent | Good to excellent |
| **Choice** | Limited | Wide range of specialists |

### Who Gets Free Healthcare?
- **UAE Nationals (Emiratis):** Free or very low cost at DHA facilities
- **Expats:** Must have insurance; pay co-payments
- **Tourists:** Must have travel insurance; pay out of pocket

---

## 📋 Mandatory Health Insurance (CRITICAL)

### Legal Requirement
Since 2014, **health insurance is mandatory** for all Dubai residents (visa holders). As of January 2025, this extends to all UAE emirates.

### Employer Obligations
- Employers **MUST** provide health insurance for employees
- Some employers cover dependents; many do not
- Basic coverage minimum requirements set by DHA

### The Essential Benefits Plan (EBP)
The minimum required coverage mandated by DHA:

| Coverage | Details |
|----------|---------|
| **Inpatient care** | Hospital stays, surgeries |
| **Outpatient care** | GP visits, specialist consultations |
| **Diagnostics** | X-rays, blood tests, scans |
| **Emergency care** | Urgent medical treatment |
| **Medications** | Approved list (formulary) |
| **Maternity** | After waiting period |
| **Pre-existing conditions** | After waiting period |

### Co-payments
- **Standard:** 20% co-insurance paid by patient
- **Annual cap:** AED 700-1,000 maximum out-of-pocket
- Some plans have 0% co-pay for inpatient services

---

## 💰 Insurance Costs (2024-2026)

### Average Annual Premiums

| Plan Type | Annual Cost (AED) | Best For |
|-----------|------------------|----------|
| **Basic/Essential (EBP)** | 750 - 3,000 | Lower-income workers, basic needs |
| **Enhanced/Mid-tier** | 3,000 - 7,500 | Young professionals |
| **Comprehensive** | 7,500 - 15,000 | Families, broader coverage |
| **Premium/International** | 15,000 - 45,000+ | Executives, global coverage |

### What Affects Price:
- Age (50+ significantly higher)
- Pre-existing conditions
- Coverage level
- Network tier
- Deductibles chosen

### VAT
- 5% VAT applies to health insurance premiums
- Businesses can recover this as input VAT

---

## 🏆 Top Health Insurance Providers

### Local Market Leaders

| Provider | Strengths |
|----------|-----------|
| **Daman (National Health Insurance)** | Largest local network, government partnerships |
| **Sukoon (formerly Oman Insurance + Bupa)** | HealthPlus plans, high annual limits |
| **GIG Gulf (formerly AXA)** | Seamless digital claims, regional network |
| **NextCare** | Common TPA (claims administrator) |

### International Providers

| Provider | Best For |
|----------|----------|
| **Cigna Global** | International coverage, expat-friendly |
| **Bupa Global** | Premium coverage, worldwide |
| **Allianz Care** | Cross-border medical needs |
| **Aetna International** | US-style coverage |
| **MetLife** | Corporate plans |

### Comparison Tip
- Check the **network tier** - ensure hospitals near you are covered
- Verify **pre-approval requirements** for specialists
- Understand **claim process** (direct billing vs reimbursement)

---

## 🏨 Top Hospitals in Dubai

### Public (DHA) Hospitals

| Hospital | Specialty | Location |
|----------|-----------|----------|
| **Rashid Hospital** | Trauma, emergency, burn unit | Umm Hurair |
| **Dubai Hospital** | General, cardiac | Al Baraha |
| **Latifa Hospital** | Women's health, maternity | Al Jadaf |
| **Al Jalila Children's** | Pediatrics | Al Jadaf |

### Private Hospitals (Premium)

| Hospital | Specialty | Notes |
|----------|-----------|-------|
| **American Hospital Dubai** | Multi-specialty | JCI accredited, US-style |
| **Mediclinic City Hospital** | Multi-specialty | Part of Dubai Healthcare City |
| **King's College Hospital London** | Multi-specialty | UK expertise |
| **Saudi German Hospital** | Multi-specialty | Large network |
| **Cleveland Clinic Abu Dhabi** | Multi-specialty | World-renowned (in Abu Dhabi) |

### Private Hospital Chains

| Chain | Locations | Notes |
|-------|-----------|-------|
| **Mediclinic** | Multiple | High-end, expensive |
| **Aster** | Many | Mid to high range |
| **NMC Healthcare** | Many | Wide range |
| **Prime** | Multiple | Mid-range |
| **Medcare** | Multiple | Good network |

---

## 💵 Typical Healthcare Costs (Without Insurance)

### Consultations
| Service | Cost (AED) |
|---------|-----------|
| GP visit | 150 - 300 |
| Specialist visit | 300 - 600 |
| Emergency room visit | 500 - 1,500+ |

### Hospital Stays
| Service | Cost (AED) |
|---------|-----------|
| Standard room (per night) | 2,000 - 4,000 |
| ICU (per night) | 5,000 - 10,000+ |
| Normal delivery | 11,000 - 22,000 |
| C-section | 25,000 - 55,000 |
| Non-complex hospital stay | 25,000 - 45,000 |

### Other Services
| Service | Cost (AED) |
|---------|-----------|
| Blood test (basic panel) | 200 - 500 |
| X-ray | 200 - 400 |
| MRI scan | 1,500 - 3,500 |
| CT scan | 1,000 - 2,500 |

---

## 🩺 Accessing Healthcare as an Expat

### Getting a DHA Health Card
Required for public facility access:

**Requirements:**
- Emirates ID
- Passport copy
- UAE residence visa
- Two passport photos
- Tenancy contract copy
- Completed application form

**Cost:**
- Adults (18+): AED 320/year
- Children (<10): AED 120/year

**Process:** Apply online via DHA website or at a health center

### Finding a Doctor (GP)
1. **Insurer directory:** Check your insurance company's network
2. **DHA Website:** services.dha.gov.ae
3. **Dubai Healthcare City:** dhcc.ae/patient/find-doctor-service
4. **Hospital websites:** Mediclinic, Aster, etc.

**Tips:**
- Look for English-speaking doctors (most are)
- Check qualifications and specialties
- Book consultation to assess compatibility
- Ask about after-hours availability

---

## 🤰 Maternity Care

### Key Points
- **Pre-authorization required** from insurance before delivery
- **Waiting periods:** Most plans have 9-12 month waiting period for maternity
- **Choose hospital early:** Book with OB/GYN who has delivery rights at your preferred hospital

### Costs (Out of Pocket)
| Service | Cost (AED) |
|---------|-----------|
| Prenatal care package | 8,000 - 15,000 |
| Normal delivery | 11,000 - 22,000 |
| C-section | 25,000 - 55,000 |
| Epidural (add-on) | 2,000 - 4,000 |
| Private room upgrade | 1,000 - 3,000/night |

### Top Maternity Facilities
- **Mediclinic City Hospital**
- **American Hospital Dubai**
- **Latifa Hospital** (public, women-only option available)
- **Dubai Gynaecology & Fertility Centre**

---

## 💊 Pharmacies & Medications

### Key Information
- Pharmacies everywhere (in malls, neighborhoods)
- **Many medications available without prescription** (antibiotics, etc.)
- **Controlled substances require** Ministry of Health permit
- Common chains: Boots, BinSina, Aster

### Bringing Medications to UAE
- **Declare** all medications at customs
- Bring **prescription** and doctor's letter
- **Prohibited:** Many controlled substances (painkillers, sedatives, ADHD medications)
- **Check before traveling:** UAE Ministry of Health website
- Maximum 3-month supply typically allowed

### Banned/Controlled Medications Include:
- Some painkillers (codeine-based)
- Sleep medications
- ADHD medications (Adderall, Ritalin)
- Some antidepressants
- Medical marijuana (completely illegal)

---

## 🚨 Emergency Services

### Emergency Numbers
- **Ambulance:** 998 (DCAS)
- **Police:** 999
- **Fire:** 997
- **Coast Guard:** 996

### What to Do in Emergency
1. Call 998 for ambulance
2. Go to nearest hospital emergency
3. Have Emirates ID and insurance card ready
4. Treatment first, payment/paperwork after

### Important Notes
- Emergency care **cannot be refused** even without insurance
- You WILL be billed afterward if no insurance
- Keep emergency fund for potential out-of-pocket costs

---

## 🦷 Dental & Vision Care

### Dental
- **Usually NOT included** in basic insurance plans
- **Add-on options** available (AED 500-2,000/year)
- **Out of pocket costs:**
  - Cleaning: AED 200-400
  - Filling: AED 200-500
  - Root canal: AED 1,500-3,000
  - Crown: AED 1,500-3,000

### Vision
- **Often excluded** from basic plans
- **Add-on available**
- **Out of pocket:**
  - Eye exam: AED 150-300
  - Glasses: AED 300-2,000+
  - Contact lenses: Market rate

---

## 📱 Telehealth Options

Many providers now offer virtual consultations:
- **DHA App** - Book appointments, access records
- **Hospital apps** - Mediclinic, Aster, etc.
- **Third-party platforms** - Various telehealth services

---

## Common Mistakes Expats Make

1. **Not understanding insurance coverage** before needing care
2. **Choosing hospital outside network** - results in non-coverage or reimbursement hassles
3. **Skipping pre-authorization** for planned procedures
4. **Not declaring medications** at customs
5. **Waiting too long** to get insurance for dependents
6. **Not keeping receipts** for reimbursement claims
7. **Ignoring waiting periods** for maternity, pre-existing conditions
8. **Assuming Western medication availability** - check before moving

---

## Thiqa Insurance Plans (Enhanced)

Available for Dubai residents who want coverage beyond EBP:

| Tier | Features | Monthly Cost (approx) |
|------|----------|----------------------|
| **Thiqa Basic** | Above EBP minimums | AED 500/month |
| **Thiqa Classic** | Lower co-pays, wider network | AED 700/month |
| **Thiqa Gold** | Premium access, comprehensive | AED 1,000+/month |

### Benefits:
- Access to private hospitals
- No claim forms (direct billing)
- Pre-existing conditions covered after year 1
- Maternity, dental, vision options

---

## Resources

- **DHA Official:** dha.gov.ae
- **Find licensed facilities:** services.dha.gov.ae
- **Insurance comparison:** Various online brokers
- **Emergency:** 998 (ambulance), 999 (police)

---

*Healthcare quality in Dubai is generally excellent, but the system requires proactive management of insurance and understanding of costs. Plan ahead, understand your coverage, and don't hesitate to seek care when needed.*
