# Dubai Driving Guide for Expats

> **Last Updated:** February 2026  
> **Key Authority:** RTA (Roads and Transport Authority)

## Overview

Dubai has one of the most modern road systems in the world, and for most expats, having a car is essential. Public transport exists but doesn't reach many residential areas. Understanding the driving license process, car ownership, and traffic rules is crucial for expat life.

---

## 🚗 Do You Need a UAE Driving License?

### Quick Reference

| Your Situation | Requirement |
|----------------|-------------|
| **Tourist** | Home license + IDP (International Driving Permit) OK |
| **Resident (exempt country)** | Convert existing license |
| **Resident (non-exempt)** | Must take driving course + tests |

### Tourist Driving
- Valid for duration of visit visa
- Need home country license + IDP from certain countries
- Car rental available (age 21+)

### Resident Driving
- **Must obtain UAE license** within 6 months of getting visa
- Cannot drive on foreign license as a resident

---

## 📋 UAE License - Eligible Countries (Direct Conversion)

If your license is from these countries, you can **convert directly** without driving tests:

### Full Conversion (No Test Required)
| Region | Countries |
|--------|-----------|
| **GCC** | Saudi Arabia, Kuwait, Qatar, Bahrain, Oman |
| **Europe** | UK, Germany, France, Italy, Spain, Netherlands, Belgium, Austria, Portugal, Ireland, Switzerland, Norway, Sweden, Denmark, Finland, Greece, Poland |
| **Americas** | USA, Canada |
| **Oceania** | Australia, New Zealand |
| **Asia** | Japan, South Korea, Singapore, Hong Kong |
| **Africa** | South Africa |
| **Other** | Turkey |

### Not on the List?
If your country isn't listed (India, Pakistan, Philippines, Bangladesh, Egypt, Nigeria, etc.), you **must complete full driving training and tests**.

---

## 📝 License Conversion Process (Exempt Countries)

### Required Documents
- Original home country driving license (valid)
- Arabic translation of license (if not in English)
- Passport copy
- UAE residence visa copy
- Emirates ID
- Eye test certificate
- Passport-size photos
- No-objection certificate from employer (sometimes required)

### Process Steps
1. **Eye test** at approved optical center (AED 120-150)
2. **Visit RTA** or approved driving school
3. **Submit documents**
4. **Pay fees** (approximately AED 410)
5. **Receive UAE license** (usually same day)

### Time Required
- Can be completed in 1-2 hours if documents ready
- License valid for 10 years (or visa validity)

---

## 🎓 Getting a License (Non-Exempt Countries)

### Approved Driving Schools in Dubai
| School | Location |
|--------|----------|
| **Emirates Driving Institute (EDI)** | Al Qusais |
| **Dubai Driving Center** | Al Awir |
| **Galadari Driving School** | Al Qusais |
| **Belhasa Driving Center** | Al Quoz |

### Process Overview

#### Step 1: Open a Driving File
- Register at approved school
- Submit documents (passport, visa, Emirates ID, photos)
- Fee: AED 200-300

#### Step 2: Eye Test
- At school or approved optical
- Fee: AED 120-150

#### Step 3: RTA Theory Test
- Multiple choice on traffic rules
- Languages: Arabic, English, Urdu, Hindi, etc.
- Prep using RTA app
- Fee: AED 200

#### Step 4: Driving Classes
| Your Experience | Classes Required |
|-----------------|------------------|
| No license ever | 40 classes |
| Expired foreign license | 20 classes |
| Valid license (non-exempt) | 10-20 classes |

- Each class: 1 hour
- Cost: AED 50-100 per class
- **Total class cost: AED 2,000-4,000**

#### Step 5: Yard/Parking Test
Tests include:
- Hill start (slope)
- Parallel parking
- Garage parking
- Angle parking
- Emergency braking

#### Step 6: Road Test
- 10-15 minutes with examiner
- Real road conditions
- Tests: Lane discipline, indicators, speed limits, roundabouts
- Multiple attempts may be needed

### Total Cost (Non-Exempt)
| Item | Cost (AED) |
|------|-----------|
| File opening | 200-300 |
| Eye test | 120-150 |
| Theory test | 200 |
| Driving classes (40) | 2,000-4,000 |
| Yard test | 200 |
| Road test | 300 |
| License issuance | 200 |
| **TOTAL** | **3,200-5,350** |

### Tips for Passing
✓ Use indicators **every time** you change lanes  
✓ Maintain 2-3 second following distance  
✓ Follow speed limits strictly  
✓ Practice roundabouts thoroughly  
✓ Stay calm during test  
✓ Listen carefully to examiner instructions  
✓ Don't brake suddenly  

---

## 🚙 Buying a Car

### New vs Used

| Option | Pros | Cons |
|--------|------|------|
| **New** | Warranty, dealer support, no history issues | Higher cost, depreciation |
| **Used** | Lower cost, less depreciation | Unknown history, potential repairs |

### New Car Prices (2025)

| Category | Example Models | Price Range (AED) |
|----------|---------------|------------------|
| **Economy** | Nissan Sunny, Hyundai Accent | 45,000-65,000 |
| **Compact** | Toyota Corolla, Honda Civic | 75,000-110,000 |
| **Mid-size** | Toyota Camry, Nissan Altima | 100,000-130,000 |
| **SUV (compact)** | Toyota RAV4, Nissan Rogue | 110,000-150,000 |
| **SUV (large)** | Toyota Land Cruiser | 200,000-350,000 |
| **Luxury** | Mercedes, BMW | 180,000-500,000+ |

### Used Car Prices

| Category | 3-5 Year Old | Examples |
|----------|-------------|----------|
| **Economy** | 15,000-30,000 | Yaris, Sunny |
| **Compact** | 25,000-45,000 | Corolla, Civic |
| **SUV** | 40,000-80,000 | RAV4, Sportage |

### Where to Buy

#### New Cars
- **Authorized dealers** (Al Futtaim, Al Nabooda, etc.)
- Negotiate! Prices are not fixed

#### Used Cars
| Source | Pros | Cons |
|--------|------|------|
| **Dubizzle.com** | Largest selection | Must verify yourself |
| **YallaMotor** | Verified listings | Higher prices |
| **CarSwitch** | Inspected cars, warranty | Limited selection |
| **Dealers (used)** | Some warranty | Markup |
| **Private sale** | Best price | Risk |

### Buying Checklist
- [ ] Check service history
- [ ] Get independent inspection
- [ ] Verify no outstanding fines (RTA website)
- [ ] Check for accidents (body work, panel gaps)
- [ ] Test drive extensively
- [ ] Verify ownership documents
- [ ] Check registration expiry

---

## 📑 Car Registration

### New Car Registration
- Dealer handles for first 2 years
- Included in purchase price

### Used Car / Transfer of Ownership
1. Buyer and seller visit RTA
2. Bring: Emirates IDs, original registration, insurance
3. Clear all fines first
4. Pay transfer fee (AED 350)
5. New registration issued same day

### Annual Registration Renewal
Required every year:
1. **Safety inspection** (Tasjeel/test center)
   - Tires, brakes, lights, steering, suspension
   - Fee: ~AED 200
   - If fail: 30 days to repair and retest
2. **Valid insurance** certificate
3. **Pay any fines** (can't renew with unpaid fines)
4. **Pay registration** (AED 350)

---

## 🛡️ Car Insurance

### Types of Insurance

| Type | Coverage | Cost Range (AED/year) |
|------|----------|----------------------|
| **Third Party** | Damage to others only | 900-1,800 |
| **Comprehensive** | Your car + third party | 2,000-5,000 (economy car) |
| **Comprehensive** | Premium/luxury cars | 4,000-10,000+ |

### Factors Affecting Premium
- Driver's age
- Driving history
- Car model and value
- Car age
- No-claims bonus

### Recommended Insurers
- Oman Insurance
- AXA Gulf
- RSA Insurance
- Orient Insurance
- Salama Insurance

### Insurance Tips
- Get multiple quotes
- Check network garages
- Understand deductibles
- Agency repair vs non-agency (cheaper premiums)
- No-claims discount transfers from some countries

---

## 🛣️ Salik (Toll System)

### What is Salik?
Automatic toll system in Dubai. Your car passes through gates, and AED 4 is charged per crossing.

### Getting a Salik Tag
- **Purchase:** Petrol stations, online, Carrefour
- **Cost:** AED 100 (includes AED 50 credit)
- **Stick to windshield** (specific location)

### Salik Gate Locations
| Gate | Location |
|------|----------|
| **Al Garhoud** | Al Garhoud Bridge |
| **Al Maktoum** | Al Maktoum Bridge |
| **Al Barsha** | Sheikh Zayed Road |
| **Al Safa** | Sheikh Zayed Road |
| **Airport Tunnel** | DXB approach |
| **Jebel Ali** | Sheikh Zayed Road |
| **Minhad** | Academic City area |

### Tips
- **No daily cap** - can pay AED 40+ on heavy travel days
- **Recharge online** via Salik app or website
- **Low balance alert** - set up notifications
- **Fine for no tag:** AED 100 per crossing

### Abu Dhabi Toll (Darb)
- Separate system from Salik
- Register if traveling to Abu Dhabi regularly
- AED 2 (off-peak) to AED 4 (peak)

---

## ⚠️ Traffic Rules & Fines

### Speed Limits

| Road Type | Limit (km/h) | Notes |
|-----------|-------------|-------|
| **Residential** | 40-60 | Near schools: 40 |
| **Urban roads** | 60-80 | |
| **Highways** | 100-140 | Some sections 120 |
| **Parking areas** | 25 | |

### Common Fines

| Violation | Fine (AED) | Black Points |
|-----------|-----------|--------------|
| Speeding (+20 km/h) | 600 | 0 |
| Speeding (+30 km/h) | 700 | 6 |
| Speeding (+40 km/h) | 1,000 | 12 |
| Speeding (+50 km/h) | 1,500 | 18 |
| Speeding (+60 km/h) | 2,000+ | 23 |
| Speeding (+80 km/h) | 3,000 | 23 + impound |
| Using phone | 800 | 4 |
| No seatbelt | 400 | 4 |
| Running red light | 1,000 | 12 + impound |
| Dangerous driving | 2,000 | 23 |
| Wrong parking | 200-1,000 | - |
| Drunk driving | 20,000-30,000 | 24 + jail |

### Black Points System
- Maximum 24 points before license suspension
- Points valid for 1 year
- 24+ points = 1 year suspension
- Drunk driving = instant 24 points

### Zero Tolerance - Drunk Driving
**CRITICAL:** UAE has **zero tolerance** for alcohol while driving.
- ANY detectable alcohol = severe penalties
- Fines: AED 20,000-100,000
- Jail time possible
- Vehicle impound
- **NEVER drink and drive - always use taxi/Careem**

---

## 🅿️ Parking

### Types of Paid Parking

| Zone | Rate (AED/hour) | Hours |
|------|----------------|-------|
| **Premium (P)** | 4 | 8 AM - 10 PM |
| **Standard (B/C)** | 2-3 | 8 AM - 10 PM |
| **Multi-story** | 2-5 | Varies |

### Payment Methods
- **RTA app** (mParking)
- **SMS** to designated number
- **Parking meters**
- **Pre-paid cards** (AED 30, 50, 100)

### Free Parking
- **Fridays** (in most areas)
- **Public holidays**
- **After 10 PM** (most zones)
- **Residential areas** (unzoned)

### Parking Fines
- No ticket displayed: AED 150-200
- Exceeding time: AED 150
- Disabled bay (unauthorized): AED 1,000
- Double parking: AED 500

---

## 🔧 Car Maintenance

### Recommended Servicing
| Service | Frequency |
|---------|-----------|
| Oil change | Every 5,000-10,000 km |
| Full service | Every 15,000-20,000 km |
| AC check | Before summer |
| Tires | Check monthly; replace every 40,000-50,000 km |
| Battery | Every 2-3 years (heat kills batteries) |

### Where to Service
| Option | Cost Level | Best For |
|--------|-----------|----------|
| **Agency** | High | New cars under warranty |
| **Independent garages** | Medium | Out-of-warranty, general |
| **Al Quoz workshops** | Low | Budget repairs (beware quality) |

### Heat Considerations
Dubai heat is brutal on cars:
- Park in shade when possible
- Use sun shades
- Check coolant levels regularly
- AC service before summer
- Battery life shorter (2-3 years)

---

## 🆘 Emergencies & Accidents

### If You Have an Accident

1. **Stop immediately** - leaving scene is criminal
2. **Turn on hazard lights**
3. **Move to safe location** if minor and cars drivable
4. **Call police:** 999 (or RTA for minor accidents)
5. **Don't admit fault**
6. **Exchange details** (license, registration, insurance)
7. **Take photos**
8. **Wait for police report**

### Police Report Colors
| Color | Meaning |
|-------|---------|
| **Green** | You're not at fault |
| **Pink** | You're at fault |
| **White** | Shared/unclear fault |

### Breakdown Assistance
- **AAA UAE:** aaa.ae
- **Insurance roadside assistance**
- **Car dealer breakdown service**
- Keep emergency number in car

---

## 📱 Useful Apps

| App | Purpose |
|-----|---------|
| **RTA Dubai** | License, fines, registration |
| **Salik** | Toll balance, recharge |
| **Dubai Drive** | Fines, vehicle info |
| **Careem/Uber** | When you can't drive |
| **Waze** | Traffic and speed cameras |
| **Fuel prices** | Daily fuel price updates |

---

## Renting vs Buying

### When to Rent
- First 3-6 months in Dubai
- Short-term contracts
- Testing different car types
- Temporary assignments

### Rental Costs

| Type | Monthly (AED) |
|------|--------------|
| Economy | 1,200-1,800 |
| Sedan | 1,800-2,500 |
| SUV | 2,500-4,000 |
| Luxury | 4,000-10,000+ |

### When to Buy
- Staying 2+ years
- Want to build equity
- Specific car needs
- Tax-free purchase advantage

---

## Common Mistakes New Drivers Make

1. **Not using indicators** - automatic fail in test, habit issue
2. **Speeding** - cameras everywhere
3. **Tailgating** - common but dangerous and fined
4. **Phone use** - heavily enforced
5. **Ignoring Salik** - fines accumulate fast
6. **Not checking fines** - must clear before registration
7. **Drinking and driving** - zero tolerance, seriously
8. **Wrong lane usage** - left lane for overtaking only
9. **Ignoring roundabout rules** - give way to right
10. **Not carrying documents** - license, registration, insurance

---

## Resources

- **RTA Official:** rta.ae
- **Salik:** salik.ae
- **Dubai Police Fines:** dubaipolice.gov.ae
- **Dubizzle Cars:** dubizzle.com/cars
- **Emergency:** 999

---

*Driving in Dubai is essential for most expats but comes with responsibilities. Understand the rules, respect the speed limits, never drink and drive, and keep your documentation current. Safe travels!*
