# Dubai Culture & Islamic Customs Guide for Expats

> **Last Updated:** February 2026  
> **⚠️ Important:** Laws in the UAE can change and be applied differently. Always verify current regulations.

## Overview

Dubai is part of the United Arab Emirates (UAE), a Muslim-majority country where Islam plays a central role in daily life. While Dubai is the most liberal emirate, understanding and respecting Islamic culture is essential for expats.

---

## 🕌 Islamic Culture Basics

### The Call to Prayer (Adhan)
- Sounds from mosques **5 times daily** (beginning at sunrise)
- Not disruptive but an important daily rhythm
- Shows respect: lower music/conversation volume when it occurs

### Friday (Jummah)
- The Islamic holy day (equivalent to Sunday in Christian cultures)
- Many businesses operate reduced hours
- Friday prayers around midday are significant

### Islamic Calendar
- Based on lunar months (Hijri calendar)
- Key holidays: Ramadan, Eid al-Fitr, Eid al-Adha
- Dates shift ~11 days earlier each year

---

## ☪️ Ramadan Guide (Critical for Expats)

### What is Ramadan?
The holy month of fasting for Muslims - a time of spiritual reflection, self-discipline, and community. **2024-2025 dates:** approximately early March to early April (varies by moon sighting).

### Rules During Ramadan

#### ❌ Prohibited in Public (for everyone, Muslim or not):
- **Eating** during daylight hours
- **Drinking** (including water)
- **Smoking**
- **Chewing gum**
- **Playing loud music**

#### ✅ What's Allowed:
- Eating/drinking in **private** (home, designated restaurant areas)
- Some restaurants set up screens/partitions for non-fasting guests
- Hotels often maintain private dining areas

#### Practical Tips:
| Situation | What to Do |
|-----------|-----------|
| Need to eat | Use hotel restaurants, screened cafes, or eat at home |
| Driving at Iftar time | Avoid! People drive fast to break their fast |
| Working hours | Often shortened (typically 6 hours) |
| Shopping/mall hours | Malls open late, close late (after Iftar) |

### Iftar & Suhoor
- **Iftar:** Breaking of fast at sunset - special time for gatherings
- **Suhoor:** Pre-dawn meal before fasting begins
- Many hotels/restaurants offer special Iftar buffets (great cultural experience!)

### Fines for Violations
- Eating/drinking in public during Ramadan: **AED 2,000+** fine
- Can include detention in serious cases

---

## 👔 Dress Code

### General Guidelines

| Setting | Men | Women |
|---------|-----|-------|
| **Malls/Public** | Long pants preferred (shorts OK but not too short), T-shirts fine | Shoulders and knees covered, no tight/revealing clothes |
| **Beaches/Pools** | Swimwear OK at beach | Bikinis OK at hotel beaches, cover up when leaving pool area |
| **Mosques** | Long pants, shirt (no shorts) | Abaya required, hair covered (usually provided at entrance) |
| **Offices** | Business casual to formal | Conservative, shoulders covered |

### Key Points:
- **No explicit law** mandating specific dress, but "decency" laws exist
- During Ramadan: **more conservative** dress expected
- Government buildings: stricter dress code
- Tourist areas: more relaxed
- **Avoid:** Sheer fabrics, very short shorts, deep necklines in public areas

### Heat-Friendly Modest Options:
- Loose linen pants
- Maxi dresses
- Light cardigans for air-conditioned spaces
- Breathable long sleeves

---

## ✅ Do's and Don'ts

### DO's ✓
- **Greet with "As-salamu alaykum"** (Peace be upon you) - appreciated even from non-Muslims
- **Accept hospitality** - refusing coffee/dates can be offensive
- **Use right hand** for eating, greeting, giving/receiving items
- **Stand when elders enter**
- **Ask permission before photographing** people, especially women
- **Respect prayer times** - don't interrupt someone praying
- **Remove shoes** when entering homes (follow host's lead)
- **Dress modestly** in government buildings and traditional areas

### DON'Ts ✗
- **No public displays of affection (PDA)** - even holding hands can attract attention
- **No swearing or rude gestures** - illegal and can result in fines
- **No criticizing** the UAE, royal family, or Islam publicly
- **No taking photos** of government buildings, military, airports
- **No eating/drinking in public** during Ramadan
- **No drunkenness in public** - always take a taxi
- **No pointing** at people with your finger
- **No showing soles of feet** directly at someone (considered rude)

---

## 🏳️‍🌈 LGBTQ+ Considerations (CRITICAL)

### Legal Reality
**Same-sex relationships are ILLEGAL in the UAE** under both federal law and Sharia law.

| Aspect | Details |
|--------|---------|
| **Legal status** | Criminalized |
| **Penalties** | Imprisonment (up to 10+ years), fines, deportation |
| **Transgender** | Also illegal ("disguise" laws); gender-affirming care banned |
| **Protection** | None - no anti-discrimination laws |

### Practical Reality
- Many LGBTQ+ expats live in Dubai but remain **completely closeted** in public
- **Zero tolerance** for any public expression
- Dating apps like Grindr are **blocked** (VPNs used at personal risk)
- Reports of **entrapment** and harassment exist
- Underground scene exists but is hidden and risky

### Safety Advice:
- **Absolute discretion required** at all times
- No PDA whatsoever
- Be careful with social media posts (can be monitored)
- Book hotel rooms with two beds if traveling with same-sex partner
- Consider very carefully before moving - laws can be applied arbitrarily

**⚠️ Honest assessment:** LGBTQ+ individuals should carefully evaluate whether Dubai is the right choice. While many live there without incident, this requires complete suppression of identity in public, and there is zero legal protection if issues arise.

---

## 🍺 Alcohol Laws

### Legal Framework
- Alcohol is **legal for non-Muslims aged 21+**
- **Muslims are prohibited** from consuming alcohol

### Where You Can Drink
| Allowed ✓ | Not Allowed ✗ |
|-----------|---------------|
| Licensed bars/clubs | Public streets/parks |
| Hotel restaurants | Your car |
| Private homes | Sharjah (neighboring emirate - total ban) |
| Licensed events | Near mosques |

### Buying Alcohol
- **Liquor stores:** African + Eastern, MMI (main retailers)
- **License requirement:** Residents need free alcohol license (apply at stores with Emirates ID)
- **Tourists:** Can buy with passport, no license needed (as of 2023 reform)
- **Online:** legalhomedelivery.com

### Critical Rules:
- **Zero tolerance drunk driving** - ANY alcohol in system = severe penalties (AED 20,000-100,000 fines, jail time)
- **Public intoxication:** Illegal - fines AED 2,000-5,000, possible imprisonment
- **Dry days:** No alcohol sales during certain religious holidays
- **30% municipality tax** was removed in 2023 (prices still higher than Western countries)

---

## 💑 Cohabitation Laws (Unmarried Couples)

### Current Status (2024-2025)
**Good news:** As of 2021 legal reforms, **unmarried opposite-sex couples CAN legally live together** in Dubai.

### What Changed:
- Federal Penal Code amendments removed criminal penalties for cohabitation
- Unmarried couples can:
  - Rent apartments together
  - Share hotel rooms
  - Live together without marriage certificate

### Important Nuances:
- Laws don't provide guidelines for disputes between unmarried couples
- Sharjah: More conservative (not recommended for unmarried couples)
- Cultural attitudes may still be conservative in some areas
- Real estate agents generally won't ask about marital status
- **Same-sex couples:** Still illegal regardless of cohabitation reforms

---

## 🤝 Social Etiquette

### Greetings
- **Men to men:** Handshake common, may include touches on shoulder
- **Women to women:** Handshake or light embrace
- **Men to women:** Wait for woman to offer hand; if uncertain, place hand on heart with slight bow
- **Emirati greeting:** May include nose-to-nose touch between men (don't initiate unless you're close)

### Business Culture
- **Relationships first** - expect small talk before business
- **Business cards:** Give/receive with both hands
- **Meetings:** May start late; patience is valued
- **Hierarchy:** Respect seniority
- **Weekend:** Friday-Saturday (not Saturday-Sunday)

### Home Visits
- Bring a gift (pastries, chocolates, flowers)
- Remove shoes if host does
- Accept tea/coffee/dates offered
- Don't overly admire possessions (host may feel obligated to give)

---

## 📅 Public Holidays & Religious Observances

| Holiday | Type | Notes |
|---------|------|-------|
| **Ramadan** | Islamic | Month of fasting; reduced work hours |
| **Eid al-Fitr** | Islamic | End of Ramadan; 3-4 day holiday |
| **Eid al-Adha** | Islamic | Feast of Sacrifice; 4 day holiday |
| **Islamic New Year** | Islamic | 1 day |
| **Prophet's Birthday** | Islamic | 1 day |
| **UAE National Day** | National | December 2; major celebrations |
| **New Year's Day** | Civil | January 1 |

---

## Common Mistakes New Expats Make

1. **Underestimating Ramadan impact** - plan around it your first year
2. **PDA in public** - even holding hands can attract attention
3. **Drinking and driving** - zero tolerance means ZERO
4. **Taking photos without permission** - especially of locals
5. **Dressing too casually** in traditional areas or government buildings
6. **Not learning basic Arabic greetings** - shows disrespect
7. **Criticizing UAE/Islam** publicly - even online can have consequences
8. **Ignoring the heat** - it affects everything from dress to activities
9. **Assuming Western social norms apply** - they often don't
10. **Not respecting prayer times** in professional settings

---

## Resources

- **UAE Government Portal:** u.ae
- **Dubai Tourism:** visitdubai.com
- **KHDA (Knowledge Authority):** khda.gov.ae
- **Emergency:** 999

---

*This guide provides general information. Laws and enforcement can vary. When in doubt, err on the side of caution and respect for local culture.*
