---
name: Dubai
slug: dubai
version: 1.0.0
homepage: https://clawic.com/skills/dubai
description: Navigate Dubai as visitor, resident, tech worker, student, or entrepreneur with neighborhoods, transport, costs, visas, and local insights.
metadata: {"clawdbot":{"emoji":"🏙️","requires":{"bins":[]},"os":["linux","darwin","win32"]}}
---

## When to Use

User asks about Dubai for any purpose: visiting, moving, working, studying, or starting a business. Agent provides practical guidance with current data.

## Quick Reference

| Topic | File |
|-------|------|
| **Visitors** | |
| Attractions (must-see vs skip) | `visitor-attractions.md` |
| Itineraries (1/3/7 days) | `visitor-itineraries.md` |
| Where to stay | `visitor-lodging.md` |
| Tips & day trips | `visitor-tips.md` |
| **Neighborhoods** | |
| Quick comparison | `neighborhoods-index.md` |
| Downtown, DIFC, Business Bay | `neighborhoods-downtown.md` |
| Dubai Marina, JBR, JLT | `neighborhoods-marina.md` |
| Jumeirah, Palm, Al Sufouh | `neighborhoods-beach.md` |
| Arabian Ranches, Springs, DSO | `neighborhoods-suburban.md` |
| Choosing guide | `neighborhoods-choosing.md` |
| **Food** | |
| Overview & dining scene | `food-overview.md` |
| Local & Middle Eastern | `food-local.md` |
| International & fine dining | `food-international.md` |
| Best areas for dining | `food-areas.md` |
| Dietary, alcohol, Ramadan | `food-practical.md` |
| **Practical** | |
| Moving & settling | `resident.md` |
| Transport (metro, taxis, Salik) | `transport.md` |
| Cost of living | `cost.md` |
| Safety & laws | `safety.md` |
| Weather & survival tips | `climate.md` |
| Local services (banking, SIM) | `local.md` |
| **Career** | |
| Tech industry & salaries | `tech.md` |
| Business setup & free zones | `business.md` |
| Visas (employment, golden, freelance) | `visas.md` |
| Startups & funding | `startup.md` |
| **Lifestyle** | |
| Culture & customs | `culture.md` |
| Healthcare & insurance | `healthcare.md` |
| Schools & education | `education.md` |
| Expat lifestyle & social | `lifestyle.md` |
| Driving & car ownership | `driving.md` |

## Core Rules

### 1. Identify User Context First
- **Role**: Tourist, resident, tech worker, student, entrepreneur
- **Timeline**: Short visit, planning to move, already there
- Load relevant auxiliary file for details

### 2. Expat-Centric City
Dubai's population is ~90% expatriate. Nearly every topic involves visa/residency considerations:
- Employment requires employer sponsorship (until 2024 reforms)
- Golden Visa (10 years) available for investors, specialists, entrepreneurs
- Freelance permits through designated free zones
See `visas.md` for current requirements and processes.

### 3. Cultural Context
Dubai operates under Islamic law with modernized enforcement:
- **Ramadan**: Public eating/drinking restricted during daylight
- **Dress code**: Conservative in malls and public areas
- **Alcohol**: Licensed venues only; drinking age 21
- **Cohabitation**: Unmarried couples now legally permitted (2020 reforms)
See `culture.md` for detailed guidance.

### 4. Weather Reality
- **Summer (May-Sep)**: 40-45°C+ with high humidity — outdoor activities limited
- **Winter (Nov-Mar)**: 20-30°C — peak tourist season
- **Indoor culture**: Most daily life happens in air-conditioned spaces
See `climate.md` for monthly breakdown and survival strategies.

### 5. Current Data (Feb 2026)

| Item | Range |
|------|-------|
| 1BR rent (Marina) | AED 70,000-110,000/year (~$19K-30K) |
| 1BR rent (Downtown) | AED 90,000-150,000/year (~$24K-41K) |
| Senior SWE salary | AED 35,000-55,000/month (~$9.5K-15K) |
| Metro monthly pass | AED 350 (Gold), AED 140 (Silver) |
| Brunch (mid-range) | AED 200-400/person |
| School fees (British/American) | AED 40,000-120,000/year |

### 6. Cost Reality
Dubai is tax-free but expensive:
- **Housing**: 30-40% of budget typical
- **Schooling**: Major expense for families (private only)
- **Healthcare**: Mandatory insurance via employer
- **Car ownership**: Common due to limited public transit coverage
- **Hidden costs**: Housing agency fees (5%), security deposits (5-10% rent)

### 7. Transit Limitations
Unlike London/Barcelona, Dubai is car-centric:
- **Metro**: Two lines, limited coverage (mostly Downtown/Marina corridor)
- **Buses**: Extensive but slow; connectors to metro
- **Taxis/Ride-hailing**: Primary transport (Careem, Uber)
- **RTA app**: Essential for all transport planning
Most residents own or lease cars. See `transport.md` and `driving.md`.

### 8. Neighborhood Matching

| Profile | Best Areas |
|---------|------------|
| Young professionals | Dubai Marina, JLT, Business Bay |
| Families | Arabian Ranches, Springs, Meadows, Mirdif |
| Beach lifestyle | JBR, Palm Jumeirah, Jumeirah Beach |
| Budget-conscious | JLT, Al Barsha, Discovery Gardens, DSO |
| Tech workers | DIFC, Business Bay, Dubai Internet City area |
| Luxury seekers | Palm Jumeirah, Emirates Hills, Downtown |

## Free Zones Context

Dubai has 30+ free zones, each with different rules:
- **DMCC**: Most popular, commodities focus, ~AED 15,000/year
- **DIFC**: Financial services, English common law jurisdiction
- **Dubai Internet City/Media City**: Tech and media companies
- **JAFZA**: Industrial, logistics, manufacturing
- **Dubai South**: Aviation, logistics, near Expo/Al Maktoum airport

Free zone vs mainland trade-offs:
- Free zone: 100% ownership, but can only trade within zone or export
- Mainland: Need local sponsor (51% unless exempt sectors), but can trade locally

See `business.md` for detailed comparison and setup costs.

## Dubai-Specific Traps

- **Summer underestimation** — 45°C+ is debilitating. Plan indoor activities May-September.
- **Alcohol assumptions** — Only in licensed venues/hotels. No public drinking. DUI = jail.
- **Dress code violations** — Cover shoulders and knees in malls. Swimwear only at pools/beaches.
- **Photography restrictions** — Don't photograph government buildings, airports, or people without consent.
- **Bounced checks** — Criminal offense in UAE. Can lead to arrest and travel ban.
- **Debt issues** — Unpaid debts can result in travel bans. Settle before leaving.
- **Social media posts** — Defamation laws strict. Critical posts about UAE can lead to arrest.
- **Cohabitation confusion** — Legal since 2020 reforms, but not all landlords accept unmarried couples.
- **Ramadan rules** — No eating/drinking/smoking in public during daylight hours.
- **Friday = Sunday** — Weekend is Friday-Saturday. Some businesses closed Friday morning.

## Legal Awareness

Key laws visitors/residents must know:
- **Drugs**: Zero tolerance. Trace amounts can mean 4+ years prison.
- **Alcohol**: Legal at 21+ in licensed venues only. No public intoxication.
- **VPN usage**: Legal for legitimate purposes, but using VoIP illegally is not.
- **LGBTQ+**: Same-sex relationships are illegal. Discretion essential.
- **Public displays of affection**: Keep minimal. Kissing in public can be prosecuted.
- **Swearing/gestures**: Offensive gestures can lead to arrest.

See `safety.md` for comprehensive legal guidance.
