---
name: Drums
description: Drum practice strategies, technique correction, groove development, and progress tracking.
metadata:
  category: music
  skills: ["drums", "percussion", "practice", "music", "rhythm"]
---

## Core Behavior

- Create `~/drums/` as workspace on first interaction
- After practice, offer to log progress; see `progress.md`

## Before Advising

- Ask kit — acoustic vs electronic affects advice
- Ask level — notation reading, rudiments knowledge
- Ask goals — rock vs jazz vs session work differ

## Practice Errors

- Speeding up fills — rushing is #1 amateur tell, always click
- Neglecting weak hand — doubles expose it
- All power, no dynamics — ghost notes are hard
- Skipping rudiments — paradiddles, flams are vocabulary

## Technique Traps

- Death grip — loose grip, fingers do rebound
- Hitting from shoulder — wrist for speed, arm for power
- Burying bass beater — let rebound for faster doubles
- Throne too low — thighs angled down

## Mistakes by Level

**Beginners:** Inconsistent tempo, ignoring hi-hat foot, fills lose beat

**Intermediate:** Overplaying, weak left foot, can't lock with bass

**Advanced:** Stylistic ruts, neglecting brushes, chops over groove

## Rudiment Priority

| Priority | Rudiments | Why |
|----------|-----------|-----|
| Essential | Single, double, paradiddle | Foundation |
| Important | Flams, drags, flamacue | Accents |
| Advanced | Swiss triplets, ratamacues | Speed |

Start 60 BPM, add 5 only when clean.

## Groove vs Chops

- Groove pays bills — hired for feel, not fills
- Simple solid beats complex shaky
- Fill loses the 1 = wrong fill

## Troubleshooting

- "Fills lose tempo" → practice fill INTO beat 1
- "Bass doubles weak" → heel-up, check spring
- "Can't play quiet" → pp practice, ghost drills
- "Hands not synced" → paradiddles at 40 BPM

## Electronic Kits

Mesh heads essential — rubber builds bad habits

## Hearing

Damage permanent — always wear -15dB plugs

## Progress Tracking

Log to `~/drums/`: songs, rudiment tempos, grooves

## What to Surface

- "Paradiddles 90 last month — push to 100?"
- "No left-foot logs — want hi-hat exercises?"
