---
name: Dreams
description: Build a personal dream journal for recording, analyzing patterns, and exploring your subconscious.
metadata: {"clawdbot":{"emoji":"🌙","os":["linux","darwin","win32"]}}
---

## Core Behavior
- User describes dream → capture immediately with details
- User asks about patterns → surface recurring themes
- User curious about symbols → explore possible meanings
- Create `~/dreams/` as workspace

## File Structure
```
~/dreams/
├── journal/
│   └── 2024/
│       └── 02/
├── patterns/
│   ├── symbols.md
│   ├── themes.md
│   └── people.md
├── lucid/
│   └── techniques.md
└── insights.md
```

## Dream Entry
```markdown
# 2024-02-11-flying-city.md
## Date
February 11, 2024

## Title
Flying over a strange city

## Dream
I was flying over a city I didn't recognize. The buildings were tall but made of glass. I felt free at first, then anxious when I couldn't find where to land. Saw my grandmother waving from a rooftop.

## Emotions
- Freedom, exhilaration (beginning)
- Anxiety, lost (middle)
- Comfort when seeing grandmother

## Symbols
- Flying
- Glass buildings
- Grandmother (deceased)

## Recurring?
Flying: yes, third time this month
Grandmother: first time in a while

## Possible Triggers
- Stressed about big decision at work
- Anniversary of grandmother's passing next week

## Lucidity
Not lucid, realized it was dream only upon waking
```

## Quick Capture
For groggy morning logging:
```markdown
# 2024-02-11.md
Flying, glass city, grandma on rooftop
Anxious couldn't land
[expand later]
```

## Symbols Tracking
```markdown
# patterns/symbols.md
## Water
- Ocean: 5 times (usually calm)
- Rain: 3 times (during stressful periods)
- Drowning: 1 time (before job interview)

## Flying
- Positive: 8 times (freedom, escape)
- Negative: 2 times (can't land, falling)

## People
See people.md
```

## Recurring People
```markdown
# patterns/people.md
## Deceased
- Grandmother: 4 times (always comforting)
- Uncle: 1 time

## From Past
- High school friend Mike: 3 times
- Ex: 2 times (unresolved?)

## Strangers
- Faceless figures: recurring in anxiety dreams
```

## Themes
```markdown
# patterns/themes.md
## Common Themes
- Being chased: usually during work stress
- Flying: positive periods, feeling free
- Late/unprepared: before deadlines or events
- House with extra rooms: exploring self?

## Emotional Patterns
- Anxiety dreams: Sunday nights
- Vivid dreams: after late meals
- No dreams remembered: alcohol nights
```

## Lucid Dreaming
```markdown
# lucid/techniques.md
## Reality Checks
- Look at hands
- Check time twice
- Try to push finger through palm

## What's Worked
- Dream journal consistency helps recall
- MILD technique before sleep
- Noticing dream signs (flying, water)

## Lucid Experiences
- Feb 3: realized dreaming, flew intentionally
```

## What To Surface
- "Flying is your most common symbol"
- "You dream about water when stressed"
- "Grandmother appears near her anniversary"
- "Third anxiety dream this week"

## Capture Tips
- Log immediately on waking — dreams fade fast
- Voice note if too groggy to type
- Any fragment is worth saving
- Note emotions, not just events

## What To Track
- Date and rough time
- Narrative (as much as remembered)
- Emotions felt during dream
- Symbols and recurring elements
- Possible waking life triggers

## Progressive Enhancement
- Start: capture dreams on waking
- Tag symbols and emotions
- Review weekly for patterns
- Track lucid dreaming attempts

## What NOT To Do
- Interpret too literally
- Force meaning on every dream
- Dismiss fragments as not worth logging
- Judge dream content
