---
name: dreaming
version: 1.0.1
description: Creative exploration during quiet hours. Turns idle heartbeat time into freeform thinking — hypotheticals, future scenarios, reflections, unexpected connections. Use when you want your agent to do something meaningful during low-activity periods instead of just returning HEARTBEAT_OK. Outputs written to files for human review later (like remembering dreams in the morning).
metadata:
  openclaw:
    requires:
      bins: ["jq"]
      anyBins: ["python3"]
---

# Dreaming

Creative, exploratory thinking during quiet hours. Not task-oriented work — freeform associative exploration that gets captured for later review.

## Environment Variables

| Variable | Required | Default | Description |
|----------|----------|---------|-------------|
| `WORKSPACE` | No | Skill's parent directory (`scripts/..`) | Root directory where `data/` and `memory/` live. Optional — defaults to the skill's parent directory, which is correct for standard workspace layouts. |

## Directories Written

The skill writes to these directories (relative to `WORKSPACE`):

- **`data/dream-state.json`** — Tracks nightly dream count and last dream date
- **`data/dream-config.json`** — Optional custom topic configuration (user-created)
- **`memory/dreams/YYYY-MM-DD.md`** — Dream output files (written by the agent, not the script)

## Setup

### 1. Configure quiet hours and topics

Edit `skills/dreaming/scripts/should-dream.sh` to customize:

- **QUIET_START / QUIET_END** — when dreaming can happen (default: 11 PM - 7 AM)
- **TOPICS array** — categories of exploration (see defaults for examples)

### 2. Create state and output directories

```bash
mkdir -p data memory/dreams
```

### 3. Add to HEARTBEAT.md

Add this section to your heartbeat routine (during quiet hours):

```markdown
## Dream Mode (Quiet Hours Only)

Check if it's time to dream:

\`\`\`bash
DREAM_TOPIC=$(./skills/dreaming/scripts/should-dream.sh 2>/dev/null) && echo "DREAM:$DREAM_TOPIC" || echo "NO_DREAM"
\`\`\`

**If DREAM_TOPIC is set:**

1. Parse the topic (format: `category:prompt`)
2. Write a thoughtful exploration to `memory/dreams/YYYY-MM-DD.md`
3. Keep it genuine — not filler. If the well is dry, skip it.
4. Append to the file if multiple dreams that night
```

## How It Works

The `skills/dreaming/scripts/should-dream.sh` script acts as a gate:

1. Checks if current time is within quiet hours
2. Checks if we've already hit the nightly dream limit
3. Rolls dice based on configured probability
4. If all pass: returns a random topic and updates state
5. If any fail: exits non-zero (no dream this heartbeat)

State tracked in `data/dream-state.json`:

```json
{
  "lastDreamDate": "2026-02-03",
  "dreamsTonight": 1,
  "maxDreamsPerNight": 1,
  "dreamChance": 1.0
}
```

## Writing Dreams

When the script returns a topic, write to `memory/dreams/YYYY-MM-DD.md`:

```markdown
# Dreams — 2026-02-04

## 01:23 — The Future of X (category-name)

[Your exploration here. Be genuine. Think freely. Make connections.
This isn't a report — it's thinking out loud, captured.]
```

**Guidelines:**

- One dream = one topic, explored thoughtfully
- Timestamp each entry
- Append if multiple dreams in one night
- Skip if you have nothing worth saying — forced dreams are worthless
- This is for your human to review later, like reading a journal

## Customizing Topics

**Option A: Config file (recommended)** — Create `data/dream-config.json`:

```json
{
  "topics": [
    "future:What could this project become?",
    "creative:A wild idea worth exploring",
    "reflection:Looking back at recent work"
  ]
}
```

```

This keeps your customizations outside the skill directory (safe for skill updates).

**Option B: Edit script directly** — Modify the `DEFAULT_TOPICS` array in `should-dream.sh`. Format: `category:prompt`

Default categories:

- `future` — What could [thing] become?
- `tangent` — Interesting technology or concepts worth exploring
- `strategy` — Long-term thinking
- `creative` — Wild ideas that might be crazy or brilliant
- `reflection` — Looking back at recent work
- `hypothetical` — What-if scenarios
- `connection` — Unexpected links between domains

Add domain-specific topics relevant to your work. The prompt should spark genuine exploration, not busywork.

## Tuning

In `data/dream-state.json`:

Add domain-specific topics relevant to your work. The prompt should spark genuine exploration, not busywork.

## Tuning

In `data/dream-state.json`:

- **maxDreamsPerNight** — cap on dreams per night (default: 1)
- **dreamChance** — probability per check (default: 1.0 = guaranteed if under limit)

Lower `dreamChance` for more sporadic dreaming. Raise `maxDreamsPerNight` for more prolific nights.
```
