---
name: drawthings
description: Generate images with DrawThings (Stable Diffusion) via API. Use when creating images from text prompts, running image generation workflows, or batch generating images. DrawThings runs locally on Mac with MLX/CoreML acceleration.
metadata:
  openclaw:
    emoji: "🎨"
    requires:
      env: ["DRAWTHINGS_URL"]
---

# DrawThings Image Generation

Generate images using DrawThings, a local Stable Diffusion implementation for Mac with MLX/CoreML acceleration. DrawThings exposes an Automatic1111-compatible API for programmatic image generation.

## When to Use

Use this skill when you need to:
- Generate images from text prompts
- Create variations of a concept
- Batch generate multiple images
- Test different models/samplers/settings
- Generate images with specific dimensions or quality settings

## Configuration

Set the `DRAWTHINGS_URL` environment variable (defaults to http://127.0.0.1:7860):

```bash
export DRAWTHINGS_URL="http://127.0.0.1:7860"
```

Or configure in OpenClaw:
```bash
openclaw config set env.DRAWTHINGS_URL "http://127.0.0.1:7860"
```

## Quick Start

Generate a single image:
```bash
python3 scripts/generate.py "a cyberpunk cat in neon city"
```

With custom settings:
```bash
python3 scripts/generate.py "a cyberpunk cat" \
  --steps 20 \
  --cfg-scale 7.5 \
  --width 768 \
  --height 768 \
  --sampler "DPM++ 2M Karras"
```

Batch generation (5 variations):
```bash
python3 scripts/generate.py "a fantasy landscape" --batch-size 5
```

Save to specific location:
```bash
python3 scripts/generate.py "portrait photo" --output ./outputs/portrait.png
```

## API Usage

The skill provides a Python script that wraps the DrawThings API (Automatic1111-compatible):

**Main endpoint:** `POST /sdapi/v1/txt2img`

**Common parameters:**
- `prompt` - Text description of the image
- `negative_prompt` - What to avoid in the image
- `steps` - Number of diffusion steps (8-50, default: 20)
- `sampler_name` - Sampler algorithm (default: "DPM++ 2M Karras")
- `cfg_scale` - Classifier-free guidance scale (1.0-20.0, default: 7.0)
- `width` / `height` - Image dimensions (default: 512x512)
- `batch_size` - Number of images to generate (default: 1)
- `seed` - Random seed for reproducibility (-1 for random)

See `references/api-reference.md` for complete API documentation.

## Presets

**Fast (8 steps, UniPC Trailing):**
```bash
python3 scripts/generate.py "your prompt" --preset fast
```

**Quality (30 steps, DPM++ 2M Karras):**
```bash
python3 scripts/generate.py "your prompt" --preset quality
```

**NFT (optimized for 512x512 with good detail):**
```bash
python3 scripts/generate.py "your prompt" --preset nft
```

## Workflow Examples

**Character variations:**
```bash
python3 scripts/generate.py "electric sheep, glowing wool, cyberpunk" \
  --batch-size 10 \
  --steps 20 \
  --cfg-scale 7.5
```

**High-res output:**
```bash
python3 scripts/generate.py "detailed portrait" \
  --width 1024 \
  --height 1024 \
  --steps 30 \
  --sampler "DPM++ 2M Karras"
```

**Reproducible generation:**
```bash
python3 scripts/generate.py "landscape" --seed 42
# Re-run with same seed for identical output
```

## Output

Images are saved as PNG files with metadata embedded:
- Prompt, negative prompt
- Generation parameters (steps, sampler, cfg_scale, etc.)
- Timestamp and seed

Default location: `./drawthings_output_YYYYMMDD_HHMMSS.png`

## Troubleshooting

**"Connection refused"**
- Ensure DrawThings is running
- Check the API server is enabled in DrawThings preferences
- Verify the port matches (default: 7860)

**"Generation failed"**
- Check prompt length (max ~75 tokens per CLIP model)
- Reduce dimensions if out of memory
- Try a different sampler

**Slow generation**
- Use fewer steps (8-12 for drafts)
- Reduce image dimensions (512x512)
- Use faster samplers (UniPC, Euler A)

**Canvas display quirk (visual only)**
- DrawThings UI doesn't clear the canvas between generations
- New images appear to render on top of previous ones in the app
- This is purely cosmetic - API outputs are unaffected

## Tips

- **CFG Scale**: Lower (1-3) for creative/artistic, higher (7-12) for prompt adherence
- **Steps**: 8-12 for drafts, 20-30 for final images, 50+ rarely needed
- **Samplers**: UniPC/Euler A are fast, DPM++ 2M Karras is quality, LCM for ultra-fast
- **Dimensions**: Keep to multiples of 64 (512, 768, 1024)
- **Batch processing**: Use `--batch-size` for variations, not multiple script calls

## Models

DrawThings supports Stable Diffusion models. To change models:
1. Open DrawThings app
2. Select model from the UI
3. The API will use the currently selected model

See `references/models.md` for recommended models and download sources.
