---
name: content-generation
version: "1.0.0"
description: "Generate high-quality content across multiple formats. Create articles, reports, social media posts, marketing copy, and other content types with professional quality and consistency.\n"
metadata:
  openclaw:
    emoji: "📝"
    requires:
      bins: ["curl", "jq", "git"]
      env: ["BRAVE_API_KEY"]
    install:
      - id: npm
        kind: node
        package: axios
        bins: ["axios"]
---

# Content Generation

Generate high-quality content across multiple formats.

## When to Use
- Creating articles and blog posts
- Writing marketing copy and ads
- Generating social media content
- Producing reports and documentation
- Creating any written content

## Core Capabilities

### 1. Content Types
- Articles and blog posts
- Marketing copy and ads
- Social media posts
- Reports and documentation
- Email newsletters
- Product descriptions
- Technical documentation

### 2. Writing Styles
- Professional and formal
- Casual and conversational
- Technical and detailed
- Creative and engaging
- Persuasive and sales-oriented
- Educational and informative

### 3. Format Adaptation
- Web content (SEO optimized)
- Social media (platform-specific)
- Email (engagement focused)
- Print (professional quality)
- Technical (precise and clear)

### 4. Quality Assurance
- Grammar and spelling check
- Style consistency
- Tone and voice alignment
- Fact checking and verification
- Readability optimization

## Content Creation Process

```
1. AUDIENCE ANALYSIS → Understand target readers
2. PURPOSE DEFINITION → Clarify content goals
3. RESEARCH → Gather relevant information
4. OUTLINING → Structure the content
5. DRAFTING → Write the initial content
6. EDITING → Refine and improve
7. OPTIMIZATION → SEO and formatting
```

## Quick Actions

- `write article [topic]` - Create comprehensive article
- `generate blog post [topic]` - Write engaging blog content
- `create marketing copy [product]` - Write sales copy
- `social media post [topic]` - Generate social content
- `technical documentation [topic]` - Create technical docs

## Usage Examples

```
"Write a comprehensive article about AI agent monetization"
"Generate a blog post about the future of autonomous agents"
"Create marketing copy for a new OpenClaw feature"
"Write a Twitter thread about self-evolution in AI"
"Produce technical documentation for the self-evolution skill"
```

## Content Types and Formats

### 1. Articles and Blog Posts
- **Format**: Long-form content (800-2000 words)
- **Style**: Informative and engaging
- **Structure**: Introduction, body, conclusion
- **SEO**: Optimized for search engines

### 2. Marketing Copy
- **Format**: Short-form (50-500 words)
- **Style**: Persuasive and benefit-focused
- **Structure**: Hook, benefits, call-to-action
- **Goal**: Drive conversions and sales

### 3. Social Media Content
- **Format**: Platform-specific (Twitter, LinkedIn, etc.)
- **Style**: Engaging and shareable
- **Structure**: Hook, value, call-to-action
- **Goal**: Engagement and reach

### 4. Reports and Documentation
- **Format**: Professional and detailed
- **Style**: Clear and informative
- **Structure**: Organized and structured
- **Goal**: Information and guidance

## Writing Process

### 1. Research and Planning
- Research the topic thoroughly
- Define target audience and goals
- Create detailed outline
- Gather supporting information

### 2. Drafting
- Write first draft following outline
- Focus on content, not perfection
- Include all key points
- Maintain consistent tone

### 3. Editing and Refinement
- Review for clarity and flow
- Check grammar and spelling
- Optimize for readability
- Enhance engagement and impact

### 4. Optimization
- SEO optimization for web content
- Platform-specific formatting
- Call-to-action placement
- Visual elements and formatting

## Quality Assurance

### 1. Grammar and Spelling
- Use grammar checking tools
- Verify spelling accuracy
- Check punctuation and formatting
- Ensure consistency

### 2. Style and Tone
- Maintain consistent voice
- Match target audience preferences
- Ensure appropriate tone
- Check for brand alignment

### 3. Fact Checking
- Verify all claims and data
- Check source credibility
- Ensure accuracy of information
- Update outdated information

### 4. Readability
- Check sentence length and structure
- Ensure clear and concise writing
- Use appropriate vocabulary
- Maintain logical flow

## SEO Optimization

### 1. Keyword Research
- Identify relevant keywords
- Analyze search volume and competition
- Include primary and secondary keywords
- Use natural keyword placement

### 2. On-Page SEO
- Optimize title and meta description
- Use header tags properly
- Include internal and external links
- Optimize images and media

### 3. Content Structure
- Use clear headings and subheadings
- Include bullet points and lists
- Add tables and visual elements
- Ensure logical flow and organization

### 4. Technical SEO
- Optimize page load speed
- Ensure mobile responsiveness
- Use proper HTML structure
- Implement schema markup

## Platform-Specific Guidelines

### 1. Twitter
- **Length**: 280 characters maximum
- **Style**: Conversational and engaging
- **Format**: Short sentences, hashtags, mentions
- **Goal**: Engagement and retweets

### 2. LinkedIn
- **Length**: 1300 characters maximum
- **Style**: Professional and informative
- **Format**: Clear structure, industry terms
- **Goal**: Professional networking and thought leadership

### 3. Blog Posts
- **Length**: 800-2000 words
- **Style**: Informative and engaging
- **Format**: SEO optimized, visual elements
- **Goal**: Traffic and engagement

### 4. Email Newsletters
- **Length**: 200-500 words
- **Style**: Personal and conversational
- **Format**: Scannable, mobile-friendly
- **Goal**: Open rates and click-throughs

## Content Strategy

### 1. Audience Analysis
- Define target audience
- Understand their needs and preferences
- Identify pain points and challenges
- Determine content consumption habits

### 2. Content Planning
- Create content calendar
- Plan content themes and topics
- Align with business goals
- Schedule publication dates

### 3. Distribution Strategy
- Choose appropriate channels
- Optimize for each platform
- Schedule for maximum impact
- Track and measure performance

### 4. Performance Analysis
- Track engagement metrics
- Analyze content performance
- Identify successful patterns
- Optimize based on data

## Advanced Features

### 1. A/B Testing
- Test different headlines
- Compare content variations
- Analyze performance data
- Optimize based on results

### 2. Personalization
- Tailor content to audience segments
- Customize messaging and tone
- Personalize recommendations
- Enhance relevance and engagement

### 3. Content Repurposing
- Transform content for different formats
- Update and refresh existing content
- Create content series
- Maximize content value

### 4. Collaboration Features
- Work with other agents
- Coordinate content creation
- Share resources and information
- Maintain consistency

## Integration with Other Skills

### 1. Autonomous Research
- Research topics thoroughly
- Gather supporting information
- Verify facts and data
- Create evidence-based content

### 2. Task Orchestra
- Coordinate multi-agent content creation
- Manage content production pipelines
- Orchestrate content distribution
- Handle content campaigns

### 3. Analysis Skills
- Apply data analysis to content
- Use insights for optimization
- Create data-driven content
- Measure content performance

## Best Practices

1. **Know Your Audience**: Understand who you're writing for
2. **Define Clear Goals**: Know what you want to achieve
3. **Research Thoroughly**: Gather comprehensive information
4. **Structure Clearly**: Organize content logically
5. **Write Engagingly**: Keep readers interested
6. **Optimize for Platform**: Adapt to each channel
7. **Proofread Carefully**: Ensure quality and accuracy
8. **Test and Iterate**: Improve based on performance

## Content Templates

### 1. Blog Post Template
```markdown
# [Title]

## Introduction
- Hook and context
- Problem statement
- Value proposition

## Main Content
- Key points and sections
- Supporting evidence
- Examples and case studies

## Conclusion
- Summary of key points
- Call-to-action
- Next steps
```

### 2. Marketing Copy Template
```markdown
## Headline
- Attention-grabbing statement

## Benefits
- Key benefits and features
- Value proposition
- Social proof

## Call-to-Action
- Clear next step
- Urgency and scarcity
- Contact information
```

### 3. Social Media Template
```markdown
## Hook
- Attention-grabbing opening
- Question or statement

## Value
- Key insight or information
- Benefit to reader
- Supporting evidence

## Action
- What to do next
- Call-to-action
- Engagement prompt
```

## Success Metrics

- **Engagement**: Likes, shares, comments, clicks
- **Traffic**: Page views, time on page, bounce rate
- **Conversions**: Leads, sales, sign-ups
- **Quality**: Grammar, readability, accuracy
- **SEO**: Rankings, organic traffic, backlinks
- **Brand**: Consistency, voice, recognition

---

**Remember**: Great content informs, engages, and converts.