# Ebooks, Academic Papers & Comics

## Table of Contents
- [Shadow Libraries](#shadow-libraries)
- [Public Domain / Legal Ebooks](#public-domain--legal-ebooks)
- [Academic Papers](#academic-papers)
- [Audiobooks](#audiobooks)
- [Manga & Comics](#manga--comics)
- [Chinese Ebooks](#chinese-ebooks)
- [Download Tips](#download-tips)

---

## Shadow Libraries

Domains change frequently. If a URL is dead, search `[site name] mirror 2026` or check Anna's Archive.

| Name | URL | Scale | Format | Notes |
|------|-----|-------|--------|-------|
| **Anna's Archive** | annas-archive.li / .gl / .in | 61M+ books, 95M+ papers | All | Unified search across LibGen + Sci-Hub + Z-Lib. Check current domain -- .org/.se/.pm suspended. |
| **Z-Library** | z-lib.id / z-library.sk | 10M books, 85M articles | All | Registration required. Daily download limits (5-10/day free). |
| **Library Genesis (LibGen)** | libgen.li / libgen.rs / libgen.st | Millions | PDF/EPUB/DJVU | Oldest shadow library. Multiple mirrors. Some domains time out -- try alternates. |

## Public Domain / Legal Ebooks

| Name | URL | Scale | Format | Notes |
|------|-----|-------|--------|-------|
| **Project Gutenberg** | gutenberg.org | 70,000+ | EPUB/Kindle/HTML/TXT | Public domain only. No registration. Oldest digital library. |
| **Standard Ebooks** | standardebooks.org | 900+ | EPUB/Kindle/EPUB3 | Beautifully typeset public domain books. Curated, high-quality formatting. |
| **Open Library** | openlibrary.org | Millions | EPUB/PDF (borrow) | Internet Archive lending library. Free account required. 14-day borrow, 1 book at a time. |
| **Internet Archive Books** | archive.org/details/texts | 20M+ | PDF/EPUB/DJVU | Massive collection. Includes scanned books, magazines, government docs. |
| **ManyBooks** | manybooks.net | 50,000+ | EPUB/Kindle/PDF | Aggregates public domain + indie authors. Clean interface. |

## Academic Papers

| Name | URL | Scale | Access | Notes |
|------|-----|-------|--------|-------|
| **Sci-Hub** | sci-hub.se / .st / .ru | 85M+ papers | Paste DOI or URL | Corpus frozen ~2022, no new papers after that. Domain rotates. |
| **arXiv** | arxiv.org | 2.4M+ | Free, legal | Preprints: physics, math, CS, bio, econ. No paywall. PDF direct download. |
| **CORE** | core.ac.uk | 402M+ | Free, legal | Aggregates open access papers from repositories worldwide. API available. |
| **Semantic Scholar** | semanticscholar.org | 200M+ | Free, legal | AI-powered academic search. PDF links when available. API for batch queries. |
| **PubMed Central** | pmc.ncbi.nlm.nih.gov | 8M+ | Free, legal | Biomedical/life sciences full-text archive. Free access mandated by NIH. |
| **Unpaywall** | unpaywall.org | 30M+ OA articles | Browser extension | Finds legal open-access versions of paywalled papers. Also has API. |
| **Google Scholar** | scholar.google.com | Index only | Search | Often links to free PDFs. Use `filetype:pdf` in Google for direct hits. |
| **Connected Papers** | connectedpapers.com | Visual exploration | Search | Builds visual graph of related papers. Great for literature review. |

## Audiobooks

| Name | URL | What | Notes |
|------|-----|------|-------|
| **LibriVox** | librivox.org | 20,000+ free public domain audiobooks | Volunteer-read. Quality varies. MP3/OGG. Free, no account needed. |
| **AudioBook Bay (ABB)** | audiobookbay.lu (check current) | Audiobook torrents | Requires torrent client. Domain changes. Large catalog. |
| **Libby** | libbyapp.com | Library ebook/audiobook lending | Requires library card. Borrow for free. OverDrive-powered. |
| **Internet Archive Audio** | archive.org/details/audio | Audiobooks + live music + radio | Public domain audiobooks section. Free. |
| **Loyal Books** | loyalbooks.com | 7,000+ free audiobooks | Public domain. MP3 + podcast feed. |

## Manga & Comics

| Name | URL | What | Notes |
|------|-----|------|-------|
| **MangaDex** | mangadex.org | Community-driven manga | Multi-language. Fan translations. Free, no ads. API available. |
| **MANGA Plus** | mangaplus.shueisha.co.jp | Official Shueisha manga | Legal. Free first/latest chapters. Simulpub with Japan. |
| **GetComics** | getcomics.org | DC/Marvel/indie comics | DDL links. Western comics focus. |
| **ComicExtra** | comicextra.me (check current) | Online comic reading | Web reader. Domain changes. |
| **Nyaa** | nyaa.si | Manga scanlation torrents | Under "Literature" category. Japanese/English. |

## Chinese Ebooks

| Name | URL | What | Notes |
|------|-----|------|-------|
| **鸠摩搜书** | jiumodiary.com | Aggregated ebook search engine | Searches multiple sources. Direct download links. Best starting point for Chinese ebooks. |
| **熊猫搜书** | xmsoushu.com (check current) | Ebook search aggregator | Similar to 鸠摩. Domain may change. |
| **书格** | www.shuge.org | Chinese classical texts / ancient books | Scanned originals. High-quality digitization. Free. |
| **书伴** | bookfere.com | Kindle resources + ebook tools | Calibre guides, format conversion tips, ebook sources list. |
| **Z-Library** | z-lib.id | Chinese books too | Has significant Chinese-language collection. Same limits as English. |

## Download Tips

- **Format priority for ebooks:** EPUB > AZW3/MOBI (Kindle) > PDF. EPUB reflows; PDF doesn't.
- **Calibre** (`brew install --cask calibre`) converts between all ebook formats.
- **DOI to PDF pipeline:** Have DOI? Try `sci-hub.se/DOI` first. If blocked, search DOI on Semantic Scholar or CORE for open-access version.
- **For textbooks:** Check Anna's Archive first (largest index), then LibGen, then Z-Library.
- **Chinese academic papers:** CNKI (cnki.net) is paywalled but many universities provide access. Try searching the paper title on Google Scholar for free versions.
