# Cloud Drive Search (网盘搜索)

**This is critical infrastructure for Chinese internet users.** Resources are shared via cloud drives (Baidu Pan, Alibaba Cloud Drive, Quark, etc.), and specialized search engines index these shared links. This is the Chinese equivalent of torrent sites for the English internet.

---

## Domain Warning

Cloud drive search engine domains change frequently due to takedowns. If any URL below is dead:

1. Search `[站名] 最新地址` or `[站名] 新域名` on Baidu/Google
2. Check 网盘之家导航 (aggregator) for updated links
3. Search on Weibo or V2EX for community-shared current URLs

---

## Multi-Platform Aggregators

Search across Baidu Pan, Alibaba Cloud Drive, Quark, Xunlei, and more in one place.

| Name | URL | Platforms Covered | Notes |
|------|-----|-------------------|-------|
| **网盘之家导航** | wowenda.com | Links to many search engines | **Start here.** Navigation hub. Updated links to individual search engines. |
| **兄弟盘** | (search for current domain) | 7+ platforms (Ali, Quark, Xunlei, Baidu, etc.) | One of the most comprehensive. Multi-platform in one search. |
| **优聚搜** | v4.jujuso.com | Multiple platforms | Simple, fast. Clean results. (Previously ujuso.com, migrated 2025.) |
| **UP云搜** | upyunso.com | Alibaba Cloud Drive focus | Clean. No forced registration. |
| **1号线报** | (search for current domain) | 6+ platforms | Regular updates. Clean interface. |

## Alibaba Cloud Drive Search (阿里云盘搜索)

Alibaba Cloud Drive (阿里云盘) has become the dominant sharing platform due to fast speeds without VIP requirements.

| Name | URL | Notes |
|------|-----|-------|
| **猫狸盘搜** | alipansou.com | Most popular Ali pan search. Large index. No mandatory registration. |

## Baidu Pan Search (百度网盘搜索)

Baidu Pan is the oldest and most established, but free download speeds are severely throttled. VIP recommended.

| Name | URL | Notes |
|------|-----|-------|
| **学霸盘** | (search for current domain) | Academic/learning resources focus. Good for textbooks and course materials. |
| **小白盘** | (search for current domain) | Long-running. Simple interface. |

**Baidu Pan speed workaround:** Use aria2 with browser cookie export to bypass speed throttling on free accounts.

## Resource Navigation Sites (资源导航)

Curated link collections covering hundreds of resource sites, organized by category.

| Name | URL | What | Notes |
|------|-----|------|-------|
| **图欧学习资源导航** | tuostudy.upnb.top | Learning resources, AI tools, cloud drive links, software | **Excellent starting point.** Hundreds of curated links. Free, public. |
| **学吧导航** | xue8nav.com | Learning resources across 10+ categories | 400K+ users. Android app available. Covers programming, design, languages. |

## How to Use Cloud Drive Search (Workflow)

1. **Search** on an aggregator (优聚搜, 猫狸盘搜, etc.) using the resource name
2. **Click** the result link -- it will redirect to the cloud drive sharing page
3. **Save** to your own cloud drive (click "保存到网盘")
4. **Download** from your cloud drive app, or use a download manager

### For Agent Automation

Cloud drive search is browser-dependent (CAPTCHA, link verification). Agent role is:
- Help user identify the right search engine for their needs
- Provide the search URL with query embedded
- Guide through the save-and-download workflow
- Suggest alternative search engines if one is down

## Cloud Drive Comparison

| Platform | Free Space | Free Speed | Sharing | Notes |
|----------|-----------|------------|---------|-------|
| **阿里云盘** | 100GB+ | Fast | Active community | Best overall for sharing. No speed throttle on free tier. |
| **百度网盘** | 5GB (free) | Heavily throttled | Largest legacy library | Most content historically, but speed is terrible without VIP (~100KB/s). |
| **夸克网盘** | 10GB | Fast | Growing | By Alibaba. Clean UI. Growing content. |
| **迅雷云盘** | 6GB | Fast | Some | Built-in P2P acceleration. |
| **123云盘** | 2TB | Fast | Growing | Generous free space. |

## Tips

- **Alibaba Cloud Drive is the current best** for Chinese resource sharing. Most new shares go here.
- **Baidu Pan is legacy** -- huge catalog of older resources, but terrible free-tier speeds. Only use if the resource isn't on Ali.
- **"阿里云盘" + resource name** on Google/Baidu is a quick search shortcut.
- **Sharing links expire.** If a link is dead, search again -- someone usually re-shares popular resources.
- **For academic resources** (textbooks, papers, courses), 学霸盘 and 图欧导航 are the best entry points.
- **For entertainment** (movies, TV, music), 猫狸盘搜 and 优聚搜 have the broadest coverage.
