# 抖音热榜获取技能

获取抖音热榜/热搜榜数据，包含热门视频、挑战赛、音乐等多领域热门内容，并输出标题、热度值与跳转链接。

## 功能特性

- 🔥 **实时热榜**: 获取抖音最新热门内容
- 📊 **热度值**: 显示每个话题的热度评分
- 🔗 **跳转链接**: 提供详情页直达链接
- 🎯 **自定义数量**: 可指定获取前 N 条数据
- 📱 **多领域内容**: 热门视频、挑战赛、音乐等

## 快速开始

```bash
# 获取抖音热榜前 50 条（默认）
node scripts/douyin.js hot

# 获取前 20 条
node scripts/douyin.js hot 20

# 获取前 10 条
node scripts/douyin.js hot 10
```

## 输出格式

每条热榜包含：
- 📌 **排名**: 热榜排名
- 🔥 **标题**: 热门话题/视频标题
- 📊 **热度值**: 热度评分
- 🔗 **链接**: 详情页跳转链接

## 使用示例

```bash
# 获取热门前 20
node scripts/douyin.js hot 20

# 输出示例：
# 1. 🔥 xxx话题
#    热度：1234567
#    链接：https://www.douyin.com/...
```

## 数据来源

抖音网页端公开接口

## 注意事项

- ⚠️ 该接口为网页端公开接口，返回结构可能变动
- ⚠️ 访问频繁可能触发风控
- ⚠️ 建议合理使用，避免频繁请求

## 使用场景

- 📰 热点追踪
- 📊 内容趋势分析
- 🎯 营销策划参考
- 📱 社交媒体运营

## Author

franklu0819-lang

## License

MIT
