#!/bin/bash
# 抖音最佳发布时间建议
# 用法: ./time.sh "账号类型"

ACCOUNT_TYPE="${1:-通用}"

echo "================================"
echo "⏰ 发布时间建议: $ACCOUNT_TYPE"
echo "================================"
echo ""

# 基于数据分析的最佳发布时间
case "$ACCOUNT_TYPE" in
  "美食"|"吃货")
    echo "🍽️ 美食类最佳发布时间:"
    echo ""
    echo "工作日:"
    echo "  - 早高峰: 07:00-08:30（早餐灵感）"
    echo "  - 午休: 11:30-13:00（午餐决策）"
    echo "  - 晚高峰: 17:00-19:00（晚餐准备）"
    echo "  - 夜宵: 21:00-23:00（深夜食堂）"
    echo ""
    echo "周末:"
    echo "  - 上午: 10:00-12:00（brunch 时间）"
    echo "  - 下午: 15:00-17:00（下午茶）"
    echo "  - 晚上: 19:00-22:00（聚餐时间）"
    ;;
  "穿搭"|"时尚")
    echo "👗 穿搭类最佳发布时间:"
    echo ""
    echo "工作日:"
    echo "  - 早高峰: 07:00-08:30（今日穿搭）"
    echo "  - 午休: 12:00-13:00（刷手机时间）"
    echo "  - 晚上: 20:00-22:00（购物时间）"
    echo ""
    echo "周末:"
    echo "  - 下午: 14:00-17:00（逛街时间）"
    echo "  - 晚上: 19:00-23:00（购物高峰）"
    ;;
  "搞笑"|"段子")
    echo "😂 搞笑类最佳发布时间:"
    echo ""
    echo "全天候内容，但以下时间效果更好:"
    echo "  - 午休: 11:30-13:30"
    echo "  - 晚高峰: 18:00-21:00"
    echo "  - 睡前: 22:00-00:00"
    ;;
  "知识"|"科普")
    echo "📚 知识类最佳发布时间:"
    echo ""
    echo "工作日:"
    echo "  - 早通勤: 07:30-09:00（碎片学习）"
    echo "  - 午休: 12:00-13:30"
    echo "  - 晚通勤: 18:00-19:30"
    echo ""
    echo "周末:"
    echo "  - 上午: 09:00-11:00（学习时间）"
    echo "  - 下午: 14:00-16:00"
    ;;
  *)
    echo "📱 通用最佳发布时间:"
    echo ""
    echo "工作日:"
    echo "  - 早高峰: 07:00-09:00"
    echo "  - 午休: 11:30-13:30"
    echo "  - 晚高峰: 18:00-21:00"
    echo "  - 睡前: 22:00-00:00"
    echo ""
    echo "周末:"
    echo "  - 上午: 10:00-12:00"
    echo "  - 下午: 15:00-18:00"
    echo "  - 晚上: 20:00-23:00"
    ;;
esac

echo ""
echo "💡 通用建议:"
echo "- 保持固定发布频率（每天 1-3 条）"
echo "- 避开凌晨 2:00-6:00（流量低谷）"
echo "- 节假日和周末流量更高"
echo "- 重大事件期间发布要谨慎"
echo ""
