#!/bin/bash
# 抖音热门标签推荐
# 用法: ./tags.sh "内容类型"

CONTENT_TYPE="${1:-热门}"

# 抖音热门标签数据库（模拟，实际应该从 API 获取）
case "$CONTENT_TYPE" in
  "美食"|"吃货")
    TAGS="#美食 #吃货 #家常菜 #今天吃什么 #美食分享 #烹饪 #厨房 #美味"
    TRENDING="#挑战做一道菜 #美食vlog #做饭日常"
    ;;
  "穿搭"|"时尚")
    TAGS="#穿搭 #时尚 #OOTD #今日穿搭 #穿搭分享 #女装 #男装"
    TRENDING="#穿搭挑战 #换装视频 #街拍"
    ;;
  "搞笑"|"段子")
    TAGS="#搞笑 #段子 #沙雕 #日常 #vlog #生活 #娱乐"
    TRENDING="#搞笑视频 #沙雕日常 #反转"
    ;;
  "知识"|"科普")
    TAGS="#知识 #科普 #学习 #干货 #分享 #教育 #成长"
    TRENDING="#冷知识 #科普视频 #知识分享"
    ;;
  "游戏"|"电竞")
    TAGS="#游戏 #电竞 #王者荣耀 #原神 #LOL #和平精英"
    TRENDING="#游戏日常 #高光时刻 #游戏解说"
    ;;
  *)
    # 通用热门标签
    TAGS="#热门 #推荐 #fyp #foryou #日常 #生活 #vlog"
    TRENDING="#上热门 #推荐 #热门话题"
    ;;
esac

echo "================================"
echo "🎯 内容类型: $CONTENT_TYPE"
echo "================================"
echo ""
echo "📝 推荐标签:"
echo "$TAGS"
echo ""
echo "🔥 热门趋势标签:"
echo "$TRENDING"
echo ""
echo "💡 使用建议:"
echo "- 选择 3-5 个相关标签"
echo "- 混合使用大标签和小标签"
echo "- 加入 1-2 个热门趋势标签"
echo "- 避免使用过多标签（建议不超过 8 个）"
echo ""
