---
name: plansuite
description: Unified planning+execution workflow: create a file-based plan with sub-plans, freeze it as FINALIZED, and execute in a separate session with checkpoints and progress/findings logs. Use when you want project plans with subplans (milestones), controlled execution, and session-based implementation runs.
---

# PlanSuite

把“写计划（含子计划）→ 冻结计划（变更控制）→ 独立会话执行（带检查点）”合成一个最小可用流程。

## 文件结构（在当前工作目录创建/维护）
- `task_plan.md`：计划主文件（含子计划/里程碑）
- `progress.md`：执行进度（每次推进都要写）
- `findings.md`：发现/决策/坑点（避免重复踩坑）

> 不要把这三份写到聊天里：写到文件，才能恢复/续跑。

## 工作流（强约束，防跑偏）

### 0) 初始化（第一次做这个项目）
1. 如果缺文件：用模板创建 `task_plan.md/progress.md/findings.md`（见 `templates/`）。
2. 让用户确认目标、范围、约束、完成定义（DoD）。

### 1) 计划阶段（拆子计划）
在 `task_plan.md` 里输出：
- 背景/目标
- 范围（做/不做）
- 风险 & 回滚
- 子计划（Milestones）：每个子计划要有
  - 输入/输出
  - 验收标准
  - 预计工具调用/文件改动
  - 风险与回滚点

### 2) 冻结阶段（FINALIZED）
只有当用户明确说“按这个计划执行”后：
1. 在 `task_plan.md` 顶部写入：`STATUS: FINALIZED` + 时间戳。
2. 把“接下来要执行的子计划编号/名称”写入 `progress.md` 的 `Next`。

> 规则：未 FINALIZED 不允许进入执行阶段（最多做调查/补充计划）。

### 3) 执行阶段（独立会话 + 检查点）
当进入执行：
1. 建议用 `sessions_spawn` 开一个隔离执行会话（避免污染主会话上下文）。
2. 每完成一个子计划：
   - 更新 `progress.md`（Done/Next/Blockers）
   - 更新 `findings.md`（关键决策、踩坑、验证命令、回滚步骤）
3. 检查点策略（默认每个子计划至少一次）：
   - 执行前：复述子计划的 DoD + 风险 + 回滚
   - 执行后：给出验证步骤 + 结果

### 4) 变更控制（计划变更）
如果执行中发现计划不成立：
1. 不要“边做边改”。先写入 `findings.md`，再把变更提案写入 `task_plan.md`。
2. 把 `STATUS` 改为 `DRAFT`，等待用户重新确认。

## 你在什么时候用什么文件
- 需要问清楚/拆任务 → `task_plan.md`
- 需要告诉用户进度/下一步 → `progress.md`
- 需要记录结论/命令/坑/回滚 → `findings.md`

## 模板
- `templates/task_plan.md`
- `templates/progress.md`
- `templates/findings.md`
