---
name: double-check-article
description: 中文文章内容检查工具，用于校对和改进中文文章质量。当用户需要检查中文文章、校对中文内容、修改错别字、优化中文表达、审核中文文档时使用此技能。适用于：(1) 检查错别字和typo (2) 审核表达是否清晰合理 (3) 提供修改建议
---

# 中文文章检查器

对中文文章进行三步检查：错别字修正、表达优化、改进建议。

## 检查流程

### 第一步：错别字检查

仔细阅读全文，识别并修正以下问题：

- **同音字错误**：如"以经"→"已经"、"在见"→"再见"
- **形近字错误**：如"己经"→"已经"、"未免"→"未免/味免"
- **多字/少字**：如"我们们"→"我们"、"因"→"因为"
- **标点错误**：中英文标点混用、标点缺失

**输出格式**：
```
【错别字修正】
1. "原文" → "修正后" （位置：第X段）
2. ...

如无错别字，输出：未发现错别字。
```

### 第二步：表达检查

审核文章表达的清晰度和合理性：

- **语句通顺**：主谓宾是否完整，语序是否正确
- **逻辑连贯**：上下文是否衔接，因果关系是否合理
- **用词准确**：词语搭配是否恰当，避免词不达意
- **明显错误**：事实性错误、常识性错误

**输出格式**：
```
【表达修正】
1. 原句："..."
   问题：[描述问题]
   修正："..."
2. ...

如无明显问题，输出：表达清晰，无需修正。
```

### 第三步：改进建议

基于文章整体质量，提供进一步优化建议：

- **结构优化**：段落划分、层次安排
- **风格统一**：语气、用词风格一致性
- **内容充实**：论据补充、细节完善
- **可读性提升**：长句拆分、专业术语解释

**输出格式**：
```
【改进建议】
1. [具体建议]
2. [具体建议]
...

如文章已较完善，可简要说明亮点并给出可选优化方向。
```

## 输出模板

```
## 文章检查报告

### 第一步：错别字检查
[检查结果]

### 第二步：表达检查
[检查结果]

### 第三步：改进建议
[建议内容]
```
