---
name: dog-potty-training
description: 狗狗如厕训练 - 记录排尿日志、遛狗提醒、意外追踪、进步分析。适合成年犬行为矫正。
version: 1.0.0
tags: dog, pet, training, potty
---

# 狗狗如厕训练 (Dog Potty Training)

专为成年犬如厕行为矫正设计的训练追踪技能，提供遛狗提醒、意外记录、进步分析和奖励追踪。

## ⚠️ 重要提醒

**成年犬训练原则：**
- ✅ 不惩罚，只奖励正确行为
- ✅ 耐心，习惯改变需要 2-4 周
- ✅ 一致性，全家人用同样规则
- ✅ 彻底清理旧尿渍（酶清洁剂）

**禁忌：**
- ❌ 事后打骂（狗记不住）
- ❌ 鼻子按尿渍（无效且伤害信任）
- ❌ 规则不一致（今天允许明天不许）

## 触发条件

用户可能说：
- "遛狗回来了，尿了"
- "在家又尿了，在客厅"
- "今天遛了几次"
- "记录训练"
- "看看进步怎么样"
- "狗狗又在卧室尿了"

## 核心功能

### 1. 遛狗/排尿记录

**记录格式**（写入 `memory/dog-training.md`）：
```markdown
## 2026-02-25

### 外出排尿
| 时间 | 地点 | 排尿情况 | 是否奖励 | 备注 |
|------|------|---------|---------|------|
| 07:00 | 小区树下 | 尿了 2 次 | ✅ 零食 | 很顺利 |
| 12:00 | 公园草地 | 尿了 1 次 | ✅ 夸奖 | - |
| 18:00 | 小区树下 | 尿了 2 次 | ✅ 零食 | - |
| 22:00 | 小区树下 | 没尿 | - | 玩了一会儿 |

### 室内意外
| 时间 | 地点 | 发现方式 | 清理方式 | 备注 |
|------|------|---------|---------|------|
| 10:30 | 客厅角落 | 主动发现 | 酶清洁剂 | 可能是标记 |
```

**快捷记录命令：**
```
"遛狗回来了，尿了 2 次"
"早上 7 点遛狗，尿了，给了零食"
"在家又尿了，在客厅"
"今天遛了 3 次，都尿了"
```

### 2. 遛狗提醒

**建议频率：**
- **成年犬**: 每 4-6 小时一次
- **老年犬 (7 岁+)**: 每 3-4 小时一次
- **训练期**: 增加频率，每 3-4 小时一次

**提醒话术示例：**
```
🐕 老刘，该遛狗了！

距离上次遛狗已经过去 5 小时。
现在带它去尿，成功率高。

记得：尿了立刻奖励！
```

### 3. 意外事故追踪

**记录要点：**
- 时间
- 地点（精确到房间/角落）
- 可能原因（没人带出去/标记/意外）
- 清理方式（必须用酶清洁剂）

**分析热点区域：**
如果某个地方反复尿，说明：
1. 气味没清干净
2. 狗狗把这里当厕所了

**解决方案：**
- 彻底清理（酶清洁剂）
- 喷禁区喷雾
- 暂时限制进入该区域

### 4. 进步分析

**每周统计：**
```
第 1 周 (2/25-3/3):
- 外出排尿：18 次 ✅
- 室内意外：5 次 ⚠️
- 成功率：78%

第 2 周 (3/4-3/10):
- 外出排尿：21 次 ✅
- 室内意外：2 次 ⚠️
- 成功率：91% 🎉
```

**进步信号：**
- 意外次数减少
- 主动示意要出去（挠门/转圈）
- 能憋更长时间
- 外出排尿更迅速

### 5. 奖励追踪

**有效奖励：**
- 🍖 零食（高价值，如鸡肉干）
- 👍 夸张夸奖（"好狗！" 高音调）
- 🎾 玩耍（球/拔河）
- ⏱️ 3 秒内给（关联排尿行为）

**记录示例：**
```
奖励方式：零食 + 夸奖
效果：很好，狗狗会主动等奖励
```

## 训练阶段

### 阶段 1：密集训练（第 1-2 周）
- 每 3-4 小时遛一次
- 每次尿了立刻奖励
- 室内意外不惩罚，默默清理
- 限制活动范围（围栏/小房间）

### 阶段 2：巩固期（第 3-4 周）
- 逐渐延长遛狗间隔到 4-6 小时
- 奖励频率降低（隔次奖励）
- 扩大活动范围
- 观察是否主动示意

### 阶段 3：维持期（第 5 周+）
- 正常遛狗频率（每天 3-4 次）
- 偶尔奖励（随机强化）
- 完全自由活动
- 定期回顾进步

## 数据记录

**文件位置**: `memory/dog-training.md`

**数据结构：**
```markdown
# 🐕 狗狗训练日志

## 基本信息
- **名字**: [狗狗名字]
- **年龄**: 8 岁
- **品种**: [品种]
- **训练开始**: 2026-02-25
- **训练目标**: 只在外出时排尿

## 本周统计
| 周次 | 外出排尿 | 室内意外 | 成功率 | 备注 |
|------|---------|---------|-------|------|
| 第 1 周 | 18 次 | 5 次 | 78% | 开始训练 |

## 每日记录
### 2026-02-25
[详细记录]
```

## 配置选项

在 `TOOLS.md` 中配置：
```markdown
### 狗狗训练
- 名字：[狗狗名字]
- 年龄：8 岁
- 遛狗频率：每 4 小时
- 奖励方式：零食 + 夸奖
- 禁区喷雾：已购买
- 酶清洁剂：已购买
```

## 使用示例

**用户**: "遛狗回来了，尿了 2 次"
**助手**: "记下了：
- 时间：现在
- 排尿：2 次 ✅
- 地点：外出

🐕 给奖励了吗？零食 + 夸奖，3 秒内给效果最好！"

**用户**: "客厅又尿了"
**助手**: "记下了意外：
- 时间：现在
- 地点：客厅

⚠️ 老刘，注意：
1. 用酶清洁剂彻底清理（普通清洁剂不行）
2. 看看是不是固定角落，是的话喷禁区喷雾
3. 别打它，8 岁狗打了也没用，反而害怕

今天遛了几次了？是不是间隔太长了？"

**用户**: "看看这周进步怎么样"
**助手**: "🐕 训练周报（第 1 周）：

| 指标 | 数据 | 趋势 |
|------|------|------|
| 外出排尿 | 18 次 | ✅ 正常 |
| 室内意外 | 5 次 | ⚠️ 需改进 |
| 成功率 | 78% | 📈 起步阶段 |

**热点区域**: 客厅角落（3 次）
**建议**: 
1. 彻底清理客厅角落
2. 暂时限制进入客厅
3. 增加遛狗频率到每 3 小时

坚持住，第 2 周会明显改善！"

---

**记住**: 8 岁的狗改习惯需要耐心，但完全能改善！坚持记录，看到进步会更有动力！🐕
