# docx-formatter

**公文格式规范生成器**

严格按照中国公文格式规范生成 Word 文档。

## 自动触发场景

当用户请求以下任务时，**自动使用此 skill**：
- 生成公文、报告、总结、方案等正式文档
- 润色、修改现有公文材料
- 需要符合公文格式规范的 Word 文档
- 民主生活会、述职报告等党政材料

**关键词识别：**
- "公文"、"材料"、"报告"、"总结"、"方案"
- "民主生活会"、"对照检查"、"述职"、"发言"
- "润色"、"修改"、"生成文档"
- "Word"、"docx"、"格式规范"

## 功能

- 生成符合公文格式规范的 .docx 文档
- 自动处理字体、段落、页码等格式
- 支持中文引号自动配对
- 支持多级标题和正文

## 安装

**首次使用前，运行一次安装脚本：**

```bash
cd ~/.openclaw/workspace/skills/docx-formatter
./install.sh
```

或者直接使用，脚本会自动检测并安装依赖。

## 使用方法

**推荐用法（从 Markdown 转换）：**

```bash
# 基本用法
./docx-formatter --from-markdown input.md --output output.docx

# 带署名
./docx-formatter --from-markdown input.md --output output.docx --author "长春市农业农村局\n2026年2月2日"
```

**高级用法（JSON 输入）：**

```bash
./docx-formatter --title "文档标题" --author "作者" --content content.json --output output.docx
```

**Markdown 格式规范：**

```markdown
# 文档标题（自动识别为大标题）

## 一、一级标题（黑体 3号）

### （一）二级标题（楷体 3号）

正文段落（仿宋 3号）

**1. ** 带加粗前缀的段落（前缀加粗）
```

## 格式规范

### 字体
- **大标题**：方正小标宋简体 2号
- **一级标题**：黑体 3号
- **二级标题**：楷体_GB2312 3号
- **正文**：仿宋_GB2312 3号
- **三级标题**：仿宋_GB2312 3号加粗（不另起一行）

### 段落
- **行间距**：固定值 28 磅
- **段前间距**：0
- **段后间距**：0
- **首行缩进**：2 字符（32 磅）
- **对齐方式**：两端对齐（标题、署名、日期居中）
- **孤行控制**：关闭

### 页面
- **纸张**：A4 (8.27" × 11.69")
- **页边距**：上下 1"，左右 1.25"
- **页码**：页脚居中，纯数字

### 标点
- **引号**：中文引号 " "（U+201C U+201D）
- **书名号**：《》
- **括号**：（）

## 示例

见 `examples/` 目录。

## 更新日志

- **2026-02-02**: 实现 Markdown 转换功能，添加一键安装脚本
