---
name: Documentation
description: Technical documentation patterns, structure, maintenance, and avoiding common documentation failures.
metadata:
  category: writing
  skills: ["documentation", "technical-writing", "readme", "api-docs"]
---

## Structure Hierarchy

- README: what it is, how to install, quick example — 5 minutes to first success
- Getting Started: guided tutorial for beginners — one complete workflow
- Guides: task-oriented ("How to X") — goal-focused, not feature-focused
- Reference: exhaustive API/CLI docs — complete but not for learning
- Troubleshooting: common errors with solutions — search-optimized

## README Essentials

1. One-sentence description — what problem it solves
2. Installation — copy-paste command that works
3. Quick start — minimal example that actually runs
4. Link to full docs — don't cram everything in README

Missing any of these = users bounce before trying.

## Code Examples

- Every example must be tested — untested examples rot within months
- Show complete runnable code, not fragments — users copy-paste
- Include expected output — confirms they did it right
- Bad: `client.query(...)` / Good: full script with imports, setup, and output
- Version-pin examples: `npm install package@2.1.0` not `npm install package`

## API Documentation

- Every endpoint needs: method, path, parameters, request body, response, error codes
- Show real request/response bodies — not just schemas
- Include authentication in every example — most common missing piece
- Document rate limits and pagination upfront — not buried in footnotes
- Error responses need as much detail as success responses

## What Gets Outdated

- Screenshots — UI changes, screenshots don't
- Version numbers — hardcoded versions become wrong
- Links — external sites move, break constantly
- "Current" anything — write timelessly or add review dates
- Feature flags and experimental warnings — often forgotten after GA

## Maintenance Patterns

- Docs live next to code — same repo, same PR. Separate repos drift
- CI checks for broken links — `markdown-link-check` or equivalent
- Runnable examples as tests — if example breaks, build fails
- Review date in docs: "Last verified: 2024-01" — signals freshness
- Delete aggressively — outdated docs worse than no docs

## Common Failures

- Documenting implementation, not usage — users don't care how it works internally
- Assuming context — define acronyms, link prerequisites
- Wall of text — use headings, bullets, code blocks liberally
- "See X for more info" without link — friction kills follow-through
- Changelog as documentation — changes ≠ how to use current version

## Writing Style

- Imperative mood: "Run the command" not "You can run the command"
- Second person: "you" not "the user"
- Present tense: "This returns X" not "This will return X"
- Short sentences — one idea per sentence
- Active voice: "The function returns X" not "X is returned by the function"

## Searchability

- Use words users search for — not internal jargon
- Error messages verbatim in troubleshooting — users paste exact errors
- Multiple ways to describe same thing — alias common variations
- H2/H3 headings are SEO — match user queries
- Avoid clever titles — "Getting Started" beats "Your Journey Begins"

## Versioned Documentation

- Major versions need separate docs — v1 users shouldn't see v2 docs
- Migration guides between versions — step-by-step, not just changelog
- Default to latest stable, link to older versions
- Mark deprecated features clearly — don't just remove
- URL structure: `/docs/v2/` not query params

## README Anti-patterns

- Badge spam — 15 badges before content
- Massive feature lists — save for marketing page
- No installation instructions — assuming everyone knows
- Screenshots without context — what am I looking at?
- License-only README — legal compliance ≠ documentation
