---
name: doctor-strange
description: >
  全球事件概率情报系统 — 基于 Polymarket Gamma API 的实时概率数据，生成5板块分析报告：
  热搜事件、概率飙升、不确定中的确定性(Analyst+Challenger)、三级市场影响、自选股叠加分析。
  触发关键词: ds scan, ds report, ds search, doctor strange
metadata:
  openclaw:
    requires:
      node: ">=18"
      bins: ["node"]
    install: []
---

# Doctor Strange 🔮 — 全球事件概率情报系统

在不确定性的混沌中，寻找确定性事件。

## 触发关键字
- `ds scan` — 快速扫描：热搜事件 + 概率飙升事件（板块一二）
- `ds scan <keyword>` — 关键词过滤扫描
- `ds report` — 完整日报：5 大板块全量分析
- `ds search -k <关键词>` — 搜索特定市场概率（如 `ds search -k fed`）
- `doctor strange` — 同 `ds report`

## 数据源
- **Polymarket Gamma API** (`gamma-api.polymarket.com`) — 免费公开，无需 API Key
- 需要代理访问（Clash Verge 规则: `DOMAIN-SUFFIX,polymarket.com`）

## 5 大板块输出

### 板块一：🔥 热搜事件 (Trending)
当天 Polymarket 交易量最高的事件，按类别分类（政治/经济/科技/加密/体育/其他）

### 板块二：🚀 概率飙升 (Movers)
24h 概率变动 >5% 的事件，分析驱动因素和连锁反应

### 板块三：🎯 不确定中的确定性 (Strange Certainties)
概率 >85% 或 <15% 的事件，运用 Analyst + Challenger 对抗机制验证确定性，给出对冲分析

### 板块四：💹 三级市场影响 (Market Impact)
事件对期货/股市/债市/汇市的影响，投资热点 + ⚠️风险警示

### 板块五：📈 自选股影响 (Watchlist)
宏观背景 × MDOSTATS 五维评分 → 个股趋势分析

## 执行流程

### `ds scan` (Phase 1)
```
1. 调用 src/gamma.js 拉取 Gamma API 数据
2. 按 volume24hr 排序 → 板块一（Top 15 热搜）
3. 按 oneDayPriceChange 排序 → 板块二（概率变动 >5%）
4. 按 probability_pct 筛选 → 板块三（确定性候选）
5. 保存快照到 data/snapshots/YYYY-MM-DDTHHMMSSZ.json
6. 格式化输出推送到当前 channel
```

### `ds report` (Phase 2+)
```
1. 执行 ds scan 获取数据
2. Analyst prompt 分析因果链 + 确定性事件
3. Challenger prompt 对抗检验
4. Synthesizer 生成板块三四五
5. 推送完整报告
```

### `ds search -k <keyword>`
```
1. 调用 Gamma API 搜索包含关键词的市场
2. 输出匹配市场的当前概率 + 变动趋势
```

## 技术实现
- **零依赖**: 仅使用 Node.js 原生 API (fetch, fs, path, crypto)
- **ES Modules**: import/export 语法
- **原子写入**: 快照/告警/报告使用 tmp+rename 模式，防止崩溃损坏
- **错误容忍**: API 重试 (3次指数退避)、脏数据 safeFloat 解析

## 输出格式
- 默认 Markdown 风格（适配 Slack/Discord）
- 支持 `--mode terminal` 输出 ANSI 终端样式

## 依赖
- Node.js >= 18 (原生 fetch API)
- mdostats skill（板块五个股分析）

## 文件结构
```
skills/doctor-strange/
├── SKILL.md              # 本文件
├── README.md             # 使用说明
├── config.json           # 配置文件
├── ds.js                 # CLI 入口
├── src/
│   ├── config.js        # 配置加载器
│   ├── gamma.js         # Gamma API 客户端
│   ├── snapshot.js      # 快照管理 + diff 引擎
│   ├── alerts.js        # 告警去重 + 原子写入
│   ├── formatter.js     # Terminal UI 格式化
│   └── cli.js           # CLI 入口
├── prompts/
│   ├── screener.md      # 初筛 + 聚类
│   ├── analyst.md       # 因果推理 + 确定性识别
│   ├── challenger.md    # 对抗检验
│   └── synthesizer.md   # 报告生成 (Phase 2)
└── data/
    ├── snapshots/       # 概率快照
    ├── reports/         # 分析报告
    └── alerts/          # 告警记录
```

## 设计文档
完整设计: `~/.openclaw/workspace/DESIGN-doctor-strange.md`
