# Doctor Strange 🔮

全球事件概率情报系统 — 基于 Polymarket Gamma API，在不确定性中寻找确定性。

## 功能

| 命令 | 说明 |
|------|------|
| `ds scan` | 快速扫描：热搜事件 + 概率飙升 |
| `ds scan <keyword>` | 关键词过滤扫描 |
| `ds report` | 完整 5 板块日报 |
| `ds search -k <keyword>` | 搜索特定市场 |

### 5 大板块
1. 🔥 热搜事件（按交易量排序）
2. 🚀 概率飙升（24h 变动 >5%）
3. 🎯 不确定中的确定性（Analyst + Challenger 对抗验证）
4. 💹 三级市场影响（股/债/汇）
5. 📈 自选股叠加分析

## 安装

### 方式一：Git Clone（推荐）

```bash
# 进入 OpenClaw workspace skills 目录
cd ~/.openclaw/workspace/skills

# Clone（需要 GitHub 访问权限）
git clone git@github.com:russellfei/doctor-strange.git
```

### 方式二：手动下载

1. 从 GitHub 下载 ZIP 并解压到 `~/.openclaw/workspace/skills/doctor-strange/`

### 要求

- **Node.js >= 18** — 使用原生 fetch API，无需额外依赖
- **代理** — Polymarket API 在中国大陆需要代理

### 代理配置 (Clash Verge)

```
DOMAIN-SUFFIX,polymarket.com,代理
```

## 使用

```bash
# 快速扫描（热搜 + 飙升 + 确定性）
node ds.js scan

# 关键词扫描
node ds.js scan iran
node ds.js scan bitcoin

# 搜索市场
node ds.js search -k "fed"
node ds.js search -k "iran"

# 完整日报
node ds.js report
```

### 选项

| 选项 | 说明 |
|------|------|
| `-l, --limit <n>` | 扫描市场数量（默认 150） |
| `-k, --keyword <word>` | 搜索关键词 |
| `--json` | 输出原始 JSON |
| `-m, --mode <mode>` | 输出模式：markdown（默认）或 terminal |

## 配置

编辑 `config.json`：

- **watchlist** — 自选股列表 (NVDA, 513300)
- **models** — 各任务使用的 AI 模型
- **movers_threshold** — 飙升检测阈值（默认 5%）
- **certainty_high** — 高确定性阈值（默认 85%）
- **certainty_low** — 低确定性阈值（默认 15%）
- **alert_threshold_pct** — 告警阈值（默认 15%）

## 文件结构

```
doctor-strange/
├── ds.js                 # CLI 入口
├── src/
│   ├── config.js         # 配置加载
│   ├── gamma.js         # Gamma API 客户端
│   ├── snapshot.js      # 快照管理
│   ├── alerts.js        # 告警管理
│   ├── formatter.js     # UI 格式化
│   └── cli.js           # CLI 逻辑
├── prompts/             # Phase 2 LLM prompts
├── data/                # 数据目录
│   ├── snapshots/       # 概率快照
│   ├── reports/         # 分析报告
│   └── alerts/          # 告警记录
└── config.json          # 配置文件
```

## 更新

```bash
cd ~/.openclaw/workspace/skills/doctor-strange
git pull
```

## 技术亮点

- **零依赖** — 仅使用 Node.js 原生 API
- **原子写入** — 防止崩溃导致数据损坏
- **错误容忍** — API 重试 + 脏数据安全解析
- **Win11 兼容** — NTFS 文件锁处理

## License

Private — 仅供个人使用。
