---
name: docsync
description: Auto-generate docs from code and detect documentation drift via git hooks. Free README gen + paid living docs.
homepage: https://docsync.pages.dev
metadata:
  {
    "openclaw": {
      "emoji": "📖",
      "primaryEnv": "DOCSYNC_LICENSE_KEY",
      "requires": {
        "bins": ["git", "bash"]
      },
      "install": [
        {
          "id": "lefthook",
          "kind": "brew",
          "formula": "lefthook",
          "bins": ["lefthook"],
          "label": "Install lefthook (git hooks manager)"
        },
        {
          "id": "tree-sitter",
          "kind": "brew",
          "formula": "tree-sitter",
          "bins": ["tree-sitter"],
          "label": "Install tree-sitter (code parser)"
        },
        {
          "id": "difftastic",
          "kind": "brew",
          "formula": "difftastic",
          "bins": ["difft"],
          "label": "Install difftastic (semantic diff)"
        }
      ],
      "os": ["darwin", "linux", "win32"]
    }
  }
user-invocable: true
disable-model-invocation: false
---

# DocSync — Living Documentation for Your Codebase

DocSync generates documentation from your code and keeps it in sync automatically. It uses tree-sitter for multi-language AST parsing, lefthook for git hook integration, and difftastic for semantic change detection.

## Commands

### Free Tier (No license required)

#### `docsync generate <file-or-directory>`
Generate a one-shot README or API doc for a single file or directory.

**How to execute:**
```bash
bash "<SKILL_DIR>/scripts/docsync.sh" generate <target>
```

**What it does:**
1. Parses the target file(s) with tree-sitter to extract symbols (functions, classes, exports, types, interfaces)
2. Applies the appropriate template from `<SKILL_DIR>/templates/`
3. Generates a markdown documentation file alongside the source

**Example usage scenarios:**
- "Generate docs for src/utils/auth.ts" → runs `docsync generate src/utils/auth.ts`
- "Document this whole directory" → runs `docsync generate src/api/`
- "Create a README for this project" → runs `docsync generate .`

### Pro Tier ($29/user/month — requires DOCSYNC_LICENSE_KEY)

#### `docsync drift [directory]`
Scan for documentation drift — find where code has changed but docs haven't been updated.

**How to execute:**
```bash
bash "<SKILL_DIR>/scripts/docsync.sh" drift [directory]
```

**What it does:**
1. Validates license key from config
2. Parses all source files with tree-sitter
3. Compares extracted symbols against existing documentation
4. Reports: new undocumented symbols, changed signatures with stale docs, deleted symbols still in docs
5. Outputs a drift report with severity levels (critical/warning/info)

#### `docsync hooks install`
Install git hooks that automatically check for doc drift on every commit.

**How to execute:**
```bash
bash "<SKILL_DIR>/scripts/docsync.sh" hooks install
```

**What it does:**
1. Validates Pro+ license
2. Copies lefthook config to project root
3. Installs lefthook pre-commit hook
4. On every commit: analyzes staged files, blocks commit if critical drift detected, offers auto-regen

#### `docsync hooks uninstall`
Remove DocSync git hooks.

```bash
bash "<SKILL_DIR>/scripts/docsync.sh" hooks uninstall
```

#### `docsync auto-fix [directory]`
Auto-regenerate stale documentation for files with detected drift.

```bash
bash "<SKILL_DIR>/scripts/docsync.sh" auto-fix [directory]
```

### Team Tier ($49/user/month — requires DOCSYNC_LICENSE_KEY with team tier)

#### `docsync onboarding [directory]`
Generate a comprehensive onboarding guide for new developers.

```bash
bash "<SKILL_DIR>/scripts/docsync.sh" onboarding [directory]
```

#### `docsync architecture [directory]`
Generate architecture documentation showing module relationships and data flow.

```bash
bash "<SKILL_DIR>/scripts/docsync.sh" architecture [directory]
```

## Supported Languages

DocSync uses tree-sitter grammars and supports:
- JavaScript / TypeScript (including JSX/TSX)
- Python
- Rust
- Go
- Java
- C / C++
- Ruby
- PHP
- C#
- Swift
- Kotlin

## Configuration

Users can configure DocSync in `~/.openclaw/openclaw.json`:

```json
{
  "skills": {
    "entries": {
      "docsync": {
        "enabled": true,
        "apiKey": "YOUR_LICENSE_KEY_HERE",
        "config": {
          "outputDir": "docs",
          "templateOverrides": {},
          "excludePatterns": ["**/node_modules/**", "**/dist/**", "**/.git/**"],
          "languages": ["typescript", "python", "go"],
          "driftThreshold": "warning",
          "autoFix": false
        }
      }
    }
  }
}
```

## Important Notes

- **Free tier** works immediately with no configuration
- **Pro/Team tiers** require a license key from https://docsync.pages.dev
- All processing happens **locally** — no code is sent to external servers
- License validation is **offline** — no network calls needed
- Git hooks use **lefthook** which must be installed (see install metadata above)
- tree-sitter and difftastic are optional but recommended for best results; the skill falls back to regex-based parsing if unavailable

## Error Handling

- If tree-sitter is not installed, fall back to regex-based symbol extraction (less accurate but functional)
- If lefthook is not installed and user tries `hooks install`, prompt to install it
- If license key is invalid or expired, show clear message with link to https://docsync.pages.dev/renew
- If a language grammar is not available, skip that file with a warning

## When to Use DocSync

The user might say things like:
- "Generate docs for this file/project"
- "Are my docs up to date?"
- "Check for documentation drift"
- "Set up auto-docs on my commits"
- "Create an onboarding guide"
- "Document the architecture"
- "What's undocumented in this codebase?"
