// Test script for Xunlei Docker Downloader skill
const XunleiDockerSkill = require('./index');

async function testSkill() {
  console.log('Testing Xunlei Docker Downloader skill...\n');
  
  const skill = new XunleiDockerSkill();
  
  // Test help command
  console.log('1. Testing help command:');
  console.log(skill.help());
  console.log('\n');
  
  // Test config show (should show current config or lack thereof)
  console.log('2. Testing config show:');
  try {
    const configResult = await skill.showConfig();
    console.log(configResult);
  } catch (error) {
    console.log('Error showing config:', error.message);
  }
  console.log('\n');
  
  // Test status command (should fail without proper config)
  console.log('3. Testing status command (expected to fail without config):');
  try {
    const statusResult = await skill.getStatus();
    console.log(statusResult);
  } catch (error) {
    console.log('Expected error for status (no config):', error.message);
  }
  console.log('\n');
  
  console.log('Test completed. The skill is properly structured and can be loaded by OpenClaw.');
}

testSkill().catch(console.error);