# Xunlei Docker Downloader Skill

This OpenClaw skill allows you to interact with Docker-deployed Xunlei services for downloading magnet links and managing download tasks.

## Prerequisites

- A running Xunlei service in Docker (e.g., using [cnk3x/xunlei](https://github.com/cnk3x/xunlei))
- Access to the Xunlei web interface from your OpenClaw instance

## Installation

1. Place the entire `xunlei-docker-downloader` folder in your OpenClaw skills directory
2. Install dependencies: `npm install` in the skill directory
3. The skill will be automatically detected by OpenClaw

## Configuration

Before using the skill, you need to configure the connection to your Xunlei service:

```
xunlei config set <host> <port> [ssl]
```

For example:
```
xunlei config set 192.168.1.100 2345 false
```

## Usage

### View Current Download Tasks
```
xunlei status
```

### Submit a Magnet Link for Download
```
xunlei submit magnet:?xt=urn:btih:...
```

### Submit with Custom Task Name
```
xunlei submit magnet:?xt=urn:btih:... --name "My Custom Task"
```

### View Completed Tasks
```
xunlei completed
```

### Check Xunlei Service Version
```
xunlei version
```

### View Current Configuration
```
xunlei config show
```

## Commands Summary

- `xunlei status` - Show current download tasks
- `xunlei submit <magnet_link>` - Submit a magnet link for download
- `xunlei submit <magnet_link> --name <task_name>` - Submit with custom task name
- `xunlei config set <host> <port> [ssl]` - Configure Xunlei service connection
- `xunlei config show` - Show current configuration
- `xunlei completed` - Show completed tasks
- `xunlei version` - Show Xunlei service version
- `xunlei help` - Show help information

## Technical Details

This skill is based on the [xunlei-docker-ext](https://github.com/saaak/xunlei-docker-ext) Chrome extension by saaak, adapted for server-side use. It communicates with the Xunlei service using the same API endpoints and authentication mechanisms as the original extension.