# Xunlei Docker Downloader Skill Configuration

## Required Configuration

This skill requires the following configuration to connect to your Docker-deployed Xunlei service:

```yaml
xunlei:
  host: "192.168.1.100"    # IP address of your Xunlei Docker container
  port: 2345               # Port of your Xunlei web interface
  ssl: false               # Whether to use HTTPS (default: false)
```

## Configuration Methods

### Method 1: Using Commands
You can configure the skill directly using OpenClaw commands:
```
xunlei config set <host> <port> [ssl]
```

### Method 2: Manual Configuration
Create a `config.json` file in the skill directory with the following structure:
```json
{
  "host": "192.168.1.100",
  "port": 2345,
  "ssl": false
}
```

## Finding Your Xunlei Service Details

1. Find your Xunlei Docker container IP address:
   - On the same host: usually `localhost` or `127.0.0.1`
   - On a different machine: use the machine's IP address
   - In Docker: you can use `docker inspect <container_name>` to find the IP

2. Find your Xunlei service port:
   - Default port for cnk3x/xunlei is typically 2345
   - Check your Docker run command or compose file for the port mapping

## Troubleshooting

### Connection Issues
- Verify that the Xunlei service is running and accessible
- Check firewall settings on both the client and server
- Ensure the port is correctly mapped in Docker

### Authentication Issues
- Make sure you're using the correct authentication method
- Some versions of Xunlei may require different authentication approaches

### Network Issues
- Ensure that OpenClaw can reach the Xunlei service
- Test connectivity with a simple ping or curl command