---
name: Docker Compose
description: Define multi-container applications with proper dependency handling, networking, and volume management.
metadata: {"clawdbot":{"emoji":"🐳","requires":{"anyBins":["docker-compose","docker"]},"os":["linux","darwin","win32"]}}
---

## depends_on Ready Condition

- `depends_on:` alone only waits for container start—service likely not ready yet
- Add healthcheck + condition for actual readiness:
```yaml
depends_on:
  db:
    condition: service_healthy
```
- Without healthcheck defined on target service, `service_healthy` fails

## Healthcheck start_period

```yaml
healthcheck:
  test: ["CMD", "pg_isready"]
  start_period: 30s
```
- `start_period`: initial grace period—health failures don't count during this time
- Slow-starting services (databases, Java apps) need adequate start_period
- Without it, container marked unhealthy before it finishes initializing

## Volume Destruction

- `docker compose down` preserves volumes
- `docker compose down -v` DELETES ALL VOLUMES—data loss
- `-v` often added by habit from tutorials—catastrophic in production
- Named volumes survive `down`; anonymous volumes deleted on `down`

## Resource Limits in Development

```yaml
deploy:
  resources:
    limits:
      memory: 512M
```
- Set limits during development—catches memory issues early
- Unlimited container can consume all host memory—kills other processes
- Copy limits to production config—don't discover limits in prod

## .dockerignore

- Without it: `node_modules`, `.git`, secrets copied into image
- Mirrors `.gitignore` syntax—create at same level as Dockerfile
- Large build context = slow builds, large images, potential security issues
- At minimum: `.git`, `node_modules`, `.env`, `*.log`, build artifacts

## Override File Pattern

- `docker-compose.yml`: base config that works everywhere
- `docker-compose.override.yml`: auto-loaded, development-specific (mounts, ports)
- Production: `docker compose -f docker-compose.yml -f docker-compose.prod.yml up`
- Keep secrets and environment-specific config in override files, not base

## Profiles for Optional Services

```yaml
services:
  mailhog:
    profiles: [dev]
```
- Services with profiles don't start by default—cleaner `docker compose up`
- Enable with `--profile dev`
- Use for: test databases, debug tools, mock services, admin interfaces

## Environment Variable Precedence

1. Shell environment (highest)
2. `.env` file in compose directory
3. `env_file:` directive
4. `environment:` in compose file (lowest for that var)
- `.env` must be exactly `.env`—`.env.local` not auto-loaded
- Debug with `docker compose config`—shows resolved values
