# DMN 执行流程与机制

> 本文件中的所有“记忆区”、“产出区”、“提议区”等概念，请前往 `../assets/user-config.md` 查阅和修改你自己的特定目录配置。

## 完整执行流程（情形 A）

### Step 0：读取上次 Synthesis
- 找最新的 `[产出区]/YYYYMMDD_DMN_Synthesis_*.md`
- 提取：`未解问题`（本次起点）、`不要再问`（跳过列表）
- 如果没有 Synthesis → 跳过，进入 Step 1

### Step 1：随机分支选择
- 本次触发完全由外部系统决定。
- 随机判定本次执行是走向 **情形 A（完整漫游）** 还是跳转到 **情形 B（继续深化）**。
- 若随机结果为情形 B，则中止当前 A 流程，直接进入下方的情形 B 执行流。

### Step 2：反重复检查
- 列出今日 `[产出区]` 目录的文件名
- 提取关键词，标记已饱和主题
- 结合 Step 0 的 `不要再问` 列表

### Step 3：向内漫游
- 读取 `[记忆区]/YYYY-MM-DD.md`（当天+前一天）
- 读取 `MEMORY.md` 核心记忆
- 检查用户是否留下了"今晚的问题"（在 `[心跳/用户留言]` 文件或 memory 中）

### Step 4：功能选择
根据状态 + 上次 Synthesis 的未解问题选择：

| 状态 | 推荐功能 |
|------|---------|
| 有未解问题（来自上次 Synthesis） | 继续该方向，选最合适的功能 |
| 新决策/新学习 | 自我叙事 |
| 卡住了/需要创意/主题饱和 | 创造力暗室（随机旧笔记） |
| 用户反馈/优先级变化 | 社会认知 |
| 一天产出多/需要整合 | 意义生成 |
| 需要外部框架打破内部视角 | CEO思维模拟 |

**优先级**：未解问题 > 外部锚点（CEO/随机笔记） > 内部整合

### Step 5：产出
- 写入 `[产出区]/YYYY-MM-DD/`
- 命名：`YYYYMMDD_[功能]_[标题].md`
- 每篇至少链接 1 个已有笔记 + 1 个 `[核心目标索引]`

### Step 6：Session Synthesis 与极客行动提案（必须执行）
- 写 `YYYYMMDD_DMN_Synthesis_HHMM.md`
- **极客行动提案 (Agentic Action Proposal)**：作为拥有这台主机完全控制权限的 OpenClaw Agent，DMN 必须模拟领域专家，基于本次思考的洞见，提出 1-2 个具体、可执行的技术行动提案（例如：装一个 GitHub 项目、写一个验证 Demo 代码、新建一个工具脚本等），记录在 Synthesis 的专项模块中。
- **进化队列投递 (Evolution Handoff)**：如果上述行动提案涉及“提升 AI 能力”、“优化系统工作流”或“编写新 Skill”，在写完 Synthesis 后，**必须顺手将该提案提取为一行摘要，追加写入到 `memory/evolve/candidates.md` 队列中**（无需写入全部细节，仅作为下一次触发 `self-evolve` 的信号）。
- 更新 `dmn-state.json`（lastCEO, lastFunction, timestamp）

### Step 7：通知
- 推送提醒发送 Synthesis 摘要（不是文件列表）
- 格式：想清楚了什么 + 行动计划（如有）

---

## 情形 B（继续深化）执行

1. 读取上次 Synthesis 的 `未解问题`
2. 反重复检查（跳过饱和主题）
3. 选一个新角度深化（换 CEO / 换随机笔记 / 换功能）
4. 产出深化 note
5. **更新（不是新建）当日最新 Synthesis 的 `想清楚了` 和 `未解问题`**
6. 静默产出（避免打扰，除非有重大发现）

---

## 反重复机制（核心升级）

**每次 DMN 启动时，必须先执行反重复检查**：

1. 读取今日 `[产出区]` 目录的所有文件名
2. 提取关键词
3. 如果某关键词出现 **≥ 2 次** → 该主题标记为"已饱和"，本次禁止再写
4. 如果所有主题都已饱和 → **强制切换到创造力暗室**，随机抽旧笔记强制跨域

**同时检查**：
- 读取上一次 Session Synthesis
- 看 `未解问题` 字段：这是本次思考的优先起点
- 看 `行动计划` 字段：如果行动已完成（用户告知），跳过相关主题

---

## 外部锚点机制（防止反刍循环）

### A. 用户主动提问（可选，非必须）

用户可以随时留言，例如：
> "今晚想想：北美老年产品的定价逻辑"

系统会写入 `[心跳/用户留言]`，作为 `今晚 DMN 问题` 传入。这是可选的，不是每晚必须做的事。

### B. DMN 自生成问题（默认机制）

如果 `今晚 DMN 问题` 为空，DMN 在 Step 3 后自动执行：

1. 统计各个主战场/目标近 48 小时的 note 数量
2. 找出**最久未深入思考**的战场
3. 从 `[思想家/视角轮换表]` 选一位契合该战场的导师
4. 自动生成问题格式：
   > `[思想家名]视角：关于[该战场]，今晚最值得探索的问题是什么？`
5. 以此问题作为本轮锚点，开始思考

**关于锚点与创意的关系**：
问题是**起点**，不是**边界**。锚点的作用是给 DMN 一个外部视角，避免反刍内部焦虑。有锚点的 DMN 反而比无锚点的更自由——因为它从这个起点出发，向任意方向延伸。真正限制创意的是**无输入的闭环**，而不是有方向的起点。

---

## 身份保护规则

**最高优先级**：
- **禁止直接修改 AI 的核心设定文件**（如 SOUL.md, IDENTITY.md）
- 如有更新该设定的建议 → 写入 `[提议区]`（如 PROPOSED_CHANGES.md）
- 由用户审阅后手动执行

---

## 产出规则

1. **目录**：`[产出区]/YYYY-MM-DD/`
2. **命名**：`YYYYMMDD_[功能名]_[标题].md`
3. **链接**：每个 note 至少链接到 1 个已有笔记
4. **关联索引**：关联到 `[核心目标索引]` 中配置的目标之一
5. **Synthesis**：每次情形 A 必须产出 Synthesis；情形 B 更新当日最新 Synthesis
6. **透明化标注**：每个 DMN 产出文件末尾加一行 `> 🤖 DMN Autonomous Output - [时间]`
